/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.lsst.ccs.subsystem.common.ui.TextFieldX;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.refrig.constants.TrimHeaterOpState;
import org.lsst.ccs.subsystem.refrig.constants.TrimHeaterState;
import org.lsst.ccs.subsystem.refrig.data.ThermalState;

public class TrimHeaterPanel
extends JPanel
implements UiUtilities.ActionHandler {
    private static final String[] plateNames = new String[7];
    private static final int labelWidth;
    private static final int stateWidth;
    private static final Map<TrimHeaterState, Color> stateColors;
    private static final int horzInset;
    private final int id;
    private final CommandSender sender;
    private final UiUtilities uiUtils;
    private JLabel controlLabel;
    private JLabel controlState;
    private JLabel powerUnitsLabel;
    private JLabel tempUnitsLabel;
    private ButtonGroup controlBG;
    private JRadioButton controlOffRB;
    private JRadioButton controlPowerRB;
    private JRadioButton controlTempRB;
    private TextFieldX powerTextField;
    private TextFieldX tempTextField;
    private static final long serialVersionUID = 1L;

    TrimHeaterPanel(int id, CommandSender sender) {
        this.id = id;
        this.sender = sender;
        this.uiUtils = new UiUtilities((UiUtilities.ActionHandler)this);
        this.initComponents();
    }

    public void updatePanel(ThermalState rs) {
        this.controlState.setEnabled(true);
        TrimHeaterState tState = rs.getTrimHeaterState(this.id);
        this.controlState.setText(tState.name());
        Color color = stateColors.get((Object)tState);
        color = color == null ? UiConstants.PURPLE : color;
        this.controlState.setForeground(color);
        TrimHeaterOpState tOpState = rs.getTrimHeaterOpState(this.id);
        JRadioButton selButton = tOpState == TrimHeaterOpState.POWER ? this.controlPowerRB : (tOpState == TrimHeaterOpState.TEMP ? this.controlTempRB : this.controlOffRB);
        selButton.setSelected(true);
        boolean online = tState != TrimHeaterState.OFFLINE;
        this.controlOffRB.setEnabled(online && selButton != this.controlOffRB);
        this.controlPowerRB.setEnabled(online && selButton != this.controlPowerRB);
        this.controlTempRB.setEnabled(online && selButton != this.controlTempRB);
        this.powerTextField.update((Object)rs.getTrimHeaterPower(this.id), true);
        this.tempTextField.update((Object)rs.getPlateTemperature(this.id), true);
        this.repaint();
    }

    public void disablePanel() {
        this.controlState.setEnabled(false);
        this.controlOffRB.setEnabled(false);
        this.controlPowerRB.setEnabled(false);
        this.controlTempRB.setEnabled(false);
        this.powerTextField.setDisabled();
        this.tempTextField.setDisabled();
        this.repaint();
    }

    private void initComponents() {
        this.controlLabel = UiUtilities.newLabel((String)(plateNames[this.id] + ":"), (int)labelWidth);
        this.controlState = UiUtilities.newLabel((String)"OFF", (int)stateWidth);
        this.controlOffRB = this.uiUtils.newRadioButton("Off", "O");
        this.controlPowerRB = this.uiUtils.newRadioButton("Power", "P");
        this.controlTempRB = this.uiUtils.newRadioButton("Temp", "T");
        this.controlBG = new ButtonGroup();
        this.controlBG.add(this.controlOffRB);
        this.controlBG.add(this.controlPowerRB);
        this.controlBG.add(this.controlTempRB);
        this.powerTextField = this.uiUtils.newTextFieldX("99999.9", "P", 2, true);
        this.powerUnitsLabel = UiUtilities.newLabel((String)"W", (int)0);
        this.tempTextField = this.uiUtils.newTextFieldX("-99999.9", "T", 2, true);
        this.tempUnitsLabel = UiUtilities.newLabel((String)"\u00b0C", (int)0);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, horzInset, 0, horzInset);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        this.add((Component)this.controlLabel, gbc);
        ++gbc.gridx;
        this.add((Component)this.controlState, gbc);
        ++gbc.gridx;
        this.add((Component)this.controlOffRB, gbc);
        ++gbc.gridx;
        gbc.insets.right = 0;
        this.add((Component)this.controlPowerRB, gbc);
        ++gbc.gridx;
        this.add((Component)this.powerTextField, gbc);
        ++gbc.gridx;
        gbc.insets.right = horzInset;
        this.add((Component)this.powerUnitsLabel, gbc);
        ++gbc.gridx;
        gbc.insets.right = 0;
        this.add((Component)this.controlTempRB, gbc);
        ++gbc.gridx;
        this.add((Component)this.tempTextField, gbc);
        ++gbc.gridx;
        gbc.insets.right = horzInset;
        this.add((Component)this.tempUnitsLabel, gbc);
    }

    public void handleRadioButton(String name) {
        this.controlOffRB.setEnabled(false);
        this.controlPowerRB.setEnabled(false);
        this.controlTempRB.setEnabled(false);
        char btn = name.charAt(0);
        this.sender.sendCommand(null, "setTrimHeaterState", new Object[]{this.id, btn == 'P' ? TrimHeaterOpState.POWER : (btn == 'T' ? TrimHeaterOpState.TEMP : TrimHeaterOpState.OFF)});
    }

    public void handleTextFieldX(String name, Object value) {
        this.sender.sendCommand(null, name.charAt(0) == 'P' ? "setTrimHeaterPower" : "setPlateTemperature", new Object[]{this.id, (Double)value});
    }

    static {
        TrimHeaterPanel.plateNames[1] = "Cold (all)";
        TrimHeaterPanel.plateNames[4] = "Cold Center";
        TrimHeaterPanel.plateNames[5] = "Cold -Y Ctr";
        TrimHeaterPanel.plateNames[6] = "Cold +Y Ctr";
        TrimHeaterPanel.plateNames[2] = "Cold -Y End";
        TrimHeaterPanel.plateNames[3] = "Cold +Y End";
        TrimHeaterPanel.plateNames[0] = "Cryo";
        labelWidth = UiUtilities.maxLabelWidth((String[])plateNames, (String)":");
        stateWidth = UiUtilities.maxEnumLabelWidth(TrimHeaterState.class);
        stateColors = new HashMap<TrimHeaterState, Color>();
        stateColors.put(TrimHeaterState.OFF, Color.BLACK);
        stateColors.put(TrimHeaterState.POWER, UiConstants.YELLOW);
        stateColors.put(TrimHeaterState.TEMP, UiConstants.GREEN);
        stateColors.put(TrimHeaterState.OFFLINE, UiConstants.BLUE);
        stateColors.put(TrimHeaterState.DISABLD, UiConstants.RED);
        stateColors.put(TrimHeaterState.VOLTERR, UiConstants.PURPLE);
        stateColors.put(TrimHeaterState.NOLOAD, UiConstants.PURPLE);
        stateColors.put(TrimHeaterState.OVRTEMP, UiConstants.RED);
        horzInset = UiUtilities.getLabelSize((String)"M").width / 2;
    }
}

