/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.imagenaming;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.imagenaming.Controller;
import org.lsst.ccs.imagenaming.Source;

public class ImageName
implements Serializable,
Comparable<ImageName> {
    private static final Pattern NAME_PATTERN = Pattern.compile("(\\w\\w)(\\d*)_(\\w)_(\\d{8})_(\\d+)");
    static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final long serialVersionUID = 8767898207051188380L;
    private final Source source;
    private final Controller controller;
    private final LocalDate date;
    private final int number;
    private final int sourceIndex;

    public ImageName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Invalid null image name ");
        }
        Matcher matcher = NAME_PATTERN.matcher(name);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid image name " + name);
        }
        this.source = Source.fromCode(matcher.group(1));
        this.controller = Controller.fromCode(matcher.group(3));
        this.number = Integer.parseInt(matcher.group(5));
        if (this.number <= 0) {
            throw new IllegalArgumentException("Image number must be > 0");
        }
        this.sourceIndex = matcher.group(2).length() > 0 ? Integer.parseInt(matcher.group(2)) : 0;
        this.checkSourceIndex(this.sourceIndex, this.source);
        try {
            this.date = LocalDate.parse(matcher.group(4), FORMATTER);
        }
        catch (DateTimeParseException x) {
            throw new IllegalArgumentException("Invalid date field", x);
        }
    }

    ImageName(Source source, Controller controller, LocalDate date, int imageNumber) {
        this(source, 0, controller, date, imageNumber);
    }

    ImageName(Source source, int sourceIndex, Controller controller, LocalDate date, int imageNumber) {
        this.checkSourceIndex(sourceIndex, source);
        this.source = source;
        this.controller = controller;
        this.date = date;
        this.number = imageNumber;
        this.sourceIndex = sourceIndex;
    }

    private void checkSourceIndex(int sourceIndex, Source source) throws IllegalArgumentException {
        if (sourceIndex > 0 && !source.isIndexed()) {
            throw new IllegalArgumentException("Source index not allowed with source=" + source);
        }
        if (sourceIndex < 0 || sourceIndex > 9999) {
            throw new IllegalArgumentException("Invalid source index: " + sourceIndex);
        }
    }

    public Source getSource() {
        return this.source;
    }

    public int getSourceIndex() {
        return this.sourceIndex;
    }

    public String getSourceWithIndex() {
        return ImageName.getSourceWithIndex(this.source, this.sourceIndex);
    }

    static String getSourceWithIndex(Source source, int sourceIndex) {
        return sourceIndex == 0 ? source.getCode() : source.getCode() + sourceIndex;
    }

    public Controller getController() {
        return this.controller;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public String getDateString() {
        return FORMATTER.format(this.date);
    }

    public int getNumber() {
        return this.number;
    }

    public String getNumberString() {
        return String.format("%06d", this.number);
    }

    public String toString() {
        return String.format("%s_%s_%s_%06d", this.getSourceWithIndex(), this.controller.getCode(), FORMATTER.format(this.date), this.number);
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode((Object)this.source);
        hash = 97 * hash + Objects.hashCode((Object)this.controller);
        hash = 97 * hash + Objects.hashCode(this.date);
        hash = 97 * hash + this.number;
        hash = 97 * hash + this.sourceIndex;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImageName other = (ImageName)obj;
        if (this.number != other.number) {
            return false;
        }
        if (this.source != other.source) {
            return false;
        }
        if (this.sourceIndex != other.sourceIndex) {
            return false;
        }
        if (this.controller != other.controller) {
            return false;
        }
        return Objects.equals(this.date, other.date);
    }

    @Override
    public int compareTo(ImageName other) {
        int c = this.date.compareTo(other.date);
        if (c != 0) {
            return c;
        }
        c = Integer.compare(this.number, other.number);
        if (c != 0) {
            return c;
        }
        c = this.source.compareTo(other.source);
        if (c != 0) {
            return c;
        }
        c = Integer.compare(this.sourceIndex, other.sourceIndex);
        if (c != 0) {
            return c;
        }
        return this.controller.compareTo(other.controller);
    }
}

