/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.services.lock;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeListener;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.gconsole.services.lock.LockService;
import org.lsst.ccs.gconsole.services.lock.Locker;

public class Lock
extends JLabel {
    public static final ImageIcon ICON_UNLOCKED = new ImageIcon(Lock.class.getResource("black_unlocked_24.png"), "unlocked black");
    public static final ImageIcon ICON_UNLOCKED_OFFLINE = new ImageIcon(Lock.class.getResource("gray_unlocked_24.png"), "unlocked gray");
    public static final ImageIcon ICON_LOCKED = new ImageIcon(Lock.class.getResource("black_locked_24.png"), "locked black");
    public static final ImageIcon ICON_LOCKED_OFFLINE = new ImageIcon(Lock.class.getResource("gray_locked_24.png"), "locked gray");
    public static final ImageIcon ICON_DETACHED = new ImageIcon(Lock.class.getResource("red_locked_24.png"), "locked red");
    public static final ImageIcon ICON_DETACHED_OFFLINE = new ImageIcon(Lock.class.getResource("light_red_locked_24.png"), "locked light red");
    public static final ImageIcon ICON_ATTACHED = new ImageIcon(Lock.class.getResource("green_locked_24.png"), "locked green");
    public static final ImageIcon ICON_ATTACHED_OFFLINE = new ImageIcon(Lock.class.getResource("light_green_locked_24.png"), "locked green");
    public static final EnumMap<LockService.State, ImageIcon> ICON = new EnumMap(LockService.State.class);
    public static final EnumMap<LockService.State, ImageIcon> ICON_OFFLINE;
    private final String agent;
    private boolean online;
    private LockService.State state;
    private ArrayList<Listener> listeners;
    private final ChangeListener lockerListener = e -> this.update();
    private final LockService.Listener lockServiceListener = new LockService.Listener(){

        @Override
        public void agentsAdded(Locker ... agents) {
            for (Locker locker : agents) {
                if (!locker.getName().equals(Lock.this.agent)) continue;
                locker.addListener(Lock.this.lockerListener);
                break;
            }
            Lock.this.update();
        }

        @Override
        public void agentsRemoved(Locker ... agents) {
            for (Locker locker : agents) {
                if (!locker.getName().equals(Lock.this.agent)) continue;
                locker.removeListener(Lock.this.lockerListener);
                break;
            }
            Lock.this.update();
        }

        @Override
        public void userChanged(String oldUserID, String newUserID) {
            Lock.this.update();
        }
    };

    public Lock(String agentName) {
        this.agent = agentName;
    }

    @Override
    public void removeNotify() {
        LockService serv = LockService.getService();
        serv.removeListener(this.lockServiceListener);
        Locker locker = serv.getAgent(this.agent);
        if (locker != null) {
            locker.removeListener(this.lockerListener);
        }
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        LockService serv = LockService.getService();
        serv.addListener(this.lockServiceListener);
        Locker locker = serv.getAgent(this.agent);
        if (locker != null) {
            locker.addListener(this.lockerListener);
        }
        this.update();
    }

    public LockService.State getState() {
        return this.state;
    }

    public boolean isOnline() {
        return this.online;
    }

    public static ImageIcon getIcon(String agentName) {
        Locker locker = LockService.getService().getAgent(agentName);
        if (locker == null) {
            return ICON_UNLOCKED_OFFLINE;
        }
        LockService.State state = locker.getState();
        return locker.isOnline() ? ICON.get((Object)state) : ICON_OFFLINE.get((Object)state);
    }

    private void update() {
        Locker locker = LockService.getService().getAgent(this.agent);
        if (locker == null) {
            this.online = false;
            this.state = LockService.State.UNLOCKED;
            this.setIcon(ICON_UNLOCKED_OFFLINE);
            this.setToolTipText("Subsystem offline, unlocked");
            this.setEnabled(true);
        } else {
            this.online = locker.isOnline();
            this.state = locker.getState();
            if (locker.isAdjusting()) {
                this.setEnabled(false);
                this.setToolTipText("Waiting for response from Lock Manager");
            } else {
                this.setEnabled(true);
            }
            switch (this.state) {
                case UNLOCKED: {
                    if (this.online) {
                        this.setIcon(ICON_UNLOCKED);
                        this.setToolTipText("Unlocked");
                        break;
                    }
                    this.setIcon(ICON_UNLOCKED_OFFLINE);
                    this.setToolTipText("Unlocked, Offline");
                    break;
                }
                case LOCKED: {
                    if (this.online) {
                        this.setIcon(ICON_LOCKED);
                        this.setToolTipText("Locked by " + locker.getLock().getOwner());
                        break;
                    }
                    this.setIcon(ICON_LOCKED_OFFLINE);
                    this.setToolTipText("Locked by " + locker.getLock().getOwner() + ", Offline");
                    break;
                }
                case DETACHED: {
                    if (this.online) {
                        this.setIcon(ICON_DETACHED);
                        this.setToolTipText("Locked, Detached");
                        break;
                    }
                    this.setIcon(ICON_DETACHED_OFFLINE);
                    this.setToolTipText("Locked, Detached, Offline");
                    break;
                }
                case ATTACHED: {
                    if (this.online) {
                        this.setIcon(ICON_ATTACHED);
                        this.setToolTipText("Locked, level " + locker.getLevel());
                        break;
                    }
                    this.setIcon(ICON_ATTACHED_OFFLINE);
                    this.setToolTipText("Locked, Offline");
                }
            }
        }
        if (this.listeners != null) {
            this.listeners.forEach(l -> l.update(this));
        }
    }

    @Override
    public JPopupMenu getComponentPopupMenu() {
        LockService lockService = LockService.getService();
        Locker locker = lockService.getAgent(this.agent);
        if (locker == null || locker.isAdjusting()) {
            return null;
        }
        AgentLock lock = locker.getLock();
        boolean canSetLevel = lock == null || lock.getMaxLevel() > 0;
        JPopupMenu menu = new JPopupMenu();
        switch (locker.getState()) {
            case UNLOCKED: {
                menu.add(LockService.Operation.LEVEL.getAction(this.agent));
                menu.add(LockService.Operation.LOCK.getAction(this.agent));
                break;
            }
            case LOCKED: {
                menu.add(LockService.Operation.DESTROY.getAction(this.agent));
                break;
            }
            case DETACHED: {
                if (canSetLevel) {
                    menu.add(LockService.Operation.LEVEL.getAction(this.agent));
                }
                menu.add(LockService.Operation.ATTACH.getAction(this.agent));
                menu.add(LockService.Operation.UNLOCK.getAction(this.agent));
                break;
            }
            case ATTACHED: {
                if (canSetLevel) {
                    menu.add(LockService.Operation.LEVEL.getAction(this.agent));
                }
                menu.add(LockService.Operation.DETACH.getAction(this.agent));
                menu.add(LockService.Operation.UNLOCK.getAction(this.agent));
            }
        }
        return menu;
    }

    public void addListener(Listener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(1);
        } else {
            this.listeners.ensureCapacity(this.listeners.size() + 1);
        }
        this.listeners.add(listener);
    }

    public boolean removeListener(Listener listener) {
        boolean out = false;
        Iterator<Listener> it = this.listeners.iterator();
        while (it.hasNext()) {
            if (listener != it.next()) continue;
            it.remove();
            out = true;
        }
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        } else {
            this.listeners.trimToSize();
        }
        return out;
    }

    public boolean removeAllListeners() {
        boolean out = this.listeners != null;
        this.listeners = null;
        return out;
    }

    static {
        ICON.put(LockService.State.LOCKED, ICON_LOCKED);
        ICON.put(LockService.State.UNLOCKED, ICON_UNLOCKED);
        ICON.put(LockService.State.DETACHED, ICON_DETACHED);
        ICON.put(LockService.State.ATTACHED, ICON_ATTACHED);
        ICON_OFFLINE = new EnumMap(LockService.State.class);
        ICON_OFFLINE.put(LockService.State.LOCKED, ICON_LOCKED_OFFLINE);
        ICON_OFFLINE.put(LockService.State.UNLOCKED, ICON_UNLOCKED_OFFLINE);
        ICON_OFFLINE.put(LockService.State.DETACHED, ICON_DETACHED_OFFLINE);
        ICON_OFFLINE.put(LockService.State.ATTACHED, ICON_ATTACHED_OFFLINE);
    }

    public static interface Listener {
        public void update(Lock var1);
    }
}

