/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.alert;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.lsst.ccs.gconsole.base.Const;
import org.lsst.ccs.gconsole.plugins.alert.AlertViewer;

public class MuteDialog
extends JDialog {
    private boolean ok;
    private final JButton okButton;
    private final JTextField agentField;
    private final JTextField regExField;
    private final JTextField minutesField;

    MuteDialog(Component parent, String agentSeed, String regExSeed) {
        super(parent == null ? null : SwingUtilities.getWindowAncestor(parent), "Mute alerts", Dialog.ModalityType.APPLICATION_MODAL);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MuteDialog.this.dispose();
            }
        });
        JPanel inputPanel = new JPanel(new GridLayout(3, 1));
        this.add((Component)inputPanel, "Center");
        Box box = Box.createHorizontalBox();
        box.add(Box.createRigidArea(Const.HDIM));
        box.add(new JLabel("Subsystem"));
        box.add(Box.createRigidArea(Const.HDIM));
        this.agentField = new JTextField(agentSeed);
        this.agentField.addCaretListener(e -> this.validateInput());
        box.add(this.agentField);
        box.add(Box.createRigidArea(Const.HDIM));
        box.setToolTipText("Subsystem name:");
        inputPanel.add(box);
        box = Box.createHorizontalBox();
        box.add(Box.createRigidArea(Const.HDIM));
        box.add(new JLabel("Reg Ex:"));
        box.add(Box.createRigidArea(Const.HDIM));
        this.regExField = new JTextField(regExSeed);
        this.regExField.addCaretListener(e -> this.validateInput());
        box.add(this.regExField);
        box.add(Box.createRigidArea(Const.HDIM));
        box.setToolTipText("Regular expression to match against alert ID");
        inputPanel.add(box);
        box = Box.createHorizontalBox();
        box.add(Box.createRigidArea(Const.HDIM));
        box.add(new JLabel("Duration:"));
        box.add(Box.createRigidArea(Const.HDIM));
        this.minutesField = new JTextField();
        this.minutesField.addCaretListener(e -> this.validateInput());
        box.add(this.minutesField);
        box.add(Box.createRigidArea(Const.HDIM));
        box.add(new JLabel("minutes."));
        box.add(Box.createRigidArea(Const.HDIM));
        box.setToolTipText("Keep muted for the specified number of minutes. No more than 3 hours.");
        inputPanel.add(box);
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.setAlignmentX(0.0f);
        buttonBox.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        buttonBox.add(Box.createRigidArea(Const.HDIM2));
        buttonBox.add(Box.createHorizontalGlue());
        this.okButton = new JButton(" OK ");
        this.okButton.addActionListener(e -> {
            String agent = this.validateAgent();
            String regEx = this.validateRegEx();
            int seconds = this.validateMinutes() * 60;
            if (agent != null && regEx != null && seconds > 0) {
                this.ok = true;
                if (regEx.isBlank()) {
                    AlertViewer.sendCommandToMMM("muteAllAlertsForSubsystem", agent, seconds);
                } else {
                    AlertViewer.sendCommandToMMM("muteAlertsForSubsystem", agent, regEx, seconds);
                }
                this.dispose();
            }
        });
        buttonBox.add(this.okButton);
        buttonBox.add(Box.createRigidArea(Const.HDIM2));
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(e -> this.dispose());
        buttonBox.add(cancelButton);
        buttonBox.add(Box.createRigidArea(Const.HDIM2));
        this.add((Component)buttonBox, "South");
    }

    static MuteDialog show(Component parent, String agent, String regEx) {
        MuteDialog d = new MuteDialog(parent, agent, regEx);
        d.setSize(d.getPreferredSize());
        d.pack();
        d.setLocationRelativeTo(parent);
        d.setVisible(true);
        return d;
    }

    private String validateRegEx() {
        String text = this.regExField.getText().trim();
        try {
            Pattern.compile(text);
            this.regExField.setForeground(null);
            return text;
        }
        catch (PatternSyntaxException x) {
            this.regExField.setForeground(Color.RED);
            return null;
        }
    }

    private String validateAgent() {
        String text = this.agentField.getText().trim();
        if (Const.AGENT_NAME_PATTERN.matcher(text).matches()) {
            this.agentField.setForeground(null);
            return text;
        }
        this.agentField.setForeground(Color.RED);
        return null;
    }

    private int validateMinutes() {
        String text = this.minutesField.getText().trim();
        try {
            int minutes = Integer.parseInt(text);
            if (minutes > 0 && minutes <= 180) {
                this.minutesField.setForeground(null);
                return minutes;
            }
            throw new NumberFormatException("Should be 0 < minutes <= 300");
        }
        catch (NumberFormatException x) {
            this.minutesField.setForeground(Color.RED);
            return -1;
        }
    }

    private boolean validateInput() {
        String agent = this.validateAgent();
        String regEx = this.validateRegEx();
        int minutes = this.validateMinutes();
        boolean valid = agent != null && regEx != null && minutes != -1;
        this.okButton.setEnabled(valid);
        return valid;
    }
}

