/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.services.DataProviderDictionaryService;

public class FcsActions {

    public static enum MobileItemAction implements ActionCounterPath
    {
        UNLOCK("UNLOCKING CLAMP", "IS UNLOCKED", "COULD NOT UNLOCK CLAMP"),
        RELEASE("RELEASING CLAMP", "IS RELEASED", "COULD NOT RELEASE CLAMP"),
        UNLOCK_CLAMPS("UNLOCKING CLAMPS", "CLAMPS ARE UNLOCKED", "COULD NOT UNLOCK CLAMPS"),
        RELEASE_CLAMPS("RELEASING CLAMPS", "CLAMPS ARE RELEASED", "COULD NOT RELEASE CLAMPS"),
        ROTATE_CAROUSEL_TO_RELATIVE_POSITION("ROTATING CAROUSEL", "CAROUSEL ROTATION IS COMPLETED", "COULD NOT ROTATE CAROUSEL"),
        ROTATE_CAROUSEL_TO_ABSOLUTE_POSITION("ROTATING CAROUSEL", "CAROUSEL ROTATION IS COMPLETED", "COULD NOT ROTATE CAROUSEL"),
        OPEN("OPENING LATCH", "IS OPENED", "COULD NOT OPEN LATCH"),
        CLOSE("CLOSING LATCH", "IS CLOSED", "COULD NOT CLOSE LATCH"),
        CLOSE_ONLINECLAMP_MODE_CURRENT("CLOSING ONLINECLAMP", "IS CLOSED", "COULD NOT CLOSE ONLINECLAMP"),
        CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION("CLOSING ONLINECLAMP", "IS CLOSED", "COULD NOT CLOSE ONLINECLAMP"),
        LOCK_ONLINECLAMP("LOCKING ONLINECLAMP", "IS LOCKED", "COULD NOT LOCK ONLINECLAMP"),
        OPEN_ONLINECLAMP_MODE_CURRENT("OPENING ONLINECLAMP CURRENT MODE", "IS OPENED", "COULD NOT OPEN ONLINECLAMP"),
        OPEN_HOMING_ONLINECLAMP("OPEN HOMING ONLINE CLAMPS", "IS OPENED AND HOMING DONE", "COULD NOT OPEN AND DO HOMING"),
        OPEN_HALFWAY_RELATIVE_POSITION("OPEN HALFWAY RELATIVE POSITION", "IS HALFWAY BETWEEN OPEN AND CLOSE", "COULD NOT MOVE IN RELATIVE POSITION"),
        REOPEN_ONLINECLAMP_MODE_CURRENT("OPENING ONLINECLAMP CURRENT MODE", "IS OPENED", "COULD NOT OPEN ONLINECLAMP"),
        OPEN_ONLINECLAMP_MODE_PROFILE_POSITION("OPENING ONLINECLAMP", "IS OPENED", "COULD NOT OPEN ONLINECLAMP"),
        OPEN_ONLINECLAMP_MODE_PROFILE_NOBRAKE("OPENING ONLINE CLAMP WITHOUT BRAKE", "IS OPENED", "COULD NOT OPEN ONLINE CLAMP"),
        UNLOCK_ONLINECLAMP("UNLOCKING ONLINECLAMP", "IS UNLOCKED", "COULD NOT UNLOCK ONLINECLAMP"),
        MOVE_TO_ABSOLUTE_POSITION("MOVING TO ABSOLUTE POSITION", "ABSOLUTE POSITION REACHED", "COULD NOT MOVE TO ABSOLUTE POSITION"),
        ALIGN_FOLLOWER("ALIGNING FOLLOWER TRUCK", "FOLLOWER TRUCK ALIGNED", "COULD NOT ALIGN FOLLOWER TRUCK"),
        MOVE_DRIVER_TRUCK_ALONE("MOVING DRIVER TRUCK ALONE", "DRIVER TRUCK MOVED ALONE", "COULD NOT MOVE DRIVER TRUCK ALONE"),
        MOVE_FOLLOWER_TRUCK_ALONE("MOVING FOLLOWER TRUCK ALONE", "FOLLOWER TRUCK MOVED ALONE", "COULD NOT MOVE FOLLOWER TRUCK ALONE"),
        UNCLAMP_LOADER_HOOKS("LOADER CLAMP UNCLAMPING", "HOOKS ARE UNCLAMPED", "COULD NOT UNCLAMP"),
        OPEN_HOMING_LOADER_HOOKS("OPENING LOADER HOOKS", "LOADER HOOKS ARE OPEN", "COULD NOT OPEN LOADER HOOKS"),
        CLOSE_LOADER_HOOKS("CLOSING LOADER HOOKS", "LOADER HOOKS ARE CLOSED", "COULD NOT CLOSE LOADER HOOKS"),
        CLAMP_LOADER_HOOKS("CLAMPING LOADER HOOKS", "LOADER HOOKS ARE CLAMPED", "COULD NOT CLAMP LOADER HOOKS"),
        MOVE_LOADERCARRIER_TO_STORAGE("MOVING LOADER CARRIER TO STORAGE", "LOADER CARRIER IS AT STORAGE POSITION", "COULD NOT MOVE LOADER CARRIER TO STORAGE POSITION"),
        MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION("MOVING LOADER CARRIER TO ABSOLUTE POSITION", "LOADER CARRIER IS AT REQUIRED POSITION", "COULD NOT MOVE LOADER CARRIER TO REQUIRED POSITION"),
        MOVE_LOADERCARRIER_TO_HANDOFF("MOVING LOADER CARRIER TO HANDOFF", "LOADER CARRIER IS AT HANDOFF POSITION", "COULD NOT MOVE LOADER CARRIER TO HANDOFF POSITION"),
        MOVE_LOADERCARRIER_TO_ENGAGED("MOVING LOADER CARRIER TO ENGAGED", "LOADER CARRIER IS AT ENGAGED POSITION", "COULD NOT MOVE LOADER CARRIER TO ENGAGED POSITION");

        private final String shortDescription;
        private final String doneActionMsg;
        private final String failureMsg;

        private MobileItemAction(String aString, String aDoneString, String aFailureMsg) {
            this.shortDescription = aString;
            this.doneActionMsg = aDoneString;
            this.failureMsg = aFailureMsg;
        }

        public String toString() {
            return this.shortDescription;
        }

        public String doneString() {
            return this.doneActionMsg;
        }

        public String getFailureMsg() {
            return this.failureMsg;
        }
    }

    public static enum GeneralAction implements ActionCounterPath
    {
        SET_FILTER,
        SET_FILTER_AT_HANDOFF_FOR_LOADER,
        STORE_FILTER_ON_CAROUSEL,
        SET_NO_FILTER,
        DISENGAGE_FILTER_FROM_CAROUSEL,
        LOAD_FILTER,
        UNLOAD_FILTER,
        CONNECT_LOADER,
        DISCONNECT_LOADER,
        MOVE_AND_CLAMP_FILTER_ONLINE,
        GRAB_FILTER_AT_STANDBY,
        ROTATE_SOCKET_TO_STANDBY,
        RECOVERY_ROTATION_STRAIGHT,
        RECOVERY_ROTATION_FORWARD,
        RECOVERY_ROTATION_BACKWARD,
        RECOVERY_CLAMP_XMINUS,
        RECOVERY_UNCLAMP;

    }

    public static interface ActionCounterPath {
        default public String name() {
            return "This is a placeholder. enum's name() function will override it.";
        }

        default public String getCounterPath() {
            return this.getCounterPath(null);
        }

        default public String getCounterPath(String subpath) {
            return this.getPath("counters", subpath);
        }

        default public String getDurationPath() {
            return this.getDurationPath(null);
        }

        default public String getDurationPath(String subpath) {
            return this.getPath("duration", subpath);
        }

        default public String getPath(String pathType, String subpath) {
            if (subpath == null) {
                return String.format("%s/%s", pathType, this.name());
            }
            return String.format("%s/%s/%s", pathType, subpath, this.name());
        }

        default public void registerDurationPerElement(DataProviderDictionaryService dpds, String subpath) {
            this.registerDuration(dpds, subpath);
        }

        default public void registerDurationTopLevel(DataProviderDictionaryService dpds) {
            this.registerDuration(dpds, null);
        }

        default public void registerDuration(DataProviderDictionaryService dpds, String subpath) {
            String path = this.getDurationPath(subpath);
            dpds.registerData(new KeyValueData(path, (Serializable)Long.valueOf(0L)));
            DataProviderInfo info = dpds.getDataProviderDictionary().getDataProviderInfoForPath(path);
            info.addAttribute(DataProviderInfo.Attribute.UNITS, "millisecond");
            info.addAttribute(DataProviderInfo.Attribute.DESCRIPTION, "Duration of the action " + this.name());
            info.addAttribute(DataProviderInfo.Attribute.TYPE, "long");
        }

        default public void publishDurationPerElement(Subsystem subs, long duration, String subpath) {
            this.publishDuration(subs, duration, subpath);
        }

        default public void publishDurationTopLevel(Subsystem subs, long duration) {
            this.publishDuration(subs, duration, null);
        }

        default public void publishDuration(Subsystem subs, long duration, String subpath) {
            subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.getDurationPath(subpath), (Serializable)Long.valueOf(duration)));
        }
    }
}

