/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.lsst.ccs.gconsole.services.lock.Lock;
import org.lsst.ccs.subsystem.common.ui.TextFieldX;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;

public class SystemStatusPanel
extends JPanel
implements UiUtilities.ActionHandler {
    private static final int STATUS_WIDTH = UiUtilities.maxLabelWidth(new String[]{"STOPPED", "RUNNING"}, "");
    private final CommandSender sender;
    private final String node;
    private final String command;
    private final boolean isFast;
    private final UiUtilities uiUtils;
    private JLabel stateStatus;
    private TextFieldX periodTextField;
    private int periodMillis = 0;
    private static final long serialVersionUID = 1L;

    public SystemStatusPanel(CommandSender sender) {
        this(sender, null, "setUpdatePeriod", false);
    }

    public SystemStatusPanel(CommandSender sender, String node) {
        this(sender, node, "setPublishPeriod", false);
    }

    public SystemStatusPanel(CommandSender sender, String node, boolean isFast) {
        this(sender, node, "setFastPeriod", isFast);
    }

    private SystemStatusPanel(CommandSender sender, String node, String command, boolean isFast) {
        this.sender = sender;
        this.node = node;
        this.command = command;
        this.isFast = isFast;
        this.uiUtils = new UiUtilities(this);
        this.initComponents();
        this.disablePanel();
    }

    public void updatePanel(int periodMillis) {
        this.stateStatus.setText("RUNNING");
        this.stateStatus.setForeground(UiConstants.GREEN);
        this.periodMillis = periodMillis;
        this.updatePeriod();
    }

    public void disablePanel() {
        this.stateStatus.setText("STOPPED");
        this.stateStatus.setForeground(UiConstants.RED);
        this.periodTextField.setDisabled();
    }

    private void initComponents() {
        this.stateStatus = UiUtilities.newLabel("XXX", STATUS_WIDTH);
        this.periodTextField = this.isFast ? this.uiUtils.newTextFieldX("999:59:59", "", 0, true) : this.uiUtils.newTextFieldX("99999.9", "", 2, true);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbh = new GridBagConstraints();
        gbh.insets = new Insets(5, 5, 5, 0);
        gbh.gridx = 0;
        gbh.gridy = 0;
        gbh.anchor = 17;
        this.add((Component)new Lock(this.sender.getAgent()), gbh);
        ++gbh.gridx;
        gbh.insets.left = 20;
        this.add((Component)UiUtilities.newLabel("System State: ", 0), gbh);
        ++gbh.gridx;
        gbh.insets.left = 5;
        this.add((Component)this.stateStatus, gbh);
        ++gbh.gridx;
        gbh.insets.left = this.isFast ? 36 : 72;
        this.add((Component)UiUtilities.newLabel(this.isFast ? "Fast Update Time: " : "Update Period: ", 0), gbh);
        ++gbh.gridx;
        gbh.insets.left = 5;
        gbh.insets.top -= 2;
        this.add((Component)this.periodTextField, gbh);
        ++gbh.gridx;
        gbh.insets.top += 2;
        this.add((Component)UiUtilities.newLabel(this.isFast ? "[[hr:]min:]sec" : "sec", 0), gbh);
    }

    @Override
    public void handleTextFieldX(String name, Object value) {
        if (this.isFast) {
            String[] fields = ((String)value).split(":");
            int fieldS = fields.length - 1;
            if (fieldS <= 2) {
                try {
                    long period = 1000L * (Long.decode(fields[fieldS]) + 60L * (fieldS == 0 ? 0L : Long.decode(fields[fieldS - 1]) + 60L * (fieldS == 1 ? 0L : Long.decode(fields[fieldS - 2]))));
                    this.periodMillis = (int)Math.min(period, 2147483147L);
                    this.sender.sendCommand(this.node, this.command, this.periodMillis);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else {
            this.periodMillis = (int)(1000.0 * (Double)value);
            this.sender.sendCommand(this.node, this.command, this.periodMillis);
        }
        this.updatePeriod();
    }

    private void updatePeriod() {
        if (this.isFast) {
            int periodSecs = (this.periodMillis + 500) / 1000;
            int periodMins = periodSecs / 60;
            this.periodTextField.update(String.format("%d:%02d:%02d", periodMins / 60, periodMins % 60, periodSecs % 60), true);
        } else {
            this.periodTextField.update((double)this.periodMillis / 1000.0, true);
        }
    }
}

