/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.web.rest.file.server.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RestFileInfo
implements Serializable {
    private final long lastModified;
    private final long creationTime;
    private final long lastAccessTime;
    private final long size;
    private final String mimeType;
    private final String name;
    private final String fileKey;
    private final boolean isDirectory;
    private final boolean isOther;
    private final boolean isRegularFile;
    private final boolean isSymbolicLink;
    private final boolean isVersionedFile;
    private final List<RestFileInfo> children;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public RestFileInfo(@JsonProperty(value="lastModified") long lastModified, @JsonProperty(value="creationTime") long creationTime, @JsonProperty(value="lastAccessTime") long lastAccessTime, @JsonProperty(value="size") long size, @JsonProperty(value="mimeType") String mimeType, @JsonProperty(value="name") String name, @JsonProperty(value="fileKey") String fileKey, @JsonProperty(value="directory") boolean directory, @JsonProperty(value="other") boolean other, @JsonProperty(value="regularFile") boolean regularFile, @JsonProperty(value="symbolicLink") boolean symbolicLink, @JsonProperty(value="versionedFile") boolean versionedFile, @JsonProperty(value="children") List<RestFileInfo> children) {
        this.lastModified = lastModified;
        this.creationTime = creationTime;
        this.lastAccessTime = lastAccessTime;
        this.size = size;
        this.mimeType = mimeType;
        this.name = name;
        this.fileKey = fileKey;
        this.isDirectory = directory;
        this.isOther = other;
        this.isRegularFile = regularFile;
        this.isSymbolicLink = symbolicLink;
        this.isVersionedFile = versionedFile;
        this.children = children;
    }

    public RestFileInfo(RestFileInfo other) {
        this.lastModified = other.lastModified;
        this.creationTime = other.creationTime;
        this.lastAccessTime = other.lastAccessTime;
        this.size = other.size;
        this.mimeType = other.mimeType;
        this.name = other.name;
        this.fileKey = other.fileKey;
        this.isDirectory = other.isDirectory;
        this.isOther = other.isOther;
        this.isRegularFile = other.isRegularFile;
        this.isSymbolicLink = other.isSymbolicLink;
        this.isVersionedFile = other.isVersionedFile;
        this.children = other.children;
    }

    public RestFileInfo(Path file, BasicFileAttributes fileAttributes, boolean isVersionedFile) throws IOException {
        this(file, fileAttributes, isVersionedFile, null);
    }

    public RestFileInfo(Path file, BasicFileAttributes fileAttributes, boolean isVersionedFile, List<RestFileInfo> children) throws IOException {
        this.name = file.getFileName().toString();
        this.size = fileAttributes.size();
        this.lastModified = fileAttributes.lastModifiedTime().toMillis();
        this.fileKey = fileAttributes.fileKey().toString();
        this.isDirectory = fileAttributes.isDirectory();
        this.isOther = fileAttributes.isOther();
        this.isRegularFile = fileAttributes.isRegularFile();
        this.isSymbolicLink = fileAttributes.isSymbolicLink();
        this.lastAccessTime = fileAttributes.lastAccessTime().toMillis();
        this.creationTime = fileAttributes.creationTime().toMillis();
        this.mimeType = Files.probeContentType(file);
        this.isVersionedFile = isVersionedFile;
        this.children = children;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public long getSize() {
        return this.size;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getName() {
        return this.name;
    }

    public String getFileKey() {
        return this.fileKey;
    }

    public boolean isDirectory() {
        return this.isDirectory && !this.isVersionedFile;
    }

    public boolean isOther() {
        return this.isOther || this.isVersionedFile;
    }

    public boolean isRegularFile() {
        return this.isRegularFile;
    }

    public boolean isSymbolicLink() {
        return this.isSymbolicLink;
    }

    public boolean isVersionedFile() {
        return this.isVersionedFile;
    }

    public List<RestFileInfo> getChildren() {
        return this.children;
    }

    public String toString() {
        return "RestFileInfo{lastModified=" + this.lastModified + ", size=" + this.size + ", mimeType=" + this.mimeType + ", name=" + this.name + "}";
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("lastAccessTime", FileTime.fromMillis(this.lastAccessTime));
        result.put("lastModifiedTime", FileTime.fromMillis(this.lastModified));
        result.put("size", this.getSize());
        result.put("creationTime", FileTime.fromMillis(this.creationTime));
        result.put("isSymbolicLink", this.isSymbolicLink());
        result.put("isRegularFile", this.isRegularFile());
        result.put("fileKey", this.getFileKey());
        result.put("isOther", this.isOther());
        result.put("isDirectory", this.isDirectory());
        result.put("isVersionedFile", this.isVersionedFile());
        return result;
    }
}

