/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import org.lsst.ccs.subsystem.shutter.common.ShutterSide;
import org.lsst.ccs.subsystem.shutter.gui.GUIUtil;
import org.lsst.ccs.subsystem.shutter.gui.PageActions;
import org.lsst.ccs.subsystem.shutter.status.ShutterStatus;

public class CommandPanel
extends JPanel
implements PageActions {
    private final PageActions dispatcher;
    private final Map<ShutterSide, Boolean> brakeState;
    private final JSpinner exposureTimeSpinner;

    public CommandPanel(PageActions dispatcher) {
        this.dispatcher = dispatcher;
        this.brakeState = new EnumMap<ShutterSide, Boolean>(ShutterSide.class);
        this.exposureTimeSpinner = new JSpinner();
        this.exposureTimeSpinner.setModel(new SpinnerNumberModel(1.0, 0.1, 3600.0, 0.1));
        this.setLayout(new GridLayout(9, 2, 5, 5));
        Supplier<Box> filler = () -> {
            Box result = new Box(2);
            result.add(Box.createGlue());
            return result;
        };
        this.add(Cmd.Stop.button);
        this.add(filler.get());
        this.add(filler.get());
        this.add(filler.get());
        this.add(Cmd.Expose.button);
        Box timeBox = new Box(2);
        timeBox.add(new JLabel("for"));
        timeBox.add(this.exposureTimeSpinner);
        timeBox.add(new JLabel("seconds"));
        timeBox.add(Box.createGlue());
        this.add(timeBox);
        this.add(Cmd.Open.button);
        this.add(Cmd.Close.button);
        this.add(filler.get());
        this.add(filler.get());
        this.add(Cmd.Calibrate.button);
        this.add(Cmd.GotoProd.button);
        this.add(Cmd.Resync.button);
        this.add(Cmd.Center.button);
        this.add(Cmd.TogglePlusXBrake.button);
        this.add(Cmd.ToggleMinusXBrake.button);
        this.add(Cmd.ToggleSafety.button);
        this.add(filler.get());
        TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black, 1), "Commands");
        border.setTitleFont(border.getTitleFont().deriveFont(1));
        border.setTitleJustification(2);
        this.setBorder(BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(5, 5, 5, 5)));
    }

    public PageActions getDispatcher() {
        return this.dispatcher;
    }

    public double getExposureTime() {
        return ((Number)this.exposureTimeSpinner.getValue()).doubleValue();
    }

    public void toggleBrakeState(ShutterSide side) {
        Boolean state = this.brakeState.get(side);
        if (state != null) {
            this.getDispatcher().changeBrakeState(side, state == false);
        }
    }

    @Override
    public void showStatus(ShutterStatus status) {
        for (ShutterSide side : ShutterSide.values()) {
            this.brakeState.put(side, status.getAxisStatus(side).isBrakeEngaged());
        }
    }

    @Override
    public void showWorkerIsReachable() {
        this.exposureTimeSpinner.setEnabled(true);
        for (Cmd command : Cmd.values()) {
            command.button.setEnabled(true);
        }
    }

    @Override
    public void showWorkerIsUnreachable(String message) {
        this.brakeState.clear();
        this.exposureTimeSpinner.setEnabled(false);
        for (Cmd command : Cmd.values()) {
            command.button.setEnabled(false);
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            JFrame frame = new JFrame();
            CommandPanel panel = new CommandPanel(GUIUtil.fakeDispatcher());
            frame.getContentPane().add((Component)panel, "Center");
            panel.showStatus(GUIUtil.exampleShutterStatus());
            panel.showWorkerIsReachable();
            frame.pack();
            frame.setVisible(true);
        });
    }

    private static enum Cmd {
        Stop("STOP", panel -> panel.getDispatcher().stopMotion()),
        Expose("Take Exposure", panel -> panel.getDispatcher().takeExposure(panel.getExposureTime())),
        Open("Open", panel -> panel.getDispatcher().openShutter()),
        Close("Close", panel -> panel.getDispatcher().closeShutter()),
        Calibrate("Calibrate", panel -> panel.getDispatcher().calibrate()),
        GotoProd("Prod mode", panel -> panel.getDispatcher().prodMode()),
        Resync("Resync", panel -> panel.getDispatcher().resync()),
        Center("Center", panel -> panel.getDispatcher().center()),
        ToggleSafety("Toggle safety", panel -> panel.getDispatcher().toggleSafetyCheck()),
        TogglePlusXBrake("Toggle +X brake", panel -> panel.toggleBrakeState(ShutterSide.PLUSX)),
        ToggleMinusXBrake("Toggle -X brake", panel -> panel.toggleBrakeState(ShutterSide.MINUSX));

        public final JButton button;
        public final Consumer<CommandPanel> handler;

        private Cmd(String cmdName, Consumer<CommandPanel> handler) {
            this.button = new JButton(cmdName);
            this.button.setBorder(BorderFactory.createEtchedBorder(0));
            this.handler = handler;
            this.button.addActionListener(this::dispatch);
        }

        private void dispatch(ActionEvent evt) {
            CommandPanel panel = (CommandPanel)this.button.getParent();
            this.handler.accept(panel);
        }

        static {
            Cmd.Stop.button.setBackground(Color.red);
            Cmd.Stop.button.setOpaque(true);
            Cmd.Stop.button.setBorderPainted(false);
            Cmd.Stop.button.setForeground(Color.white);
            Cmd.Stop.button.setFont(Cmd.Stop.button.getFont().deriveFont(1));
        }
    }
}

