/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.commandbrowser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.freehep.swing.popup.HasPopupItems;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.Const;
import org.lsst.ccs.gconsole.plugins.commandbrowser.AgentPanel;
import org.lsst.ccs.gconsole.plugins.commandbrowser.Browser;
import org.lsst.ccs.gconsole.plugins.commandbrowser.FilterDialog;
import org.lsst.ccs.gconsole.services.lock.LockService;
import org.lsst.ccs.gconsole.services.lock.Locker;
import org.lsst.ccs.gconsole.services.persist.DataPanelDescriptor;

public final class BrowserFull
extends Browser {
    private AgentTableModel agentTableModel;
    private AgentTable agentTable;
    private AgentPanel agentPanel;
    private JLabel filterLabel;
    private final ArrayList<Locker> agents = new ArrayList();
    private final Filter filter = new Filter();
    private Descriptor descriptor = new Descriptor();
    private ChangeListener agentProxyListener;
    private LockService.Listener lockServiceListener;
    private final AbstractAction lockAllAction = new AbstractAction("Lock all"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<String> toAttach = new ArrayList<String>(BrowserFull.this.agents.size());
            ArrayList<String> toLock = new ArrayList<String>(BrowserFull.this.agents.size());
            for (Locker a : BrowserFull.this.agents) {
                if (!BrowserFull.this.filter.filter(a)) continue;
                switch (a.getState()) {
                    case DETACHED: {
                        toAttach.add(a.getName());
                        break;
                    }
                    case UNLOCKED: {
                        toLock.add(a.getName());
                    }
                }
            }
            if (!toAttach.isEmpty()) {
                BrowserFull.this.service.executeBulkOperation(LockService.Operation.ATTACH, toAttach);
            }
            if (!toLock.isEmpty()) {
                BrowserFull.this.service.executeBulkOperation(LockService.Operation.LOCK, toLock);
            }
        }
    };
    private final AbstractAction unlockAllAction;
    private final AbstractAction attachAllAction;
    private final AbstractAction detachAllAction;

    public BrowserFull() {
        this.lockAllAction.putValue("ShortDescription", "Lock or attach all available subsystems");
        this.unlockAllAction = new AbstractAction("Unlock all"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<String> toUnlock = new ArrayList<String>(BrowserFull.this.agents.size());
                for (Locker a : BrowserFull.this.agents) {
                    if (!BrowserFull.this.filter.filter(a)) continue;
                    switch (a.getState()) {
                        case DETACHED: 
                        case ATTACHED: {
                            toUnlock.add(a.getName());
                        }
                    }
                }
                if (!toUnlock.isEmpty()) {
                    BrowserFull.this.service.executeBulkOperation(LockService.Operation.UNLOCK, toUnlock);
                }
            }
        };
        this.unlockAllAction.putValue("ShortDescription", "Unlock all subsystems locked by " + this.service.getUserId());
        this.attachAllAction = new AbstractAction("Attach all"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<String> toAttach = new ArrayList<String>(BrowserFull.this.agents.size());
                for (Locker a : BrowserFull.this.agents) {
                    if (!BrowserFull.this.filter.filter(a)) continue;
                    switch (a.getState()) {
                        case DETACHED: {
                            toAttach.add(a.getName());
                        }
                    }
                }
                if (!toAttach.isEmpty()) {
                    BrowserFull.this.service.executeBulkOperation(LockService.Operation.ATTACH, toAttach);
                }
            }
        };
        this.attachAllAction.putValue("ShortDescription", "Attach all subsystems locked by " + this.service.getUserId());
        this.detachAllAction = new AbstractAction("Detach all"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<String> toDetach = new ArrayList<String>(BrowserFull.this.agents.size());
                for (Locker a : BrowserFull.this.agents) {
                    if (!BrowserFull.this.filter.filter(a)) continue;
                    switch (a.getState()) {
                        case ATTACHED: {
                            toDetach.add(a.getName());
                        }
                    }
                }
                if (!toDetach.isEmpty()) {
                    BrowserFull.this.service.executeBulkOperation(LockService.Operation.DETACH, toDetach);
                }
            }
        };
        this.detachAllAction.putValue("ShortDescription", "Detach all subsystems without unlocking them");
    }

    @Override
    public JComponent getPanel() {
        if (this.browserPanel == null) {
            super.getPanel();
            JPanel rightPane = new JPanel(new BorderLayout());
            rightPane.add((Component)this.stateLabel, "North");
            this.agentPanel = new AgentPanel();
            rightPane.add((Component)this.agentPanel, "Center");
            this.browserPanel.add((Component)rightPane, "Center");
            JPanel leftPane = new JPanel(new BorderLayout());
            leftPane.setPreferredSize(new Dimension(300, 800));
            this.browserPanel.add((Component)leftPane, "West");
            this.agentTableModel = new AgentTableModel();
            this.agentTable = new AgentTable(this.agentTableModel);
            this.agentTable.init();
            JScrollPane agentsView = new JScrollPane(this.agentTable);
            leftPane.add((Component)agentsView, "Center");
            Box filterPanel = Box.createHorizontalBox();
            leftPane.add((Component)filterPanel, "South");
            JButton filterButton = new JButton("Filter...");
            filterButton.addActionListener(e -> FilterDialog.show(this.filter, this.browserPanel));
            filterPanel.add(filterButton);
            filterPanel.add(Box.createRigidArea(Const.HDIM));
            this.filterLabel = new JLabel(this.filter.getDescription());
            filterPanel.add(this.filterLabel);
            this.restore(this.descriptor);
            this.agentProxyListener = e -> {
                Locker agent = (Locker)e.getSource();
                for (int i = 0; i < this.agents.size(); ++i) {
                    if (!agent.equals(this.agents.get(i))) continue;
                    this.agentTableModel.fireTableRowsUpdated(i, i);
                }
            };
            this.lockServiceListener = new LockService.Listener(){

                @Override
                public void agentsAdded(Locker ... agentHandles) {
                    int selectIndex = -1;
                    int prevSize = BrowserFull.this.agents.size();
                    for (Locker agent : agentHandles) {
                        BrowserFull.this.agents.add(agent);
                        agent.addListener(BrowserFull.this.agentProxyListener);
                        if (!agent.getName().equals(BrowserFull.this.descriptor.getAgent())) continue;
                        int i = BrowserFull.this.agentTable.convertRowIndexToView(BrowserFull.this.agents.size() - 1);
                        BrowserFull.this.agentTable.getSelectionModel().setSelectionInterval(i, i);
                    }
                    if (BrowserFull.this.agents.size() > prevSize) {
                        BrowserFull.this.agentTableModel.fireTableRowsInserted(prevSize, BrowserFull.this.agents.size() - 1);
                        if (selectIndex != -1) {
                            BrowserFull.this.agentTable.getSelectionModel().setSelectionInterval(selectIndex, selectIndex);
                        }
                    }
                }

                @Override
                public void agentsRemoved(Locker ... agentHandles) {
                    block0: for (Locker agentHandle : agentHandles) {
                        for (int i = 0; i < BrowserFull.this.agents.size(); ++i) {
                            if (!agentHandle.equals(BrowserFull.this.agents.get(i))) continue;
                            BrowserFull.this.agents.remove(i);
                            BrowserFull.this.agentTableModel.fireTableRowsDeleted(i, i);
                            continue block0;
                        }
                    }
                }
            };
            LockService.getService().addListener(this.lockServiceListener);
        }
        return this.browserPanel;
    }

    @Override
    public void shutdown() {
        LockService.getService().removeListener(this.lockServiceListener);
        this.agents.forEach(a -> a.removeListener(this.agentProxyListener));
        this.browserPanel = null;
    }

    @Override
    public String getName() {
        return this.descriptor.getName();
    }

    @Override
    String getAgentName() {
        Locker agent = this.getSelectedAgent();
        return agent == null ? null : agent.getName();
    }

    @Override
    public void restore(Serializable descriptor) {
        if (descriptor instanceof Descriptor) {
            this.descriptor = (Descriptor)descriptor;
            this.filter.restore();
            if (this.browserPanel != null) {
                String selectedAgentName = this.descriptor.getAgent();
                if (selectedAgentName == null) {
                    this.agentTable.getSelectionModel().clearSelection();
                } else {
                    for (int i = this.agents.size() - 1; i >= 0; --i) {
                        if (!selectedAgentName.equals(this.agents.get(i).getName())) continue;
                        i = this.agentTable.convertColumnIndexToView(i);
                        this.agentTable.getSelectionModel().setSelectionInterval(i, i);
                        break;
                    }
                }
                AgentPanel.Descriptor apDesc = this.descriptor.getAgentPanel();
                if (apDesc != null) {
                    this.agentPanel.restore(apDesc);
                }
            }
        } else {
            this.logger.debug((Object)("Incorrect descriptor type for BrowserFull command browser: " + descriptor));
        }
    }

    @Override
    public Descriptor save() {
        if (this.agentPanel == null) {
            this.descriptor.setAgentPanel(null);
        } else {
            this.descriptor.setAgentPanel(this.agentPanel.save());
        }
        if (this.browserPanel != null) {
            this.descriptor.setPage(DataPanelDescriptor.get(this.browserPanel));
        }
        return this.descriptor;
    }

    private Locker getSelectedAgent() {
        if (this.agentTable == null) {
            return null;
        }
        int i = this.agentTable.getSelectedRow();
        if (i != -1) {
            i = this.agentTable.convertRowIndexToModel(i);
        }
        return i < 0 ? null : this.agents.get(i);
    }

    class Filter
    extends RowFilter<Object, Integer> {
        EnumSet<AgentInfo.AgentType> types;
        ArrayList<String> names;
        ArrayList<String> groups;
        HashMap<String, String> properties;

        Filter() {
        }

        @Override
        public boolean include(RowFilter.Entry<? extends Object, ? extends Integer> entry) {
            int i = entry.getIdentifier();
            Locker agent = BrowserFull.this.agents.get(i);
            return this.filter(agent);
        }

        boolean filter(Locker agent) {
            String group;
            AgentInfo info = agent.getInfo();
            String name = agent.getName();
            if (this.types != null && info != null && !this.types.contains(info.getType())) {
                return false;
            }
            if (this.names != null) {
                boolean fail = true;
                for (String string : this.names) {
                    if (!name.contains(string)) continue;
                    fail = false;
                    break;
                }
                if (fail) {
                    return false;
                }
            }
            if (this.groups != null && info != null && !this.groups.contains(group = info.getAgentProperty("group", ""))) {
                return false;
            }
            if (this.properties != null && info != null) {
                boolean fail = true;
                for (Map.Entry entry : this.properties.entrySet()) {
                    String value = info.getAgentProperty((String)entry.getKey());
                    if (!Objects.equals(value, entry.getValue()) && (value == null || !"".equals(entry.getValue()))) continue;
                    fail = false;
                    break;
                }
                if (fail) {
                    return false;
                }
            }
            return true;
        }

        void apply() {
            BrowserFull.this.agentTableModel.fireTableDataChanged();
            BrowserFull.this.filterLabel.setText(this.getDescription());
        }

        void save() {
            if (this.types == null) {
                BrowserFull.this.descriptor.setFilterTypes(null);
            } else {
                String[] tt = new String[this.types.size()];
                int i = 0;
                for (AgentInfo.AgentType type : this.types) {
                    tt[i++] = type.name();
                }
                BrowserFull.this.descriptor.setFilterTypes(tt);
            }
            BrowserFull.this.descriptor.setFilterNames(this.names == null ? null : new ArrayList<String>(this.names));
            BrowserFull.this.descriptor.setFilterGroups(this.groups == null ? null : new ArrayList<String>(this.groups));
            BrowserFull.this.descriptor.setFilterProperties(this.properties == null ? null : new HashMap<String, String>(this.properties));
        }

        void restore() {
            if (BrowserFull.this.descriptor.getFilterTypes() == null) {
                this.types = null;
            } else {
                this.types = EnumSet.noneOf(AgentInfo.AgentType.class);
                for (String s : BrowserFull.this.descriptor.getFilterTypes()) {
                    try {
                        this.types.add(AgentInfo.AgentType.valueOf((String)s));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
            this.names = BrowserFull.this.descriptor.getFilterNames() == null ? null : new ArrayList<String>(BrowserFull.this.descriptor.getFilterNames());
            this.groups = BrowserFull.this.descriptor.getFilterGroups() == null ? null : new ArrayList<String>(BrowserFull.this.descriptor.getFilterGroups());
            this.properties = BrowserFull.this.descriptor.getFilterProperties() == null ? null : new HashMap<String, String>(BrowserFull.this.descriptor.getFilterProperties());
        }

        String getDescription() {
            if (this.types == null) {
                if (this.names == null && this.groups == null && this.properties == null) {
                    return "All";
                }
            } else if (this.names == null && this.groups == null && this.properties == null && this.types.size() < 3) {
                return String.join((CharSequence)" & ", this.types.stream().map(t -> t.displayName()).collect(Collectors.toList()));
            }
            return "Custom";
        }
    }

    public static class Descriptor
    extends Browser.Descriptor {
        private String[] filterTypes;
        private ArrayList<String> filterNames;
        private ArrayList<String> filterGroups;
        private HashMap<String, String> filterProperties;

        public String[] getFilterTypes() {
            return this.filterTypes;
        }

        public void setFilterTypes(String[] filterTypes) {
            this.filterTypes = filterTypes;
        }

        public ArrayList<String> getFilterNames() {
            return this.filterNames;
        }

        public void setFilterNames(ArrayList<String> filterNames) {
            this.filterNames = filterNames;
        }

        public ArrayList<String> getFilterGroups() {
            return this.filterGroups;
        }

        public void setFilterGroups(ArrayList<String> filterGroups) {
            this.filterGroups = filterGroups;
        }

        public HashMap<String, String> getFilterProperties() {
            return this.filterProperties;
        }

        public void setFilterProperties(HashMap<String, String> filterProperties) {
            this.filterProperties = filterProperties;
        }
    }

    private class AgentTableModel
    extends AbstractTableModel {
        private AgentTableModel() {
        }

        @Override
        public int getRowCount() {
            return BrowserFull.this.agents.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Locker a = BrowserFull.this.agents.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return " " + a.getName();
                }
                case 1: {
                    return BrowserFull.this.renderLock(a);
                }
                case 2: {
                    return a.getLevel();
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 2 && !BrowserFull.this.agents.get(rowIndex).isAdjusting();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Browser.RenderedLock.class;
                }
                case 2: {
                    return Integer.class;
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Subsystem";
                }
                case 1: {
                    return "Lock";
                }
                case 2: {
                    return "Level";
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 2) {
                Locker agent = BrowserFull.this.agents.get(rowIndex);
                try {
                    int level = Integer.parseInt(aValue.toString());
                    BrowserFull.this.service.executeOperation(LockService.Operation.LEVEL, agent.getName(), level);
                }
                catch (NumberFormatException x) {
                    Console.getConsole().error("Illegal level format", x);
                }
            }
        }
    }

    private class AgentTable
    extends JTable
    implements HasPopupItems {
        AgentTable(AgentTableModel model) {
            super(model);
        }

        void init() {
            this.setSelectionMode(0);
            this.setFillsViewportHeight(true);
            this.setDefaultRenderer(String.class, new AgentNameRenderer());
            this.setDefaultRenderer(Browser.RenderedLock.class, new LockRenderer());
            TableCellRenderer headerRenderer = BrowserFull.this.agentTable.getTableHeader().getDefaultRenderer();
            for (int i = 0; i < 3; ++i) {
                TableColumn column = this.getColumnModel().getColumn(i);
                int w = headerRenderer.getTableCellRendererComponent(null, (Object)column.getHeaderValue(), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width;
                column.setMinWidth(Math.round((float)w * 1.5f));
                column.setPreferredWidth(i == 0 ? 10 * w : Math.round((float)w * 1.5f));
            }
            this.setRowHeight(Math.max(this.getRowHeight(), 27));
            TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.getModel());
            ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
            sortKeys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
            sortKeys.add(new RowSorter.SortKey(1, SortOrder.ASCENDING));
            sorter.setSortKeys(sortKeys);
            sorter.setRowFilter(BrowserFull.this.filter);
            this.setRowSorter(sorter);
            this.getSelectionModel().addListSelectionListener(e -> {
                if (!e.getValueIsAdjusting()) {
                    Locker agent = BrowserFull.this.getSelectedAgent();
                    BrowserFull.this.agentPanel.setAgent(agent);
                    BrowserFull.this.updateStateDisplay();
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Browser.RenderedLock renderedLock;
                    int row;
                    Point point;
                    int column;
                    if (e.getClickCount() == 2 && (column = BrowserFull.this.agentTable.columnAtPoint(point = e.getPoint())) == 1 && (row = BrowserFull.this.agentTable.convertRowIndexToModel(BrowserFull.this.agentTable.rowAtPoint(point))) >= 0 && (renderedLock = (Browser.RenderedLock)BrowserFull.this.agentTableModel.getValueAt(row, 1)) != null && renderedLock.defaultAction != null) {
                        renderedLock.defaultAction.actionPerformed(null);
                    }
                }
            });
        }

        public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component component, Point point) {
            int row = BrowserFull.this.agentTable.rowAtPoint(point);
            if (row >= 0) {
                row = BrowserFull.this.agentTable.convertRowIndexToModel(row);
            }
            if (row >= 0) {
                Browser.RenderedLock renderedLock = (Browser.RenderedLock)BrowserFull.this.agentTableModel.getValueAt(row, 1);
                if (renderedLock != null && renderedLock.availableActions != null) {
                    renderedLock.availableActions.forEach(a -> menu.add(new JMenuItem((Action)a)));
                }
                menu.addSeparator();
            }
            menu.add(new JMenuItem(BrowserFull.this.lockAllAction));
            menu.add(new JMenuItem(BrowserFull.this.unlockAllAction));
            menu.add(new JMenuItem(BrowserFull.this.attachAllAction));
            menu.add(new JMenuItem(BrowserFull.this.detachAllAction));
            return menu;
        }
    }

    class LockRenderer
    extends DefaultTableCellRenderer {
        LockRenderer() {
        }

        @Override
        protected void setValue(Object value) {
            super.setValue(value);
            this.setText("");
            Browser.RenderedLock renderedLock = (Browser.RenderedLock)value;
            this.setIcon(renderedLock.icon);
            this.setToolTipText(renderedLock.tooltip);
        }
    }

    private class AgentNameRenderer
    extends DefaultTableCellRenderer {
        private AgentNameRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setToolTipText(value.toString());
            Locker agent = BrowserFull.this.agents.get(table.convertRowIndexToModel(row));
            this.setEnabled(agent.isOnline());
            return this;
        }
    }
}

