/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.formatter;

import io.confluent.kafka.formatter.SchemaMessageDeserializer;
import io.confluent.kafka.formatter.SchemaMessageFormatter;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.AbstractKafkaAvroDeserializer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.io.EncoderFactory;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;

public class AvroMessageFormatter
extends SchemaMessageFormatter<Object> {
    private final EncoderFactory encoderFactory = EncoderFactory.get();

    public AvroMessageFormatter() {
    }

    AvroMessageFormatter(String url, Deserializer keyDeserializer) {
        super(url, keyDeserializer);
    }

    protected SchemaMessageDeserializer<Object> createDeserializer(Deserializer keyDeserializer) {
        return new AvroMessageDeserializer(keyDeserializer);
    }

    protected void writeTo(String topic, Headers headers, byte[] data, PrintStream output) throws IOException {
        Object object = this.deserializer.deserialize(topic, headers, data);
        try {
            AvroSchemaUtils.toJson((Object)object, (OutputStream)output);
        }
        catch (AvroRuntimeException e) {
            Schema schema = AvroSchemaUtils.getSchema((Object)object);
            throw new SerializationException(String.format("Error serializing Avro data of schema %s to json", schema), (Throwable)e);
        }
    }

    protected SchemaProvider getProvider() {
        return new AvroSchemaProvider();
    }

    static class AvroMessageDeserializer
    extends AbstractKafkaAvroDeserializer
    implements SchemaMessageDeserializer<Object> {
        protected final Deserializer keyDeserializer;

        AvroMessageDeserializer(Deserializer keyDeserializer) {
            this.keyDeserializer = keyDeserializer;
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
            this.configure(this.deserializerConfig(configs), null);
        }

        public Deserializer getKeyDeserializer() {
            return this.keyDeserializer;
        }

        public Object deserializeKey(String topic, Headers headers, byte[] payload) {
            return this.keyDeserializer.deserialize(topic, headers, payload);
        }

        public Object deserialize(String topic, Headers headers, byte[] payload) throws SerializationException {
            return super.deserialize(topic, this.isKey, headers, payload, null);
        }

        public SchemaRegistryClient getSchemaRegistryClient() {
            return this.schemaRegistry;
        }

        public void close() throws IOException {
            if (this.keyDeserializer != null) {
                this.keyDeserializer.close();
            }
            super.close();
        }
    }
}

