/*
 * Decompiled with CFR 0.152.
 */
package plotter;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import plotter.AxisLabeler;
import plotter.LogarithmicAxisModel;

public class LogarithmicAxisLabeler
implements AxisLabeler,
ChangeListener {
    private double min;
    private double max;
    private int maxNumberOfDivisions = 10;
    private float[] labelPosition;
    private String[] label;
    private float[] minorTickPositions;
    private int maxCharsPerLabel = 5;
    private final LogarithmicAxisModel model;

    LogarithmicAxisLabeler(LogarithmicAxisModel model) {
        this.model = model;
        this.min = model.getModelCoordinateFromAxisCoordinate(0.0);
        this.max = model.getModelCoordinateFromAxisCoordinate(1.0);
        this.calculateLabels();
        model.addChangeListener(this);
    }

    private int round(double d, boolean down) {
        block3: {
            double round;
            block2: {
                double minProximity = 1.0E-4;
                round = Math.round(d);
                if (d == round) break block2;
                double d2 = Math.abs(d - round);
                double d3 = d != 0.0 ? 1.0E-4 * Math.abs(d) : 1.0E-6;
                if (!(d2 < d3)) break block3;
            }
            return (int)round;
        }
        return down ? (int)Math.floor(d) : (int)Math.ceil(d);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean areEqual(double d1, double d2) {
        if (d1 == d2) return true;
        double d = Math.abs(d2 - d1);
        double d3 = d1 != 0.0 ? 1.0E-4 * d1 : 1.0E-6;
        if (!(d < Math.abs(d3))) return false;
        return true;
    }

    private int charsReq(int pow) {
        if (pow < 0) {
            return -pow + 2;
        }
        return pow + 1;
    }

    private void calculateLabels() {
        int i;
        int nDecades;
        double log_max = Math.log10(this.max);
        int int_log_max = (int)Math.floor(log_max);
        double log_min = Math.log10(this.min);
        int min_int = this.round(log_min, false);
        int max_int = this.round(log_max, true);
        int nLabels = nDecades = max_int - min_int + 1;
        int skip = 1;
        if (nDecades > this.maxNumberOfDivisions && this.maxNumberOfDivisions > 1) {
            while (skip + 1 < nDecades && nDecades / skip >= this.maxNumberOfDivisions - 1) {
                ++skip;
            }
            if (skip != 1 && min_int + (nLabels = nDecades / skip) * skip <= max_int) {
                ++nLabels;
            }
        }
        this.label = new String[nLabels];
        this.labelPosition = new float[nLabels];
        if (this.charsReq(min_int) > this.maxCharsPerLabel || this.charsReq(max_int) > this.maxCharsPerLabel) {
            int power = min_int;
            for (i = 0; i < nLabels; ++i) {
                this.label[i] = "10^".concat(String.valueOf(power));
                this.labelPosition[i] = (float)(((double)power - log_min) / (log_max - log_min));
                power += skip;
            }
        } else {
            int j;
            StringBuilder b = new StringBuilder();
            if (min_int >= 0) {
                b.append('1');
                for (int j2 = 0; j2 < min_int; ++j2) {
                    b.append('0');
                }
                for (i = 0; i < nLabels; ++i) {
                    this.label[i] = b.toString();
                    this.labelPosition[i] = (float)(((double)(i * skip + min_int) - log_min) / (log_max - log_min));
                    for (j = 0; j < skip; ++j) {
                        b.append('0');
                    }
                }
            } else if (max_int < 0) {
                b.append("0.1");
                for (i = max_int; i < -1; ++i) {
                    b.insert(2, '0');
                }
                for (i = nLabels - 1; i >= 0; --i) {
                    this.label[i] = b.toString();
                    this.labelPosition[i] = (float)(((double)(i * skip + min_int) - log_min) / (log_max - log_min));
                    for (j = 0; j < skip; ++j) {
                        b.insert(2, '0');
                    }
                }
            } else {
                int power = min_int;
                for (int i2 = 0; i2 < nLabels; ++i2) {
                    int j3;
                    b.setLength(0);
                    if (power < 0) {
                        b.append("0.");
                        for (j3 = -1; j3 > power; --j3) {
                            b.append('0');
                        }
                        b.append('1');
                    } else {
                        b.append('1');
                        for (j3 = 0; j3 < power; ++j3) {
                            b.append('0');
                        }
                    }
                    this.label[i2] = b.toString();
                    this.labelPosition[i2] = (float)(((double)power - log_min) / (log_max - log_min));
                    power += skip;
                }
            }
        }
        if (skip == 1) {
            double minorTickBase = this.areEqual(min_int, log_min) ? this.min : Math.pow(10.0, min_int - 1);
            double initialIndex = this.min / minorTickBase;
            double initialIndex_ceil = Math.ceil(initialIndex);
            int index = initialIndex_ceil > initialIndex ? (int)initialIndex_ceil : (int)initialIndex_ceil + 1;
            int nMinorTicks = (max_int - min_int) * 8;
            nMinorTicks += (int)((Math.pow(10.0, min_int) - this.min) / Math.pow(10.0, min_int - 1));
            this.minorTickPositions = new float[nMinorTicks += (int)((this.max - Math.pow(10.0, max_int)) / Math.pow(10.0, max_int))];
            for (int i3 = 0; i3 < nMinorTicks; ++i3) {
                if (index > 9) {
                    index = 2;
                    minorTickBase *= 10.0;
                }
                this.minorTickPositions[i3] = (float)((Math.log10((double)index * minorTickBase) - log_min) / (log_max - log_min));
                ++index;
            }
        } else {
            this.minorTickPositions = null;
            for (int nMinorDivisions = Math.min(6, skip); nMinorDivisions > 1; --nMinorDivisions) {
                if (skip % nMinorDivisions != 0) continue;
                int minorSkip = skip / nMinorDivisions;
                int nMinorTicks = (nMinorDivisions - 1) * (max_int - min_int) / skip;
                int tickPower = min_int + minorSkip;
                this.minorTickPositions = new float[nMinorTicks];
                for (int i4 = 0; i4 < nMinorTicks; ++i4) {
                    if ((tickPower - min_int) % skip == 0) {
                        tickPower += minorSkip;
                    }
                    this.minorTickPositions[i4] = (float)(((double)tickPower - log_min) / (log_max - log_min));
                    tickPower += minorSkip;
                }
                break;
            }
        }
    }

    @Override
    public int getNLabels() {
        return this.label.length;
    }

    @Override
    public String getLabel(int index) {
        return this.label[index];
    }

    @Override
    public float getLabelPos(int index) {
        return this.labelPosition[index];
    }

    @Override
    public int getNTickMarks() {
        return this.label.length;
    }

    @Override
    public float getTickPos(int index) {
        return this.labelPosition[index];
    }

    @Override
    public int getNMinorTickMarks() {
        return this.minorTickPositions == null ? 0 : this.minorTickPositions.length;
    }

    @Override
    public float getMinorTickPos(int index) {
        return this.minorTickPositions[index];
    }

    @Override
    public String getToolTipText(float pos) {
        return null;
    }

    @Override
    public String getAxisUnit() {
        return null;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.min = this.model.getModelCoordinateFromAxisCoordinate(0.0);
        this.max = this.model.getModelCoordinateFromAxisCoordinate(1.0);
        this.calculateLabels();
    }
}

