/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.util.waitcursor;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import org.freehep.jas.util.waitcursor.DelayTimer;
import org.freehep.jas.util.waitcursor.DispatchedEvent;

class CursorManager {
    private final DelayTimer waitTimer;
    private final Stack dispatchedEvents = new Stack();
    private boolean needsCleanup;

    public CursorManager(DelayTimer waitTimer) {
        this.waitTimer = waitTimer;
    }

    public void setCursor() {
        ((DispatchedEvent)this.dispatchedEvents.peek()).setCursor();
    }

    public void pop() {
        this.cleanUp();
        this.dispatchedEvents.pop();
        if (!this.dispatchedEvents.isEmpty()) {
            this.waitTimer.startTimer();
        } else {
            this.needsCleanup = false;
        }
    }

    public void push(Object source) {
        if (this.needsCleanup) {
            this.waitTimer.stopTimer();
            this.cleanUp();
        }
        this.dispatchedEvents.push(new DispatchedEvent(source));
        this.needsCleanup = true;
    }

    private void cleanUp() {
        if (((DispatchedEvent)this.dispatchedEvents.peek()).resetCursor()) {
            this.clearQueueOfInputEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearQueueOfInputEvents() {
        ArrayList nonInputEvents;
        EventQueue q;
        EventQueue eventQueue = q = Toolkit.getDefaultToolkit().getSystemEventQueue();
        synchronized (eventQueue) {
            nonInputEvents = this.gatherNonInputEvents(q);
        }
        Iterator it = nonInputEvents.iterator();
        while (it.hasNext()) {
            q.postEvent((AWTEvent)it.next());
        }
    }

    private ArrayList gatherNonInputEvents(EventQueue systemQueue) {
        ArrayList<AWTEvent> events = new ArrayList<AWTEvent>();
        while (systemQueue.peekEvent() != null) {
            try {
                AWTEvent nextEvent = systemQueue.getNextEvent();
                if (nextEvent instanceof InputEvent) continue;
                events.add(nextEvent);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
        return events;
    }
}

