/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import java.io.PrintStream;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;

public class TestSpeed {
    private static final PrintStream out = System.out;

    public static void main(String[] args) throws REBException {
        if (args.length < 3) {
            out.println("Parameters are: rebid regnum nreg count");
            System.exit(0);
        }
        int[] iArgs = new int[4];
        for (int j = 0; j < iArgs.length; ++j) {
            try {
                iArgs[j] = Integer.decode(args[j]);
                continue;
            }
            catch (NumberFormatException e) {
                out.println("Invalid integer for parameter " + j);
                System.exit(0);
            }
        }
        new TestSpeed().run(iArgs[0], iArgs[1], iArgs[2], iArgs[3]);
        System.exit(0);
    }

    private void run(int rebid, int regnum, int nreg, int count) throws REBException {
        RegClient reg = new RegClient();
        reg.open(rebid);
        long start = System.currentTimeMillis();
        int nread = 0;
        int[] data = new int[nreg];
        for (int j = 0; j < count; ++j) {
            reg.read(regnum, data);
            nread += nreg;
        }
        long time = System.currentTimeMillis() - start;
        int rate = time == 0L ? 0 : (int)((long)(1000 * nread) / time);
        out.format("Performed %s reads in %s msecs, rate = %s reads/sec\n", nread, time, rate);
    }
}

