/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.freehep.graphicsio.swf.SWFConstants;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;

public class SWFHeader
implements SWFConstants {
    private int version;
    private long length;
    private Dimension size;
    private float rate;
    private int count;
    private boolean compress;

    public SWFHeader(int version, long length, Dimension size, float rate, int count, boolean compress) {
        this.version = version;
        this.length = length;
        this.size = size;
        this.rate = rate;
        this.count = count;
        this.compress = compress;
    }

    public SWFHeader(SWFInputStream swf) throws IOException {
        int s = swf.readUnsignedByte();
        if (70 != s && 67 != s) {
            throw new IOException();
        }
        if (87 != swf.readUnsignedByte()) {
            throw new IOException();
        }
        if (83 != swf.readUnsignedByte()) {
            throw new IOException();
        }
        this.version = swf.readUnsignedByte();
        this.length = swf.readUnsignedInt();
        boolean bl = this.compress = this.version >= 6 && 67 == s;
        if (this.compress) {
            swf.startDecompressing();
        }
        Rectangle2D frame = swf.readRect();
        this.size = new Dimension((int)frame.getMaxX(), (int)frame.getMaxY());
        this.rate = (float)swf.readUnsignedShort() / 256.0f;
        this.count = swf.readUnsignedShort();
    }

    public void write(SWFOutputStream swf) throws IOException {
        if (this.version >= 6 && this.compress) {
            swf.writeUnsignedByte(67);
        } else {
            swf.writeUnsignedByte(70);
        }
        swf.writeUnsignedByte(87);
        swf.writeUnsignedByte(83);
        swf.writeUnsignedByte(this.version);
        swf.writeUnsignedInt(this.length);
        if (this.version >= 6 && this.compress) {
            swf.startCompressing();
        }
        Rectangle2D.Double frame = new Rectangle2D.Double(0.0, 0.0, this.size.width, this.size.height);
        swf.writeRect(frame);
        swf.writeUnsignedShort((int)(this.rate * 256.0f));
        swf.writeUnsignedShort(this.count);
    }

    public static int size() {
        return 21;
    }

    public int getVersion() {
        return this.version;
    }

    public long getLength() {
        return this.length;
    }

    public boolean isCompressed() {
        return this.compress;
    }

    public Dimension getSize() {
        return this.size;
    }

    public float getRate() {
        return this.rate;
    }

    public int getCount() {
        return this.count;
    }

    public String toString() {
        StringBuffer s = new StringBuffer("SWF Header\n");
        s.append("  version: " + this.version + "\n");
        s.append("  length: " + this.length + "\n");
        s.append("  compress: " + this.compress + "\n");
        s.append("  size: " + this.size + "\n");
        s.append("  rate: " + this.rate + "\n");
        s.append("  count: " + this.count);
        return s.toString();
    }
}

