/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.config.ConfigurationDAO;
import org.lsst.ccs.config.ConfigurationServiceException;
import org.lsst.ccs.config.SingleCategoryTag;
import org.lsst.ccs.config.SingleCategoryTagData;
import org.lsst.ccs.config.WriterProvider;

public class LocalConfigurationDAO
implements ConfigurationDAO {
    private static final Logger LOG = Logger.getLogger(LocalConfigurationDAO.class.getName());
    private final WriterProvider wp;
    private final boolean generateVersions;
    private final Map<String, Integer> fileMaxVersion = new ConcurrentHashMap<String, Integer>();
    private final Map<String, Integer> defaultVersions = new ConcurrentHashMap<String, Integer>();
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();

    public LocalConfigurationDAO() {
        this.wp = WriterProvider.getInstance();
        LOG.log(Level.FINEST, "Created LocalConfigurationDAO wtih WriterProvider {0}", this.wp.getClass().getCanonicalName());
        this.generateVersions = "true".equals(BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.testcontext", "false"));
    }

    public SingleCategoryTagData loadCategoryTag(SingleCategoryTag singleCategoryTag) throws ConfigurationServiceException {
        LOG.log(Level.FINEST, "local loadconfig desc tags {0}", singleCategoryTag);
        try {
            String fileName = LocalConfigurationDAO.toPropertiesFileName(singleCategoryTag);
            InputStream is = this.wp.getInputStream(fileName);
            if (is == null) {
                throw new IOException("Could not find file " + fileName);
            }
            LOG.log(Level.INFO, "Loaded file {0}", this.wp.locateFile(fileName));
            SingleCategoryTag loadedTag = this.generateSingleCategoryTagWithVersion(singleCategoryTag, false);
            SingleCategoryTagData data = new SingleCategoryTagData(loadedTag);
            data.load(is);
            this.notifyLoadListeners(loadedTag);
            return data;
        }
        catch (IOException ioe) {
            throw new ConfigurationServiceException("Exception while loading " + singleCategoryTag, (Throwable)ioe);
        }
    }

    public void updateSingleCategoryTagDefaultVersion(SingleCategoryTag tag) {
        this.updateSingleCategoryTagDefaultVersion(tag, tag.getResolvedVersion());
    }

    public void updateSingleCategoryTagDefaultVersion(SingleCategoryTag tag, String version) {
        Integer intVer = Integer.parseInt(version);
        String fileName = LocalConfigurationDAO.toPropertiesFileName(tag);
        this.defaultVersions.put(fileName, intVer);
    }

    private SingleCategoryTag generateSingleCategoryTagWithVersion(SingleCategoryTag inputTag, boolean isSave) {
        String resolvedVersion;
        if (!this.generateVersions) {
            return new SingleCategoryTag(inputTag);
        }
        String fileName = LocalConfigurationDAO.toPropertiesFileName(inputTag);
        if (isSave) {
            Integer saveVersion;
            Integer n = saveVersion = this.fileMaxVersion.computeIfAbsent(fileName, f -> 0);
            saveVersion = saveVersion + 1;
            this.fileMaxVersion.put(fileName, saveVersion);
            resolvedVersion = saveVersion.toString();
        } else {
            String requestedVersion = inputTag.getRequestedVersion();
            Integer requestedIntVersion = null;
            try {
                requestedIntVersion = Integer.parseInt(requestedVersion);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (requestedIntVersion == null) {
                if (requestedVersion.equals("d")) {
                    requestedIntVersion = this.defaultVersions.computeIfAbsent(fileName, f -> 1);
                    if (!this.fileMaxVersion.containsKey(fileName)) {
                        this.fileMaxVersion.put(fileName, requestedIntVersion);
                    }
                } else {
                    throw new IllegalArgumentException("Unknown requested version " + requestedVersion);
                }
            }
            resolvedVersion = requestedIntVersion.toString();
        }
        SingleCategoryTag resolvedTag = new SingleCategoryTag(inputTag, resolvedVersion);
        return resolvedTag;
    }

    public SingleCategoryTag saveCategoryTagData(SingleCategoryTagData data) throws ConfigurationServiceException {
        SingleCategoryTag singleCategoryTag = data.getSingleCategoryTag();
        try (PrintWriter writer = this.wp.getPrintWriter(LocalConfigurationDAO.toPropertiesFileName(data.getSingleCategoryTag()));){
            String dataStr = data.fullDataString();
            writer.println(dataStr);
            writer.flush();
        }
        catch (IOException ex) {
            throw new ConfigurationServiceException("could not open file", (Throwable)ex);
        }
        SingleCategoryTag savedTag = this.generateSingleCategoryTagWithVersion(singleCategoryTag, true);
        this.notifySaveListeners(savedTag);
        return savedTag;
    }

    public static String toPropertiesFileName(SingleCategoryTag singleCategoryTag) {
        String category;
        StringBuilder sb = new StringBuilder();
        sb = sb.append(singleCategoryTag.getSource());
        String tag = singleCategoryTag.getTag();
        if (!tag.isEmpty()) {
            sb = sb.append("_").append(tag);
        }
        if (!(category = singleCategoryTag.getCategory()).isEmpty()) {
            if (!sb.toString().contains("_")) {
                sb = sb.append("_");
            }
            sb = sb.append("_").append(category);
        }
        return sb.append(".properties").toString();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeLoadedTagListener(Listener listener) {
        this.listeners.remove(listener);
    }

    private void notifyLoadListeners(SingleCategoryTag tag) {
        this.listeners.forEach(l -> l.loadedTag(tag));
    }

    private void notifySaveListeners(SingleCategoryTag tag) {
        this.listeners.forEach(l -> l.savedTag(tag));
    }

    public static interface Listener {
        public void loadedTag(SingleCategoryTag var1);

        public void savedTag(SingleCategoryTag var1);
    }
}

