/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import java.nio.ByteBuffer;
import org.lsst.ccs.drivers.reb.ImageClient;
import org.lsst.ccs.drivers.reb.ImageMetadata;

public class Image
extends ImageMetadata {
    public static final int MAX_CCDS = 3;
    public static final int STATUS_GOOD = 0;
    public static final int STATUS_MISSING = 1;
    public static final int STATUS_INCOMPLETE = 2;
    private long mdata;
    private ImageClient.Impl client;
    private ByteBuffer data;
    private final ByteBuffer[] idata = new ByteBuffer[3];
    protected boolean interleaved;
    private int status;
    private static final long serialVersionUID = 1313601326490669879L;

    public Image() {
    }

    public Image(String name, long timestamp, int length, String partition, int address, long sciId, int sensorType, int numCcds, int stripes, int[] registers, int sciVersion, String clientVersion, String serverVersion, String platform, int[] members, ImageClient.Impl client) {
        super(name, timestamp, length, partition, address, sciId, sensorType, numCcds, stripes, registers, sciVersion, clientVersion, serverVersion, platform, members);
        this.interleaved = false;
        this.client = client;
    }

    public Image(String name, long timestamp, int length, String partition, int address, long sciId, int sensorType, int numCcds, int stripes, int[] registers, int sciVersion, String clientVersion, String serverVersion, String platform, int[] members, ByteBuffer[] data) {
        super(name, timestamp, length, partition, address, sciId, sensorType, numCcds, stripes, registers, sciVersion, clientVersion, serverVersion, platform, members);
        this.interleaved = false;
        for (int j = 0; j < this.idata.length; ++j) {
            this.idata[j] = data != null && j < data.length ? data[j] : null;
        }
    }

    public Image(String name, long timestamp, int length, int address, long sciId, int sensorType, int stripes, int[] registers, int sciVersion, String clientVersion, String serverVersion, long event, int[] members, long mdata, ImageClient.Impl client) {
        super(name, timestamp, length, address, sciId, sensorType, stripes, registers, sciVersion, clientVersion, serverVersion, event, members);
        this.interleaved = true;
        this.mdata = mdata;
        this.client = client;
    }

    public Image(String name, long timestamp, int length, int address, long sciId, int sensorType, int stripes, int[] registers, int sciVersion, String clientVersion, String serverVersion, long event, int[] members, ByteBuffer data) {
        super(name, timestamp, length, address, sciId, sensorType, stripes, registers, sciVersion, clientVersion, serverVersion, event, members);
        this.interleaved = true;
        this.data = data;
    }

    public Image(long tag, int length, int format, int schema, int version, int address, int cluster, int element, long mdata, ImageClient.Impl client) {
        super(tag, length, format, schema, version, address, cluster, element);
        this.interleaved = true;
        this.mdata = mdata;
        this.client = client;
    }

    public Image(long tag, int length, int format, int schema, int version, int address, int cluster, int element, ByteBuffer data) {
        super(tag, length, format, schema, version, address, cluster, element);
        this.interleaved = true;
        this.data = data;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isInterleaved() {
        return this.interleaved;
    }

    public ByteBuffer getData() {
        return this.data != null && this.data.limit() > 0 ? this.data.asReadOnlyBuffer() : null;
    }

    public ByteBuffer getData(int ccdNum) {
        ByteBuffer dat = this.idata[ccdNum];
        return dat != null && dat.limit() > 0 ? dat.asReadOnlyBuffer() : null;
    }

    public ImageMetadata getMetadata() {
        return new ImageMetadata(this.name, this.timestamp, this.length, this.partition, this.address, this.sciId, this.sensorType, this.numCcds, this.stripes, this.registers, this.sciVersion, this.clientVersion, this.serverVersion, this.platform, this.members);
    }

    public void deleteMetadataRef() {
        if (this.mdata != 0L) {
            this.client.deleteImageMetadataRef(this);
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.deleteMetadataRef();
    }
}

