/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.base.Const;
import org.lsst.ccs.gconsole.base.filter.AbstractChannelsFilter;
import org.lsst.ccs.gconsole.base.filter.AgentChannelsFilter;
import org.lsst.ccs.gconsole.plugins.monitor.AbstractMonitorView;
import org.lsst.ccs.gconsole.plugins.monitor.DisplayChannel;
import org.lsst.ccs.gconsole.plugins.monitor.FormattedValue;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorFormat;
import org.lsst.ccs.gconsole.plugins.monitor.Updatable;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.command.CommandService;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.subsystem.common.focalplane.data.HasFocalPlaneData;
import org.lsst.ccs.subsystem.common.ui.focalplane.Segment;

public final class RebPowerControlPanel
extends JPanel {
    public static final Color COLOR_UNKNOWN = Color.WHITE;
    public static final Color COLOR_ON = Color.GREEN;
    public static final Color COLOR_OFF = Color.RED;
    public static final Color COLOR_TRIPPED = Color.MAGENTA;
    public static final Color COLOR_OFFLINE = MonitorField.COLOR_OFF;
    public static final String PATH_MAIN_STATE = "RebPowerState";
    public static final String PATH_HV_STATE = "RebHvBiasState";
    public static final String PATH_DPHI_STATE = "RebDPhiState";
    public static final String PATH_HV_VALUE = "hvBias";
    public static final String PATH_DPHI_VALUE = "dphi";
    public static final String PATH_HV_V = "hvbias/VbefSwch";
    public static final String PATH_HV_I = "hvbias/IbefSwch";
    private final AgentInfo agent;
    private View view;
    private Map<String, DisplayChannel> localData;
    private TreeSet<String> scienceRafts;
    private TreeSet<String> cornerRafts;

    public RebPowerControlPanel(AgentInfo agent) {
        this.agent = agent;
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
    }

    private void opened() {
        this.view = new View();
        this.view.install();
    }

    private void closed() {
        if (this.view != null) {
            this.view.uninstall();
            this.view = null;
        }
    }

    private void rebuild() {
        Font f;
        JLabel title;
        this.removeAll();
        this.scienceRafts = new TreeSet();
        this.cornerRafts = new TreeSet();
        for (String path : this.localData.keySet()) {
            String raft = path.substring(0, Segment.RAFT.toString().length() + 2);
            if (raft.contains("00") || raft.contains("04") || raft.contains("40") || raft.contains("44")) {
                this.cornerRafts.add(raft);
            } else {
                this.scienceRafts.add(raft);
            }
            if (this.cornerRafts.size() != 4 || this.scienceRafts.size() != 21) continue;
            break;
        }
        if (!this.scienceRafts.isEmpty()) {
            title = new JLabel("Science RAFTs");
            f = title.getFont();
            f = new Font(f.getName(), 1, f.getSize() + 2);
            title.setFont(f);
            this.add(title);
            this.add(Box.createRigidArea(Const.VDIM));
            this.add(new ScienceTable());
            this.add(Box.createRigidArea(Const.VDIM));
        }
        if (!this.cornerRafts.isEmpty()) {
            this.add(Box.createRigidArea(Const.VDIM));
            title = new JLabel("Corner RAFTs");
            f = title.getFont();
            f = new Font(f.getName(), 1, f.getSize() + 2);
            title.setFont(f);
            this.add(title);
            this.add(Box.createRigidArea(Const.VDIM));
            this.add(new CornerTable());
            this.add(Box.createRigidArea(Const.VDIM));
        }
        this.add(Box.createVerticalGlue());
    }

    private final class View
    extends AbstractMonitorView {
        View() {
            this.setFilter((AgentChannelsFilter)new Filter());
        }

        protected void resetChannels() {
            if (RebPowerControlPanel.this.localData != null) {
                RebPowerControlPanel.this.localData.values().forEach(channel -> channel.setTarget(null));
            }
            RebPowerControlPanel.this.localData = new HashMap(this.data);
            RebPowerControlPanel.this.rebuild();
        }

        public JComponent getPanel() {
            return null;
        }

        public AbstractMonitorView.Descriptor getDescriptor() {
            return null;
        }
    }

    private class ScienceTable
    extends JPanel {
        ScienceTable() {
            this.setBorder(BorderFactory.createEtchedBorder());
            GridBagLayout gridbag = new GridBagLayout();
            this.setLayout(gridbag);
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(5, 10, 5, 10);
            c.anchor = 10;
            c.gridx = 1;
            c.gridy = 0;
            JLabel label = new JLabel("REB 0");
            gridbag.setConstraints(label, c);
            this.add(label);
            c.gridx = 2;
            label = new JLabel("REB 1");
            gridbag.setConstraints(label, c);
            this.add(label);
            c.gridx = 3;
            label = new JLabel("REB 2");
            gridbag.setConstraints(label, c);
            this.add(label);
            GridBagConstraints cRaft = new GridBagConstraints();
            cRaft.insets = new Insets(5, 10, 5, 10);
            cRaft.anchor = 10;
            cRaft.gridx = 0;
            cRaft.gridy = 0;
            c = new GridBagConstraints();
            c.anchor = 10;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            for (String raft : RebPowerControlPanel.this.scienceRafts) {
                label = new JLabel(raft);
                gridbag.setConstraints(label, cRaft);
                this.add(label);
                c.gridy = ++cRaft.gridy;
                for (int iReb = 0; iReb < 3; ++iReb) {
                    c.gridx = iReb + 1;
                    String reb = Segment.REB.toString() + iReb;
                    String prefix = raft + "/" + reb + "/";
                    RebPanel p = new RebPanel(prefix);
                    gridbag.setConstraints(p, c);
                    this.add(p);
                }
            }
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }

    private class CornerTable
    extends JPanel {
        CornerTable() {
            this.setBorder(BorderFactory.createEtchedBorder());
            GridBagLayout gridbag = new GridBagLayout();
            this.setLayout(gridbag);
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(5, 10, 5, 10);
            c.anchor = 10;
            c.gridx = 1;
            c.gridy = 0;
            JLabel label = new JLabel("Wavefront REB");
            gridbag.setConstraints(label, c);
            this.add(label);
            c.gridx = 2;
            label = new JLabel("Guider REB");
            gridbag.setConstraints(label, c);
            this.add(label);
            GridBagConstraints cRaft = new GridBagConstraints();
            cRaft.insets = new Insets(5, 10, 5, 10);
            cRaft.anchor = 10;
            cRaft.gridx = 0;
            cRaft.gridy = 0;
            c = new GridBagConstraints();
            c.anchor = 10;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            for (String raft : RebPowerControlPanel.this.cornerRafts) {
                label = new JLabel(raft);
                gridbag.setConstraints(label, cRaft);
                this.add(label);
                c.gridy = ++cRaft.gridy;
                c.gridx = 1;
                String prefix = raft + "/" + Segment.REB.toString() + "W/";
                CornerPanel p = new CornerPanel(prefix);
                gridbag.setConstraints(p, c);
                this.add(p);
                c.gridx = 2;
                prefix = raft + "/" + Segment.REB.toString() + "G/";
                p = new CornerPanel(prefix);
                gridbag.setConstraints(p, c);
                this.add(p);
            }
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }

    private static class TrendButton
    extends JLabel
    implements Updatable {
        DisplayChannel channel;

        TrendButton(DisplayChannel channel) {
            this.channel = channel;
            this.setOpaque(true);
            this.setToolTipText(channel.getPath());
            this.update(channel);
        }

        public void update(DisplayChannel channelHandle) {
            FormattedValue fv = MonitorFormat.DEFAULT.format(MonitorField.VALUE, this.channel);
            this.setBackground(fv.getBgColor());
            this.setForeground(fv.getFgColor());
            this.setText(fv.getText() + this.channel.getChannel().get((Object)AgentChannel.Key.UNITS));
        }
    }

    private static class ConfigButton
    extends JLabel
    implements Updatable {
        private static final MonitorField FIELD;
        DisplayChannel channel;

        ConfigButton(DisplayChannel channel) {
            this.channel = channel;
            this.setToolTipText(channel.getPath());
            this.update(channel);
        }

        public void update(DisplayChannel channelHandle) {
            FormattedValue fv = MonitorFormat.DEFAULT.format(FIELD, this.channel);
            this.setBackground(fv.getBgColor());
            this.setForeground(fv.getFgColor());
            this.setText(fv.getText());
        }

        static {
            FormattedValue fv = new FormattedValue(null, null, null, Integer.valueOf(0), null, Boolean.valueOf(false));
            FIELD = new MonitorField("value", "", fv, null);
        }
    }

    private static class PowerButton
    extends JLabel
    implements Updatable {
        private final DisplayChannel channel;

        PowerButton(DisplayChannel channel) {
            this.channel = channel;
            this.setBorder(BorderFactory.createBevelBorder(0));
            this.setOpaque(true);
            this.setBackground(COLOR_UNKNOWN);
            switch (this.getType()) {
                case 0: {
                    this.setText("   Main   ");
                    break;
                }
                case 1: {
                    this.setText(" HV Bias ");
                    break;
                }
                case 2: {
                    this.setText("   DPhi   ");
                }
            }
            this.setToolTipText(Segment.getPathPrefix((String)channel.getPath()));
            this.update(channel);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 1) {
                        this.onMouseClick();
                    }
                }
            });
        }

        public void update(DisplayChannel channelHandle) {
            String state = (String)this.channel.getChannel().get();
            if (state == null) {
                this.setBackground(COLOR_UNKNOWN);
            } else {
                switch (state) {
                    case "TRIPPED": {
                        this.setBackground(COLOR_TRIPPED);
                        break;
                    }
                    case "OFF": {
                        this.setBackground(COLOR_OFF);
                        break;
                    }
                    case "ON": {
                        this.setBackground(COLOR_ON);
                        break;
                    }
                    default: {
                        this.setBackground(COLOR_UNKNOWN);
                    }
                }
            }
        }

        private int getType() {
            String path = this.channel.getPath();
            if (path.endsWith(RebPowerControlPanel.PATH_MAIN_STATE)) {
                return 0;
            }
            if (path.endsWith(RebPowerControlPanel.PATH_HV_STATE)) {
                return 1;
            }
            if (path.endsWith(RebPowerControlPanel.PATH_DPHI_STATE)) {
                return 2;
            }
            return -1;
        }

        private void onMouseClick() {
            Color bg = this.getBackground();
            String message = null;
            boolean switchOn = false;
            if (COLOR_TRIPPED.equals(bg)) {
                message = "Reset?";
            } else if (COLOR_OFF.equals(bg)) {
                message = "Switch ON?";
                switchOn = true;
            } else if (COLOR_ON.equals(bg)) {
                message = "Switch OFF?";
            }
            if (message != null) {
                int out;
                String title = Segment.getPathPrefix((String)this.channel.getPath());
                if (title.endsWith("/")) {
                    title = title.substring(0, title.length() - 1);
                }
                if ((out = JOptionPane.showConfirmDialog(this, message, title, 2)) == 0) {
                    StringBuilder command = new StringBuilder(this.channel.getChannel().getAgentName()).append("/").append(title).append(" ");
                    switch (this.getType()) {
                        case 0: {
                            command.append("powerReb");
                            break;
                        }
                        case 1: {
                            command.append(RebPowerControlPanel.PATH_HV_VALUE);
                            break;
                        }
                        case 2: {
                            command.append(RebPowerControlPanel.PATH_DPHI_VALUE);
                        }
                    }
                    command.append(switchOn ? "On" : "Off");
                    CommandService.getService().send(command.toString());
                }
            }
        }
    }

    private class CornerPanel
    extends Box {
        CornerPanel(String prefix) {
            JLabel b;
            super(0);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
            this.add(Box.createRigidArea(Const.HDIM));
            this.add(Box.createHorizontalGlue());
            String path = prefix + RebPowerControlPanel.PATH_MAIN_STATE;
            DisplayChannel channel = (DisplayChannel)RebPowerControlPanel.this.localData.get(path);
            if (channel != null) {
                b = new PowerButton(channel);
                channel.setTarget((Updatable)b);
                this.add(b);
            }
            this.add(Box.createRigidArea(Const.HDIM));
            this.add(Box.createHorizontalGlue());
            path = prefix + RebPowerControlPanel.PATH_HV_STATE;
            channel = (DisplayChannel)RebPowerControlPanel.this.localData.get(path);
            if (channel != null) {
                b = new PowerButton(channel);
                channel.setTarget((Updatable)b);
                this.add(b);
            }
            this.add(Box.createRigidArea(Const.HDIM));
            this.add(Box.createHorizontalGlue());
            path = prefix + RebPowerControlPanel.PATH_HV_VALUE;
            channel = (DisplayChannel)RebPowerControlPanel.this.localData.get(path);
            if (channel != null) {
                b = new ConfigButton(channel);
                channel.setTarget((Updatable)b);
                this.add(b);
            }
            this.add(Box.createRigidArea(Const.HDIM));
            this.add(Box.createHorizontalGlue());
            path = prefix + RebPowerControlPanel.PATH_HV_V;
            channel = (DisplayChannel)RebPowerControlPanel.this.localData.get(path);
            if (channel != null) {
                b = new TrendButton(channel);
                channel.setTarget((Updatable)b);
                this.add(b);
            }
            this.add(Box.createRigidArea(Const.HDIM));
            this.add(Box.createHorizontalGlue());
            path = prefix + RebPowerControlPanel.PATH_HV_I;
            channel = (DisplayChannel)RebPowerControlPanel.this.localData.get(path);
            if (channel != null) {
                b = new TrendButton(channel);
                channel.setTarget((Updatable)b);
                this.add(b);
            }
            this.add(Box.createRigidArea(Const.HDIM));
            this.add(Box.createHorizontalGlue());
            path = prefix + RebPowerControlPanel.PATH_DPHI_STATE;
            channel = (DisplayChannel)RebPowerControlPanel.this.localData.get(path);
            if (channel != null) {
                b = new PowerButton(channel);
                channel.setTarget((Updatable)b);
                this.add(b);
            }
            this.add(Box.createRigidArea(Const.HDIM));
            this.add(Box.createHorizontalGlue());
            path = prefix + RebPowerControlPanel.PATH_DPHI_VALUE;
            channel = (DisplayChannel)RebPowerControlPanel.this.localData.get(path);
            if (channel != null) {
                b = new ConfigButton(channel);
                channel.setTarget((Updatable)b);
                this.add(b);
            }
            this.add(Box.createRigidArea(Const.HDIM));
            this.add(Box.createHorizontalGlue());
        }
    }

    private class RebPanel
    extends Box {
        RebPanel(String prefix) {
            JLabel b;
            super(0);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
            this.add(Box.createRigidArea(Const.HDIM));
            this.add(Box.createHorizontalGlue());
            String path = prefix + RebPowerControlPanel.PATH_MAIN_STATE;
            DisplayChannel channel = (DisplayChannel)RebPowerControlPanel.this.localData.get(path);
            if (channel != null) {
                b = new PowerButton(channel);
                channel.setTarget((Updatable)b);
                this.add(b);
            }
            this.add(Box.createRigidArea(Const.HDIM));
            this.add(Box.createHorizontalGlue());
            path = prefix + RebPowerControlPanel.PATH_HV_STATE;
            channel = (DisplayChannel)RebPowerControlPanel.this.localData.get(path);
            if (channel != null) {
                b = new PowerButton(channel);
                channel.setTarget((Updatable)b);
                this.add(b);
            }
            this.add(Box.createRigidArea(Const.HDIM));
            this.add(Box.createHorizontalGlue());
            path = prefix + RebPowerControlPanel.PATH_HV_VALUE;
            channel = (DisplayChannel)RebPowerControlPanel.this.localData.get(path);
            if (channel != null) {
                b = new ConfigButton(channel);
                channel.setTarget((Updatable)b);
                this.add(b);
            }
            this.add(Box.createRigidArea(Const.HDIM));
            this.add(Box.createHorizontalGlue());
            path = prefix + RebPowerControlPanel.PATH_HV_V;
            channel = (DisplayChannel)RebPowerControlPanel.this.localData.get(path);
            if (channel != null) {
                b = new TrendButton(channel);
                channel.setTarget((Updatable)b);
                this.add(b);
            }
            this.add(Box.createRigidArea(Const.HDIM));
            this.add(Box.createHorizontalGlue());
            path = prefix + RebPowerControlPanel.PATH_HV_I;
            channel = (DisplayChannel)RebPowerControlPanel.this.localData.get(path);
            if (channel != null) {
                b = new TrendButton(channel);
                channel.setTarget((Updatable)b);
                this.add(b);
            }
            this.add(Box.createRigidArea(Const.HDIM));
            this.add(Box.createHorizontalGlue());
        }
    }

    private class Filter
    extends AbstractChannelsFilter {
        private final String prefixState;
        private final String prefixConf;
        private final String prefixTrend;
        private final int prefixLengthState;
        private final int prefixLengthConf;
        private final int prefixLengthTrend;

        private Filter() {
            this.prefixState = RebPowerControlPanel.this.agent.getName() + "/states/";
            this.prefixConf = RebPowerControlPanel.this.agent.getName() + "/configuration/";
            this.prefixTrend = RebPowerControlPanel.this.agent.getName() + "/";
            this.prefixLengthState = this.prefixState.length();
            this.prefixLengthConf = this.prefixConf.length();
            this.prefixLengthTrend = this.prefixTrend.length();
        }

        public List<String> getAgents() {
            return Collections.singletonList(RebPowerControlPanel.this.agent.getName());
        }

        public List<String> getOriginChannels() {
            ArrayList<String> templates = new ArrayList<String>(2);
            templates.add(this.prefixState);
            templates.add(this.prefixConf);
            templates.add(".+/hvbias/VbefSwch");
            templates.add(".+/hvbias/IbefSwch");
            return templates;
        }

        public String getOriginPath(String displayPath) {
            String prefix = displayPath.endsWith("State") ? this.prefixState : (displayPath.contains("/") ? this.prefixTrend : this.prefixConf);
            return prefix + displayPath;
        }

        public String getDisplayPath(String originPath) {
            if (originPath.endsWith(RebPowerControlPanel.PATH_HV_V) || originPath.endsWith(RebPowerControlPanel.PATH_HV_I)) {
                return originPath.substring(this.prefixLengthTrend);
            }
            if (originPath.endsWith(RebPowerControlPanel.PATH_MAIN_STATE) || originPath.endsWith(RebPowerControlPanel.PATH_HV_STATE) || originPath.endsWith(RebPowerControlPanel.PATH_DPHI_STATE)) {
                return originPath.substring(this.prefixLengthState);
            }
            if (originPath.endsWith(RebPowerControlPanel.PATH_HV_VALUE) || originPath.endsWith(RebPowerControlPanel.PATH_DPHI_VALUE)) {
                return originPath.substring(this.prefixLengthConf);
            }
            return null;
        }
    }

    public static class OptPage
    implements OptionalPage {
        private final HashMap<String, RebPowerControlPanel> panels = new HashMap(2, 0.75f);

        public boolean isAutoOpen() {
            return false;
        }

        public String getPage(AgentInfo agent) {
            if (agent.getAgentProperty("agentCategory", "").equals(AgentCategory.POWER.name()) && !agent.getAgentProperty(HasFocalPlaneData.AGENT_PROPERTY, "").isEmpty()) {
                return "CCS Subsystems/" + agent.getName() + "/Reb Power Control";
            }
            return null;
        }

        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            String path = this.getPage(agent);
            if (path == null) {
                return null;
            }
            RebPowerControlPanel panel = this.panels.get(path);
            if (panel == null) {
                panel = new RebPowerControlPanel(agent);
                this.panels.put(path, panel);
            }
            return new JScrollPane(panel);
        }

        public void opened(String path) {
            RebPowerControlPanel panel = this.panels.get(path);
            if (panel != null) {
                panel.opened();
            }
        }

        public void closed(String path) {
            RebPowerControlPanel panel = this.panels.remove(path);
            if (panel != null) {
                panel.closed();
            }
        }
    }
}

