/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.astrogrid.samp.DataException;
import org.astrogrid.samp.JsonReader;

class JsonWriter {
    private final int indent_;
    private final String spc_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public JsonWriter() {
        this(2, true);
    }

    public JsonWriter(int indent, boolean spacer) {
        this.indent_ = indent;
        this.spc_ = spacer ? " " : "";
    }

    public String toJson(Object item) {
        StringBuffer sbuf = new StringBuffer();
        this.toJson(sbuf, item, 0, false);
        if (this.indent_ >= 0) {
            if (!$assertionsDisabled && sbuf.charAt(0) != '\n') {
                throw new AssertionError();
            }
            return sbuf.substring(1, sbuf.length());
        }
        return sbuf.toString();
    }

    private void toJson(StringBuffer sbuf, Object item, int level, boolean isPositioned) {
        if (item instanceof String) {
            if (!isPositioned) {
                sbuf.append(this.getIndent(level));
            }
            sbuf.append('\"').append((String)item).append('\"');
        } else if (item instanceof List) {
            List list = (List)item;
            if (list.isEmpty()) {
                if (!isPositioned) {
                    sbuf.append(this.getIndent(level));
                }
                sbuf.append("[]");
            } else {
                sbuf.append(this.getIntroIndent(level, '[', isPositioned));
                boolean isPos = !isPositioned;
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    this.toJson(sbuf, it.next(), level + 1, isPos);
                    if (it.hasNext()) {
                        sbuf.append(",");
                    }
                    isPos = false;
                }
                sbuf.append(this.spc_ + "]");
            }
        } else if (item instanceof Map) {
            Map map = (Map)item;
            if (map.isEmpty()) {
                if (!isPositioned) {
                    sbuf.append(this.getIndent(level));
                }
                sbuf.append("{}");
            } else {
                sbuf.append(this.getIntroIndent(level, '{', isPositioned));
                boolean isPos = !isPositioned;
                Iterator it = map.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    Object key = entry.getKey();
                    if (!(key instanceof String)) {
                        throw new DataException("Non-string key in map:" + key);
                    }
                    this.toJson(sbuf, key, level + 1, isPos);
                    sbuf.append(":" + this.spc_);
                    this.toJson(sbuf, entry.getValue(), level + 1, true);
                    if (it.hasNext()) {
                        sbuf.append(",");
                    }
                    isPos = false;
                }
                sbuf.append(this.spc_ + "}");
            }
        } else {
            throw new DataException("Illegal data type " + item);
        }
    }

    private String getIntroIndent(int level, char chr, boolean isPositioned) {
        if (isPositioned) {
            return "" + chr;
        }
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.getIndent(level));
        sbuf.append(chr);
        for (int ic = 0; ic < this.indent_ - 1; ++ic) {
            sbuf.append(' ');
        }
        return sbuf.toString();
    }

    private String getIndent(int level) {
        if (this.indent_ >= 0) {
            int nc = level * this.indent_;
            StringBuffer sbuf = new StringBuffer(nc + 1);
            sbuf.append('\n');
            for (int ic = 0; ic < nc; ++ic) {
                sbuf.append(' ');
            }
            return sbuf.toString();
        }
        return "";
    }

    public static void main(String[] args) {
        String txt = args[0];
        Object item = new JsonReader().read(txt);
        System.out.println(new JsonWriter().toJson(item));
    }

    static {
        $assertionsDisabled = !JsonWriter.class.desiredAssertionStatus();
    }
}

