/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.gui;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import org.lsst.ccs.subsystem.motorplatform.bus.IOStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.PlatformConfig;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class DigitalInputPanel
extends JPanel {
    private final List<JToggleButton> toggles;
    private final List<JLabel> toggleLabels;
    private final List<String> staticTexts;
    private final List<String> zeroTexts;
    private final List<String> oneTexts;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JToggleButton jToggleButton1;
    private JToggleButton jToggleButton2;
    private JToggleButton jToggleButton3;
    private JToggleButton jToggleButton4;
    private JToggleButton jToggleButton5;
    private JToggleButton jToggleButton6;
    private JToggleButton jToggleButton7;
    private JToggleButton jToggleButton8;

    public DigitalInputPanel() {
        this.initComponents();
        this.toggles = Arrays.asList(this.jToggleButton1, this.jToggleButton2, this.jToggleButton3, this.jToggleButton4, this.jToggleButton5, this.jToggleButton6, this.jToggleButton7, this.jToggleButton8);
        this.toggleLabels = Arrays.asList(this.jLabel2, this.jLabel3, this.jLabel4, this.jLabel5, this.jLabel6, this.jLabel7, this.jLabel8, this.jLabel9);
        for (int i = 0; i < this.toggles.size(); ++i) {
            JToggleButton tog = this.toggles.get(i);
            tog.addActionListener(evt -> tog.setSelected(!tog.isSelected()));
        }
        Object[] empties = new String[this.toggles.size()];
        Arrays.fill(empties, "");
        this.staticTexts = new ArrayList<Object>(Arrays.asList(empties));
        this.zeroTexts = new ArrayList<String>(this.staticTexts);
        this.oneTexts = new ArrayList<String>(this.staticTexts);
    }

    public void configure(PlatformConfig config) {
        List<String> names = config.getDigitalInputNames();
        for (int i = 0; i < this.toggles.size(); ++i) {
            if (i < names.size()) {
                String[] nm = names.get(i).split("\\|");
                this.staticTexts.set(i, nm[0]);
                if (nm.length > 1) {
                    this.zeroTexts.set(i, nm[1]);
                }
                if (nm.length > 2) {
                    this.oneTexts.set(i, nm[2]);
                }
                this.toggleLabels.get(i).setText(this.staticTexts.get(i));
                this.toggles.get(i).setEnabled(true);
                continue;
            }
            this.toggles.get(i).setEnabled(false);
            this.toggleLabels.get(i).setText("");
        }
    }

    public void update(IOStatus status) {
        int bits = status.getDigitalInputs();
        for (int i = 0; i < this.toggles.size(); ++i) {
            boolean selected = (bits & 1) == 1;
            this.toggles.get(i).setSelected(selected);
            this.toggleLabels.get(i).setText((selected ? this.oneTexts.get(i) : this.zeroTexts.get(i)) + this.staticTexts.get(i));
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jToggleButton1 = new JToggleButton();
        this.jToggleButton2 = new JToggleButton();
        this.jToggleButton3 = new JToggleButton();
        this.jToggleButton4 = new JToggleButton();
        this.jToggleButton5 = new JToggleButton();
        this.jToggleButton6 = new JToggleButton();
        this.jToggleButton7 = new JToggleButton();
        this.jToggleButton8 = new JToggleButton();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel1.setFont(new Font("DejaVu LGC Sans", 3, 13));
        this.jLabel1.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(DigitalInputPanel.class, (String)"DigitalInputPanel.jLabel1.text"));
        this.jToggleButton1.setFont(new Font("Courier", 0, 13));
        Mnemonics.setLocalizedText((AbstractButton)this.jToggleButton1, (String)NbBundle.getMessage(DigitalInputPanel.class, (String)"DigitalInputPanel.jToggleButton1.text"));
        this.jToggleButton1.setHorizontalTextPosition(4);
        this.jToggleButton2.setFont(new Font("Courier", 0, 13));
        Mnemonics.setLocalizedText((AbstractButton)this.jToggleButton2, (String)NbBundle.getMessage(DigitalInputPanel.class, (String)"DigitalInputPanel.jToggleButton2.text"));
        this.jToggleButton3.setFont(new Font("Courier", 0, 13));
        Mnemonics.setLocalizedText((AbstractButton)this.jToggleButton3, (String)NbBundle.getMessage(DigitalInputPanel.class, (String)"DigitalInputPanel.jToggleButton3.text"));
        this.jToggleButton4.setFont(new Font("Courier", 0, 13));
        Mnemonics.setLocalizedText((AbstractButton)this.jToggleButton4, (String)NbBundle.getMessage(DigitalInputPanel.class, (String)"DigitalInputPanel.jToggleButton4.text"));
        this.jToggleButton5.setFont(new Font("Courier", 0, 13));
        Mnemonics.setLocalizedText((AbstractButton)this.jToggleButton5, (String)NbBundle.getMessage(DigitalInputPanel.class, (String)"DigitalInputPanel.jToggleButton5.text"));
        this.jToggleButton6.setFont(new Font("Courier", 0, 13));
        Mnemonics.setLocalizedText((AbstractButton)this.jToggleButton6, (String)NbBundle.getMessage(DigitalInputPanel.class, (String)"DigitalInputPanel.jToggleButton6.text"));
        this.jToggleButton7.setFont(new Font("Courier", 0, 13));
        Mnemonics.setLocalizedText((AbstractButton)this.jToggleButton7, (String)NbBundle.getMessage(DigitalInputPanel.class, (String)"DigitalInputPanel.jToggleButton7.text"));
        this.jToggleButton8.setFont(new Font("Courier", 0, 13));
        Mnemonics.setLocalizedText((AbstractButton)this.jToggleButton8, (String)NbBundle.getMessage(DigitalInputPanel.class, (String)"DigitalInputPanel.jToggleButton8.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(DigitalInputPanel.class, (String)"DigitalInputPanel.jLabel2.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(DigitalInputPanel.class, (String)"DigitalInputPanel.jLabel3.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(DigitalInputPanel.class, (String)"DigitalInputPanel.jLabel4.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(DigitalInputPanel.class, (String)"DigitalInputPanel.jLabel5.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(DigitalInputPanel.class, (String)"DigitalInputPanel.jLabel6.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(DigitalInputPanel.class, (String)"DigitalInputPanel.jLabel7.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(DigitalInputPanel.class, (String)"DigitalInputPanel.jLabel8.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(DigitalInputPanel.class, (String)"DigitalInputPanel.jLabel9.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToggleButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3)).addGroup(layout.createSequentialGroup().addComponent(this.jToggleButton3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4)).addGroup(layout.createSequentialGroup().addComponent(this.jToggleButton4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5)).addGroup(layout.createSequentialGroup().addComponent(this.jToggleButton5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6)).addGroup(layout.createSequentialGroup().addComponent(this.jToggleButton6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7)).addGroup(layout.createSequentialGroup().addComponent(this.jToggleButton7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8)).addGroup(layout.createSequentialGroup().addComponent(this.jToggleButton8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel9)).addGroup(layout.createSequentialGroup().addComponent(this.jToggleButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jToggleButton1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jToggleButton2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jToggleButton3).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jToggleButton4).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jToggleButton5).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jToggleButton6).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jToggleButton7).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jToggleButton8).addComponent(this.jLabel9)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

