/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.auxelex;

import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.auxelex.Srp;
import org.lsst.ccs.drivers.commons.DriverException;

public class TestSrp {
    protected final Srp srp;
    protected final ConsThread consThread = new ConsThread();

    public TestSrp() {
        this.srp = new Srp();
    }

    public TestSrp(Srp srp) {
        this.srp = srp;
    }

    @Command(description="Set the SRP version")
    public void setSrpVersion(@Argument(description="Version number") int version) {
        this.srp.setSrpVersion(version);
    }

    @Command(description="Set the debug state")
    public void setDebug(@Argument(description="The state (on or off)") OnOff state) {
        this.srp.setDebug(state == OnOff.ON);
    }

    @Command(description="Open connection to device")
    public void connectIp(@Argument(description="IP address") String ipAddr, @Argument(description="Port number") int port) throws DriverException {
        this.srp.open(ipAddr, port);
        this.announce();
    }

    @Command(description="Open connection to device")
    public void connectIp(@Argument(description="IP address") String ipAddr) throws DriverException {
        this.srp.open(ipAddr);
        this.announce();
    }

    @Command(description="Open connection to device")
    public void connect(@Argument(description="Node number") int node, @Argument(description="Port number") int port) throws DriverException {
        this.srp.open(node, port);
        this.announce();
    }

    @Command(description="Open connection to device")
    public void connect(@Argument(description="Node number") int node) throws DriverException {
        this.srp.open(node);
        this.announce();
    }

    private void announce() {
        System.out.println("Board type is " + (Object)((Object)this.srp.getBoardType()));
    }

    @Command(description="Close connection to device")
    public void disconnect() throws DriverException {
        this.srp.close();
    }

    @Command(description="Show the board type")
    public Srp.BoardType showBoardType() throws DriverException {
        return this.srp.getBoardType();
    }

    @Command(description="Show the build stamp")
    public String showBuildStamp() throws DriverException {
        return this.srp.getBuildStamp();
    }

    @Command(description="Show the FPGA version")
    public String showFpgaVersion() throws DriverException {
        return String.format("0x%08x", this.srp.getFpgaVersion());
    }

    @Command(description="Show the board up time (seconds)")
    public int showUpSecs() throws DriverException {
        return this.srp.getUpTime();
    }

    @Command(description="Show the board up time (ddd hh:mm:ss)")
    public String showUpTime() throws DriverException {
        int secs = this.srp.getUpTime();
        int mins = secs / 60;
        int hrs = mins / 60;
        return String.format("%d %02d:%02d:%02d", hrs / 24, hrs % 60, mins % 60, secs % 60);
    }

    @Command(description="Write the scratch pad register")
    public void writeScratch(@Argument(description="The value to write") int value) throws DriverException {
        this.srp.writeScratchPad(value);
    }

    @Command(description="Read the scratch pad register")
    public int readScratch() throws DriverException {
        return this.srp.readScratchPad();
    }

    @Command(description="Perform a user reset")
    public void userReset() throws DriverException {
        this.srp.userReset();
    }

    @Command(description="Reload the FPGA")
    public void reloadFpga() throws DriverException {
        this.srp.reloadFpga();
    }

    @Command(description="Set the read timeout")
    public void setTimeout(@Argument(description="The timeout (ms)") int timeout) {
        this.srp.setReadTimeout(timeout);
    }

    @Command(description="Show the read timeout")
    public int showTimeout() {
        return this.srp.getReadTimeout();
    }

    @Command(description="Set the read warning time")
    public void setWarnTime(@Argument(description="The time (ms)") int time) {
        this.srp.setReadWarning(time);
    }

    @Command(description="Show the read warning time")
    public int showWarnTime() {
        return this.srp.getReadWarning();
    }

    @Command(description="Show the timeout count")
    public int showNumTimeout() {
        return this.srp.getNumTimeout();
    }

    @Command(description="Show the sequence error count")
    public int showNumSeqErr() {
        return this.srp.getNumSeqErr();
    }

    @Command(description="Read a register")
    public String read(@Argument(description="Register address") int addr) throws DriverException {
        return String.format("%08x", this.srp.readReg(addr));
    }

    @Command(description="Reads registers")
    public String read(@Argument(description="Register address") int addr, @Argument(description="Register count") int count) throws DriverException {
        return TestSrp.formatHex(addr, this.srp.readRegs(addr, count));
    }

    @Command(description="Write a register")
    public void write(@Argument(description="Register address") int addr, int ... value) throws DriverException {
        this.srp.writeRegs(addr, value);
    }

    @Command(description="Update a register")
    public void update(@Argument(description="Register address") int addr, @Argument(description="Mask of bits to change") int mask, @Argument(description="Register value") int value) throws DriverException {
        this.srp.updateReg(addr, mask, value);
    }

    @Command(description="Continuously read a set of registers")
    public String contRead(@Argument(description="First register address") int addr, @Argument(description="Number of registers") int count) throws DriverException {
        System.out.println("Press any key to terminate...");
        boolean[] done = new boolean[]{false};
        this.consThread.start(done);
        int nRead = 0;
        long startTime = System.currentTimeMillis();
        while (!done[0]) {
            this.srp.readRegs(addr, count);
            nRead += count;
        }
        return TestSrp.formatRate(startTime, nRead);
    }

    protected static String formatHex(int addr, int[] data) {
        StringBuilder text = new StringBuilder();
        for (int j = 0; j < data.length; ++j) {
            if ((j & 3) == 0) {
                if (j > 0) {
                    text.append('\n');
                }
                text.append(String.format("%06x:", addr + j));
            }
            text.append(String.format(" %08x", data[j]));
        }
        return text.toString();
    }

    protected static String formatRate(long start, int count) {
        long period = System.currentTimeMillis() - start;
        return String.format("Read rate (Hz) = %.4g", (double)count * 1000.0 / (double)(period == 0L ? 1L : period));
    }

    protected class ConsThread
    extends Thread {
        private final BlockingQueue<Integer> consQueue = new ArrayBlockingQueue<Integer>(1);
        private boolean[] consDone;
        private Thread mainThread;

        ConsThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                this.awaitStart();
                this.awaitTerminal();
                this.consDone[0] = true;
                if (this.mainThread == null) continue;
                this.mainThread.interrupt();
            }
        }

        public void start(boolean[] done, boolean wake) {
            if (this.getState() == Thread.State.NEW) {
                this.start();
            }
            this.consDone = done;
            this.consDone[0] = false;
            this.mainThread = wake ? Thread.currentThread() : null;
            this.consQueue.offer(0);
        }

        public void start(boolean[] done) {
            this.start(done, false);
        }

        private void awaitStart() {
            while (true) {
                try {
                    this.consQueue.take();
                    return;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        private void awaitTerminal() {
            block6: while (true) {
                try {
                    while (System.in.available() <= 0) {
                        try {
                            Thread.sleep(50L);
                            continue block6;
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    break;
                }
                catch (IOException e) {
                    // empty catch block
                    break;
                }
            }
            try {
                while (System.in.available() > 0) {
                    System.in.read();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected static enum OnOff {
        ON,
        OFF;

    }
}

