/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.tracer;

import java.awt.Color;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.bus.messages.CommandMessage;
import org.lsst.ccs.bus.messages.LogMessage;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.gconsole.plugins.tracer.FilteredMessage;
import org.lsst.ccs.gconsole.plugins.tracer.Tracer;
import org.lsst.ccs.gconsole.services.persist.Creator;
import org.lsst.ccs.gconsole.services.persist.PersistenceService;

public class FilterStep {
    private static final Pattern pPar = Pattern.compile("\\$\\{([^}]+)\\}");
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
    private static final SimpleDateFormat dtFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final HashMap<String, Function<FilteredMessage, String>> key2func = new HashMap();
    private final Mode mode;
    private final boolean invert;
    private final boolean format;
    private final Target target;
    private final Method method;
    private final String[] code;
    private final Color color;
    private final FilteredMessage.Flag flag;
    private final Predicate<String> tester;
    private final Tracer delegate;
    private final String pattern;
    private final String[] template;

    public FilterStep(Mode mode, boolean invert, boolean format, Target target, Method method, String[] code, Color color, FilteredMessage.Flag flag) {
        this.mode = mode;
        this.invert = invert;
        this.format = format;
        this.target = target;
        this.method = method;
        this.flag = flag;
        this.color = color;
        this.code = code;
        try {
            switch (target) {
                case TEMPLATE: {
                    if (code.length != 2) {
                        throw new IllegalArgumentException("Not a valid template");
                    }
                    String temp = code[0];
                    Matcher m = pPar.matcher(temp);
                    ArrayList<String> t = new ArrayList<String>();
                    int s = 0;
                    while (m.find()) {
                        t.add(temp.substring(s, m.start()));
                        t.add(m.group(1));
                        s = m.end();
                    }
                    if (s < temp.length()) {
                        t.add(temp.substring(s));
                    }
                    this.template = t.toArray(new String[t.size()]);
                    this.pattern = code[1];
                    break;
                }
                default: {
                    this.template = null;
                    this.pattern = code[0];
                    break;
                }
            }
        }
        catch (IndexOutOfBoundsException x) {
            throw new IllegalArgumentException("Unable to create message viewer filter", x);
        }
        try {
            switch (method) {
                case REGEX: {
                    this.tester = Pattern.compile(this.pattern).asPredicate();
                    this.delegate = null;
                    break;
                }
                case WILDCARD: {
                    String s = FilterStep.wildcardToRegex(this.pattern);
                    this.tester = Pattern.compile(s).asPredicate();
                    this.delegate = null;
                    break;
                }
                case CONTAINS: {
                    this.tester = targetString -> targetString.contains(this.pattern);
                    this.delegate = null;
                    break;
                }
                case EQUALS: {
                    this.tester = targetString -> targetString.equals(this.pattern);
                    this.delegate = null;
                    break;
                }
                case NAME: {
                    this.tester = null;
                    String path = code[0];
                    int n = code.length - 1;
                    String[] pars = new String[n];
                    for (int i = 0; i < n; ++i) {
                        pars[i] = code[i + 1];
                    }
                    this.delegate = (Tracer)PersistenceService.getService().make("Tracer", path, pars);
                    if (this.delegate == null) {
                        throw new IllegalArgumentException("Failed to load external filter");
                    }
                    break;
                }
                case CLASS: {
                    if (!this.pattern.matches("[a-zA-Z_$][a-zA-Z\\d_$.]+")) {
                        throw new IllegalArgumentException("Illegal class name");
                    }
                    this.tester = null;
                    this.delegate = null;
                    break;
                }
                default: {
                    this.tester = null;
                    this.delegate = null;
                    break;
                }
            }
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException x) {
            throw new IllegalArgumentException("Unable to create message viewer filter", x);
        }
    }

    public FilterStep(Tracer delegate, Mode mode, boolean invert, boolean format, Color color, FilteredMessage.Flag flag) {
        this.mode = mode;
        this.invert = invert;
        this.format = format;
        this.target = Target.MESSAGE;
        this.method = Method.NAME;
        this.flag = flag;
        this.color = color;
        this.code = FilterStep.getCode(delegate);
        this.delegate = delegate;
        this.tester = null;
        this.pattern = null;
        this.template = null;
    }

    public FilterStep(Descriptor descriptor) {
        this(descriptor.getMode() == null ? Mode.ON : Mode.valueOf(descriptor.getMode()), descriptor.isInvert(), descriptor.isFormat(), descriptor.getTarget() == null ? null : Target.valueOf(descriptor.getTarget()), descriptor.getMethod() == null ? null : Method.valueOf(descriptor.getMethod()), descriptor.getCode(), descriptor.getColor() == null ? null : new Color(Integer.parseUnsignedInt(descriptor.getColor(), 16)), descriptor.getFlag() == null ? null : FilteredMessage.Flag.valueOf(descriptor.getFlag()));
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean isInverted() {
        return this.invert;
    }

    public boolean isFormatting() {
        return this.format;
    }

    public Target getTarget() {
        return this.target;
    }

    public Method getMethod() {
        return this.method;
    }

    public String[] getCode() {
        return this.code;
    }

    public Color getColor() {
        return this.color;
    }

    public FilteredMessage.Flag getFlag() {
        return this.flag;
    }

    public Tracer getDelegate() {
        return this.delegate;
    }

    public FilteredMessage apply(FilteredMessage filteredMessage) {
        if (this.mode == Mode.OFF) {
            return filteredMessage;
        }
        try {
            boolean accept;
            Object targetObject = null;
            if (this.method.needsTarget()) {
                switch (this.target) {
                    case MESSAGE: {
                        targetObject = filteredMessage.getMessage();
                        break;
                    }
                    case OBJECT: {
                        targetObject = filteredMessage.getMessage().getObject();
                        break;
                    }
                    case SOURCE: {
                        targetObject = filteredMessage.getMessage().getOriginAgentInfo().getName();
                        break;
                    }
                    case TEXT: {
                        targetObject = filteredMessage.getText();
                        if (targetObject != null) break;
                        targetObject = filteredMessage.getMessage().toString();
                        break;
                    }
                    case FLAG: {
                        EnumSet<FilteredMessage.Flag> flags = filteredMessage.getFlags();
                        if (flags == null) {
                            targetObject = "";
                            break;
                        }
                        StringBuilder sb = new StringBuilder();
                        flags.forEach(flag -> sb.append(",").append(flag));
                        targetObject = sb.substring(1);
                        break;
                    }
                    case TEMPLATE: {
                        targetObject = this.expand(filteredMessage);
                    }
                }
            }
            block9 : switch (this.method) {
                case REGEX: 
                case WILDCARD: 
                case CONTAINS: 
                case EQUALS: {
                    accept = this.tester.test(targetObject.toString());
                    break;
                }
                case CLASS: {
                    accept = false;
                    for (Class<?> c = targetObject.getClass(); c != null; c = c.getSuperclass()) {
                        if (!this.pattern.equals(c.getName()) && !this.pattern.equals(c.getSimpleName())) continue;
                        accept = true;
                        break block9;
                    }
                    break;
                }
                case NAME: {
                    FilteredMessage fm = new FilteredMessage(filteredMessage);
                    if (targetObject instanceof String) {
                        fm.setText((String)targetObject);
                    }
                    if ((fm = this.delegate.getFilter().apply(fm)) == null) {
                        accept = false;
                        break;
                    }
                    accept = true;
                    targetObject = fm;
                    break;
                }
                default: {
                    accept = true;
                }
            }
            if (this.invert) {
                boolean bl = accept = !accept;
            }
            if (accept) {
                if (this.format) {
                    if (targetObject instanceof FilteredMessage) {
                        filteredMessage = (FilteredMessage)targetObject;
                    } else if (targetObject != null) {
                        filteredMessage.setText(targetObject.toString());
                    }
                }
                if (this.color != null) {
                    filteredMessage.setColor(this.color);
                }
                if (this.flag != null) {
                    filteredMessage.addFlag(this.flag);
                }
                return filteredMessage;
            }
            return this.mode == Mode.ON ? null : filteredMessage;
        }
        catch (Throwable t) {
            return this.mode == Mode.TRY ? filteredMessage : null;
        }
    }

    private String expand(FilteredMessage message) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.template.length) {
            sb.append(this.template[i++]);
            if (i >= this.template.length) continue;
            sb.append(this.expand(this.template[i++], message));
        }
        return sb.toString();
    }

    private String expand(String key, FilteredMessage message) {
        Function<FilteredMessage, String> func = key2func.get(key);
        if (func != null) {
            return func.apply(message);
        }
        String out = message.getMessage().getOriginAgentInfo().getAgentProperty(key);
        if (out != null) {
            return out;
        }
        throw new RuntimeException();
    }

    private static String wildcardToRegex(String wildcard) {
        StringBuilder s = new StringBuilder();
        int is = wildcard.length();
        block5: for (int i = 0; i < is; ++i) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    s.append(".*");
                    continue block5;
                }
                case '?': {
                    s.append(".");
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    s.append("\\");
                    s.append(c);
                    continue block5;
                }
                default: {
                    s.append(c);
                }
            }
        }
        return s.toString();
    }

    public static String[] getCode(Tracer tracer) {
        String path = tracer.getDescriptor().getPath();
        if (path == null) {
            Creator.Descriptor cd = tracer.getDescriptor().getCreator();
            path = cd.getPath();
            String[] pars = cd.getParameters();
            if (pars == null) {
                return new String[]{path};
            }
            int n = pars.length;
            String[] out = new String[n + 1];
            out[0] = path;
            System.arraycopy(pars, 0, out, 1, n);
            return out;
        }
        return new String[]{path};
    }

    public Descriptor save() {
        Descriptor desc = new Descriptor();
        if (this.mode != null && this.mode != Mode.ON) {
            desc.setMode(this.mode.name());
        }
        desc.setInvert(this.invert);
        desc.setFormat(this.format);
        if (this.target != null) {
            desc.setTarget(this.target.name());
        }
        if (this.method != null) {
            desc.setMethod(this.method.name());
        }
        desc.setCode(this.code);
        if (this.color != null) {
            desc.setColor(Integer.toHexString(this.color.getRGB()));
        }
        if (this.flag != null) {
            desc.setFlag(this.flag.name());
        }
        return desc;
    }

    static {
        key2func.put("SOURCE", m -> m.getMessage().getOriginAgentInfo().getName());
        key2func.put("SOURCE_TYPE", m -> m.getMessage().getOriginAgentInfo().getType().name());
        key2func.put("TEXT", m -> m.getText());
        key2func.put("DATE", m -> dateFormat.format(new Date(m.getMessage().getCCSTimeStamp().getUTCInstant().toEpochMilli())));
        key2func.put("TIME", m -> timeFormat.format(new Date(m.getMessage().getCCSTimeStamp().getUTCInstant().toEpochMilli())));
        key2func.put("DT", m -> dtFormat.format(new Date(m.getMessage().getCCSTimeStamp().getUTCInstant().toEpochMilli())));
        key2func.put("LOGGER", m -> ((LogMessage)m.getMessage()).getLoggerName());
        key2func.put("LEVEL", m -> ((LogMessage)m.getMessage()).getLevel());
        key2func.put("MESSAGE", m -> ((LogMessage)m.getMessage()).getFormattedDetails());
        key2func.put("STATE", m -> ((StatusMessage)m.getMessage()).getState().toString());
        key2func.put("DESTINATION", m -> ((CommandMessage)m.getMessage()).getDestination());
    }

    public static enum Mode {
        ON("Accept and modify messages that satisfy this step", "On"),
        TRY("Accept a message if this step is either satisfied or inapplicable, modify only if this step is satisfied", "Try"),
        PASS("Accept all messages, modify only those that satisfy this step", "Pass"),
        OFF("Skip this step", "Off");

        private final String toolTip;
        private final String hr;

        private Mode(String toolTip, String humanReadable) {
            this.toolTip = toolTip;
            this.hr = humanReadable;
        }

        public String getToolTip() {
            return this.toolTip;
        }

        public String toString() {
            return this.hr;
        }
    }

    public static enum Target {
        MESSAGE("The operation is applied to the bus message object. If the operation <br> requires a string as a target, the message is converted to a string.", "Message"),
        OBJECT("The operation is applied to the deserialized object embedded<br> into the bus message. If the operation requires<br> a string as a target, the object is converted to a string.", "Object"),
        SOURCE("The operation is applied to the name of the source subsystem.", "Source"),
        TEXT("The operation is applied to the string produced by formatters embedded in<br> previously applied steps. If none of the previous steps formatted the<br> message, the BusMessage is converted to String by calling its toString() method.", "Text"),
        FLAG("The filter is applied to the comma-separated list of flags attached<br> to the message.", "Flag"),
        TEMPLATE("The operation is applied to the string produced<br> by expanding the template based on contents of the message.<br> If expanding fails, the filter is not satisfied. The template<br> may include place holders in the <tt>${key}</tt> format,<br> where <tt>key</tt> is a name of a subsystem property, or one<br> of the following:<br> <b>SOURCE:</b> Name of the source subsystem<br> <b>SOURCE_TYPE:</b> Type of the source subsystem<br> <b>TEXT</b> String formatted by previous steps<br> <b>DATE</b> Message date in 'yyyy-MM-dd' format<br> <b>TIME</b> Message time in 'HH:mm:ss' format<br> <b>DT</b> Message date and time in 'yyyy-MM-dd HH:mm:ss' format<br> <b>LOGGER</b> Name of the logger<br> <b>LEVEL</b> Level of the log message<br> <b>MESSAGE</b> Formatted message associated with the bus message<br> <b>STATE</b> Subsystem state embedded in the status message<br> <b>DESTINATION</b> Destination of the command message<br>", "Template");

        private final String toolTip;
        private final String hr;

        private Target(String toolTip, String humanReadable) {
            this.toolTip = toolTip;
            this.hr = humanReadable;
        }

        public String getToolTip() {
            return this.toolTip;
        }

        public String toString() {
            return this.hr;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Method {
        REGEX("The parameter string is a regular expression the target should match.", "Reg Ex"),
        WILDCARD("The parameter string is a Unix-style wildcard the target should match.", "Wildcard"),
        CONTAINS("The target should contain the parameter string.", "Contains"),
        EQUALS("The target should be equal to the parameter string.", "Equals"),
        CLASS("The target should be an instance of the class specified by the parameter<br> string, or of its subclass. Full and short class names can be used.", "Class"),
        NAME("Load a built-in or previously saved filter.", "External"){

            @Override
            public boolean needsTarget() {
                return false;
            }
        };

        private final String toolTip;
        private final String hr;

        private Method(String toolTip, String humanReadable) {
            this.toolTip = toolTip;
            this.hr = humanReadable;
        }

        public String getToolTip() {
            return this.toolTip;
        }

        public boolean needsTarget() {
            return true;
        }

        public String toString() {
            return this.hr;
        }
    }

    public static class Descriptor
    implements Serializable,
    Cloneable {
        private String mode;
        private boolean invert;
        private boolean format;
        private String target;
        private String method;
        private String[] code;
        private String color;
        private String flag;

        public String getFlag() {
            return this.flag;
        }

        public void setFlag(String flag) {
            this.flag = flag;
        }

        public String getMode() {
            return this.mode;
        }

        public void setMode(String mode) {
            this.mode = mode;
        }

        public boolean isInvert() {
            return this.invert;
        }

        public void setInvert(boolean invert) {
            this.invert = invert;
        }

        public boolean isFormat() {
            return this.format;
        }

        public void setFormat(boolean format) {
            this.format = format;
        }

        public String getTarget() {
            return this.target;
        }

        public void setTarget(String target) {
            this.target = target;
        }

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public String getColor() {
            return this.color;
        }

        public void setColor(String color) {
            this.color = color;
        }

        public String[] getCode() {
            return this.code;
        }

        public void setCode(String[] code) {
            this.code = code;
        }

        protected Descriptor clone() {
            try {
                return (Descriptor)super.clone();
            }
            catch (CloneNotSupportedException x) {
                return null;
            }
        }
    }
}

