/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JScrollPane;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.base.panel.PanelEvent;
import org.lsst.ccs.gconsole.base.panel.PanelManager;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.subsystem.shutter.gui.Commander;
import org.lsst.ccs.subsystem.shutter.gui.ControlPanel;
import org.lsst.ccs.subsystem.shutter.gui.Dispatcher;
import org.lsst.ccs.subsystem.shutter.gui.DisplayPanel;
import org.lsst.ccs.subsystem.shutter.gui.RootPanel;
import org.lsst.ccs.subsystem.shutter.gui.StatusListener;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.scheduler.Scheduler;

@Plugin(name="LSST Shutter plugin", description="Camera shutter status and controls.")
public class ShutterPlugin
extends ConsolePlugin
implements AgentPresenceListener {
    private static final Logger LOG = Logger.getLogger((String)ShutterPlugin.class.getPackage().getName());
    private static final String CCS_SUBSYSTEM_MENU_NAME = "CCS Subsystems";
    private static final String CCS_SHUTTER_MENU_ITEM_NAME = "Camera shutter";
    private final DisplayPanel dispPanel = new DisplayPanel();
    private final ControlPanel ctrlPanel = new ControlPanel(this);
    private final RootPanel rootPanel = RootPanel.create(this.dispPanel, this.ctrlPanel);
    private final JScrollPane scrollPane = new JScrollPane(this.rootPanel);
    private final MenuItemAction menuItem = new MenuItemAction();
    private final Commander commander = new Commander(this);
    private final StatusListener statusListener = new StatusListener(this);
    private final Scheduler scheduler = new Scheduler("Shutter plugin dispatcher", 1);
    private final Dispatcher dispat = new Dispatcher(this, this.dispPanel, this.ctrlPanel, this.commander, this.statusListener);

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public Dispatcher getDispatcher() {
        return this.dispat;
    }

    public String getMenuName() {
        return CCS_SUBSYSTEM_MENU_NAME;
    }

    public String getMenuItemName() {
        return CCS_SHUTTER_MENU_ITEM_NAME;
    }

    public String getWorkerName() {
        return "cam-shutter";
    }

    public void initialize() {
        LOG.fine((Object)"Initializing plugin.");
        this.getServices().addMenu((Action)this.menuItem, new String[]{this.getMenuName()});
    }

    public void start() {
        LOG.fine((Object)"Starting plugin.");
        this.getDispatcher().start();
        this.getDispatcher().showWorkerIsUnreachable("");
    }

    public void stop() {
        LOG.fine((Object)"Stopping plugin.");
        if (this.menuItem.isSelected()) {
            this.menuItem.deselect();
            this.menuItem.actionPerformed(null);
        }
    }

    public void shutdown() {
        LOG.fine((Object)"Shutting down plugin.");
        this.scheduler.shutdownNow();
    }

    private void handlePanelEvent(PanelEvent e) {
        if (e.hasKey((Object)Panel.OPEN) && !((Boolean)e.getNewValue()).booleanValue()) {
            LOG.fine((Object)"Panel Manager close event.");
            if (this.menuItem.isSelected()) {
                this.menuItem.deselect();
                this.menuItem.actionPerformed(null);
            }
        }
    }

    private class MenuItemAction
    extends AbstractAction {
        public MenuItemAction() {
            super(ShutterPlugin.this.getMenuItemName());
            this.putValue("SwingSelectedKey", false);
        }

        public boolean isSelected() {
            return (Boolean)this.getValue("SwingSelectedKey");
        }

        public void deselect() {
            this.putValue("SwingSelectedKey", false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e == null) {
                LOG.fine((Object)"Fake menu item action: deselect");
            } else {
                LOG.fine((Object)("Menu item action: " + (this.isSelected() ? "select" : "deselect")));
            }
            if (this.isSelected()) {
                this.activate();
            } else {
                this.deactivate();
            }
        }

        private void activate() {
            LOG.fine((Object)"Activating.");
            PanelManager pm = ShutterPlugin.this.getConsole().getPanelManager();
            pm.open((Component)ShutterPlugin.this.scrollPane, "Camera Shutter Control Panel");
            pm.addListener(e -> ShutterPlugin.this.handlePanelEvent(e), (Component)ShutterPlugin.this.scrollPane);
            ShutterPlugin.this.getDispatcher().connect();
        }

        private void deactivate() {
            LOG.fine((Object)"Deactivating.");
            PanelManager pm = ShutterPlugin.this.getConsole().getPanelManager();
            pm.close((Component)ShutterPlugin.this.scrollPane);
            ShutterPlugin.this.getDispatcher().disconnect();
        }
    }
}

