/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.xmlrpc;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.astrogrid.samp.SampUtils;
import org.astrogrid.samp.client.ClientProfile;
import org.astrogrid.samp.httpd.ServerResource;
import org.astrogrid.samp.httpd.UtilServer;
import org.astrogrid.samp.hub.HubProfile;
import org.astrogrid.samp.hub.KeyGenerator;
import org.astrogrid.samp.hub.LockWriter;
import org.astrogrid.samp.hub.MessageRestriction;
import org.astrogrid.samp.xmlrpc.HubXmlRpcHandler;
import org.astrogrid.samp.xmlrpc.LockInfo;
import org.astrogrid.samp.xmlrpc.SampXmlRpcClientFactory;
import org.astrogrid.samp.xmlrpc.SampXmlRpcServer;
import org.astrogrid.samp.xmlrpc.SampXmlRpcServerFactory;
import org.astrogrid.samp.xmlrpc.StandardClientProfile;
import org.astrogrid.samp.xmlrpc.XmlRpcKit;

public class StandardHubProfile
implements HubProfile {
    private final SampXmlRpcClientFactory xClientFactory_;
    private final SampXmlRpcServerFactory xServerFactory_;
    private final File lockfile_;
    private final String secret_;
    private URL lockUrl_;
    private SampXmlRpcServer server_;
    private volatile HubXmlRpcHandler hubHandler_;
    private LockInfo lockInfo_;
    private static final Logger logger_;
    private static final Random random_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public StandardHubProfile(SampXmlRpcClientFactory xClientFactory, SampXmlRpcServerFactory xServerFactory, File lockfile, String secret) {
        this.xClientFactory_ = xClientFactory;
        this.xServerFactory_ = xServerFactory;
        this.lockfile_ = lockfile;
        this.secret_ = secret;
    }

    public StandardHubProfile() throws IOException {
        this(XmlRpcKit.getInstance().getClientFactory(), XmlRpcKit.getInstance().getServerFactory(), SampUtils.urlToFile(StandardClientProfile.getLockUrl()), StandardHubProfile.createSecret());
    }

    public String getProfileName() {
        return "Standard";
    }

    public MessageRestriction getMessageRestriction() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(ClientProfile profile) throws IOException {
        if (this.isRunning()) {
            logger_.info("Profile already started");
            return;
        }
        if (this.lockfile_ != null && this.lockfile_.exists() && StandardHubProfile.isHubAlive(this.xClientFactory_, this.lockfile_)) {
            throw new IOException("A hub is already running");
        }
        try {
            this.server_ = this.xServerFactory_.getServer();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw (IOException)new IOException("Can't start XML-RPC server").initCause(e);
        }
        this.hubHandler_ = new HubXmlRpcHandler(this.xClientFactory_, profile, this.secret_, new KeyGenerator("k:", 16, random_));
        this.server_.addHandler(this.hubHandler_);
        this.lockInfo_ = new LockInfo(this.secret_, this.server_.getEndpoint().toString());
        this.lockInfo_.put("hub.impl", profile.getClass().getName());
        this.lockInfo_.put("profile.impl", this.getClass().getName());
        this.lockInfo_.put("profile.start.date", new Date().toString());
        if (this.lockfile_ != null) {
            if (!this.lockfile_.createNewFile()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (StandardHubProfile.isHubAlive(this.xClientFactory_, this.lockfile_)) {
                    this.server_.removeHandler(this.hubHandler_);
                    this.hubHandler_ = null;
                    throw new IOException("A hub is already running");
                }
                logger_.warning("Overwriting " + this.lockfile_ + " lockfile " + "for apparently dead hub");
            }
            FileOutputStream out = new FileOutputStream(this.lockfile_);
            try {
                StandardHubProfile.writeLockInfo(this.lockInfo_, out);
                logger_.info("Wrote new lockfile " + this.lockfile_);
                try {
                    LockWriter.setLockPermissions(this.lockfile_);
                    logger_.info("Lockfile permissions set to user access only");
                }
                catch (IOException e) {
                    logger_.log(Level.WARNING, "Failed attempt to change " + this.lockfile_ + " permissions to user access only" + " - possible security implications", e);
                }
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger_.log(Level.WARNING, "Error closing lockfile?", e);
                }
            }
        }
        URL lockfileUrl = this.lockfile_ == null ? this.publishLockfile() : SampUtils.fileToUrl(this.lockfile_);
        boolean isDflt = StandardClientProfile.getDefaultLockUrl().toString().equals(lockfileUrl.toString());
        String hubassign = "SAMP_HUB=std-lockurl:" + lockfileUrl;
        logger_.log(isDflt ? Level.INFO : Level.WARNING, hubassign);
    }

    public synchronized boolean isRunning() {
        return this.hubHandler_ != null;
    }

    public synchronized void stop() {
        block12: {
            if (!this.isRunning()) {
                logger_.info("Profile already stopped");
                return;
            }
            if (this.lockInfo_ != null && this.lockfile_ != null) {
                if (this.lockfile_.exists()) {
                    try {
                        LockInfo lockInfo = StandardHubProfile.readLockFile(this.lockfile_);
                        if (this.lockInfo_.getSecret().equals(lockInfo.getSecret())) {
                            if (!$assertionsDisabled && !lockInfo.equals(this.lockInfo_)) {
                                throw new AssertionError();
                            }
                            boolean deleted = this.lockfile_.delete();
                            logger_.info("Lockfile " + this.lockfile_ + " " + (deleted ? "deleted" : "deletion attempt failed"));
                            break block12;
                        }
                        logger_.warning("Lockfile " + this.lockfile_ + " has been " + " overwritten - not deleting");
                    }
                    catch (Throwable e) {
                        logger_.log(Level.WARNING, "Failed to delete lockfile " + this.lockfile_, e);
                    }
                } else {
                    logger_.warning("Lockfile " + this.lockfile_ + " has disappeared");
                }
            }
        }
        if (this.lockUrl_ != null) {
            try {
                UtilServer.getInstance().getResourceHandler().removeResource(this.lockUrl_);
            }
            catch (IOException e) {
                logger_.warning("Failed to withdraw lockfile URL");
            }
            this.lockUrl_ = null;
        }
        if (this.hubHandler_ != null && this.server_ != null) {
            this.server_.removeHandler(this.hubHandler_);
        }
        this.server_ = null;
        this.hubHandler_ = null;
        this.lockInfo_ = null;
    }

    public LockInfo getLockInfo() {
        return this.lockInfo_;
    }

    public URL publishLockfile() throws IOException {
        if (this.lockUrl_ == null) {
            ByteArrayOutputStream infoStrm = new ByteArrayOutputStream();
            StandardHubProfile.writeLockInfo(this.lockInfo_, infoStrm);
            infoStrm.close();
            final byte[] infoBuf = infoStrm.toByteArray();
            URL url = UtilServer.getInstance().getResourceHandler().addResource("samplock", new ServerResource(){

                public long getContentLength() {
                    return infoBuf.length;
                }

                public String getContentType() {
                    return "text/plain";
                }

                public void writeBody(OutputStream out) throws IOException {
                    out.write(infoBuf);
                }
            });
            try {
                url = new URL(url.getProtocol(), InetAddress.getLocalHost().getCanonicalHostName(), url.getPort(), url.getFile());
            }
            catch (IOException e) {
                // empty catch block
            }
            this.lockUrl_ = url;
        }
        return this.lockUrl_;
    }

    public static synchronized String createSecret() {
        return Long.toHexString(random_.nextLong());
    }

    private static boolean isHubAlive(SampXmlRpcClientFactory xClientFactory, File lockfile) {
        LockInfo info;
        try {
            info = StandardHubProfile.readLockFile(lockfile);
        }
        catch (Exception e) {
            logger_.log(Level.WARNING, "Failed to read lockfile", e);
            return false;
        }
        if (info == null) {
            return false;
        }
        URL xurl = info.getXmlrpcUrl();
        if (xurl != null) {
            try {
                xClientFactory.createClient(xurl).callAndWait("samp.hub.ping", new ArrayList());
                return true;
            }
            catch (Exception e) {
                logger_.log(Level.WARNING, "Hub ping method failed", e);
                return false;
            }
        }
        logger_.warning("No XMLRPC URL in lockfile");
        return false;
    }

    private static LockInfo readLockFile(File lockFile) throws IOException {
        return LockInfo.readLockFile(new FileInputStream(lockFile));
    }

    private static void writeLockInfo(LockInfo info, OutputStream out) throws IOException {
        LockWriter writer = new LockWriter(out);
        writer.writeComment("SAMP Standard Profile lockfile written " + new Date());
        writer.writeComment("Note contact URL hostname may be configured using jsamp.localhost property");
        writer.writeAssignments(info);
        out.flush();
    }

    static {
        $assertionsDisabled = !StandardHubProfile.class.desiredAssertionStatus();
        logger_ = Logger.getLogger(StandardHubProfile.class.getName());
        random_ = KeyGenerator.createRandom();
    }
}

