/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselClamp;
import org.lsst.ccs.subsystems.fcs.carousel.ui.AnalogicSensorPanel;
import org.lsst.ccs.subsystems.fcs.carousel.ui.FilterPresenceSensorPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class CarouselClampPanel
extends JPanel {
    private static final long serialVersionUID = -1273081770223753869L;
    private String clampName;
    private String lockSensorName;
    private String filterPresenceSensorName;
    private JLabel clampStateLabel;
    private final JLabel explainText = new JLabel("<HTML><P>UNLOCKED: <P>between minValue and valueA <P>LOCKED: <P>between valueB and maxValue</HTML>");
    private AnalogicSensorPanel lockSensorPanel;
    private FilterPresenceSensorPanel filterPresenceSensorPanel;
    private JPanel paramsPanel;
    private final JLabel currentToUnlockLabel = new JLabel("0");
    private final JLabel currentToMaintainUnlockLabel = new JLabel("0");
    private JPanel controllerPanel;
    private final DigitalSwitch controllerSwitch = new DigitalSwitch();
    private final JLabel enableStatusLabel = new JLabel();
    private final JLabel actualCurrentLabel = new JLabel();

    public CarouselClampPanel(String clampName) {
        this.clampName = clampName;
        String[] words = clampName.split("X");
        this.lockSensorName = "lockSensorX" + words[1];
        this.filterPresenceSensorName = "filterPresenceX" + words[1];
        this.initComponents();
    }

    public void initializeGui(ConfigurationInfo configInfo) {
        Map config = configInfo.getCurrentValuesFor(this.clampName);
        this.currentToUnlockLabel.setText((String)config.get("currentToUnlock"));
        this.currentToMaintainUnlockLabel.setText((String)config.get("currentToMaintainUnlocked"));
        this.lockSensorPanel.initializeGui(configInfo);
        this.filterPresenceSensorPanel.initializeGui(configInfo);
    }

    protected void updateClamp(StatusDataPublishedByCarouselClamp s) {
        SwingUtilities.invokeLater(new UpdateClamp(s));
    }

    private void initComponents() {
        this.clampStateLabel = new JLabel("UNKNOWN STATE");
        this.clampStateLabel.setFont(Tools.BIG_FONT);
        this.lockSensorPanel = new AnalogicSensorPanel(this.clampName, this.lockSensorName, 0);
        this.filterPresenceSensorPanel = new FilterPresenceSensorPanel(this.clampName, this.filterPresenceSensorName, 1);
        this.controllerPanel = new JPanel();
        this.controllerPanel.setBorder(BorderFactory.createLineBorder(Color.MAGENTA, 6));
        this.controllerPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.anchor = 21;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.controllerPanel.add((Component)new JLabel("Controller status :"), gbc);
        ++gbc.gridy;
        gbc.anchor = 10;
        this.controllerSwitch.setSize(40);
        this.controllerPanel.add((Component)this.controllerSwitch, gbc);
        ++gbc.gridx;
        this.controllerPanel.add((Component)this.enableStatusLabel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.anchor = 21;
        this.controllerPanel.add((Component)new JLabel("Actual current :"), gbc);
        ++gbc.gridx;
        gbc.anchor = 22;
        this.controllerPanel.add((Component)this.actualCurrentLabel, gbc);
        this.paramsPanel = new JPanel();
        this.paramsPanel.setBorder(BorderFactory.createLineBorder(Color.blue));
        this.paramsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.insets = Tools.insets_std;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.anchor = 21;
        this.paramsPanel.add((Component)new JLabel("Current to lock:"), gbcp);
        ++gbcp.gridy;
        this.paramsPanel.add((Component)new JLabel("<HTML>Current to <P>maintain unlock:</HTML>"), gbcp);
        ++gbcp.gridx;
        gbcp.anchor = 22;
        gbcp.gridx = 1;
        gbcp.gridy = 0;
        this.paramsPanel.add((Component)this.currentToUnlockLabel, gbcp);
        ++gbcp.gridy;
        this.paramsPanel.add((Component)this.currentToMaintainUnlockLabel, gbcp);
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Tools.nicePink), this.clampName));
        this.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.clampStateLabel, gbc);
        ++gbc.gridx;
        this.add((Component)this.controllerPanel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.explainText, gbc);
        ++gbc.gridx;
        this.add((Component)this.paramsPanel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.lockSensorPanel, gbc);
        ++gbc.gridx;
        this.add((Component)this.filterPresenceSensorPanel, gbc);
        this.setDefaultValues();
    }

    public void setDefaultValues() {
        this.currentToUnlockLabel.setText("0.0");
        this.currentToMaintainUnlockLabel.setText("0.0");
        this.clampStateLabel.setText("UNKNOWN STATE");
        this.controllerSwitch.setColor(Color.gray);
        this.enableStatusLabel.setText("UNKNOWN");
        this.actualCurrentLabel.setText("0.0");
    }

    public void resetPanel() {
        this.setDefaultValues();
        this.lockSensorPanel.resetPanel();
        this.filterPresenceSensorPanel.resetPanel();
    }

    public static void main(String[] argv) {
        CarouselClampPanel d = new CarouselClampPanel("clampXminus");
        JFrame frame = new JFrame("Test");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    public class UpdateClamp
    implements Runnable {
        private StatusDataPublishedByCarouselClamp s;

        public UpdateClamp(StatusDataPublishedByCarouselClamp s) {
            this.s = s;
        }

        @Override
        public void run() {
            CarouselClampPanel.this.clampStateLabel.setText(this.s.getClampState().toString());
            CarouselClampPanel.this.clampStateLabel.setForeground(this.s.getClampState().getColor());
            CarouselClampPanel.this.lockSensorPanel.update(this.s.getLockSensorValue(), this.s.getLockStatus());
            CarouselClampPanel.this.filterPresenceSensorPanel.update(this.s.getFilterPositionSensorValue(), this.s.getFilterPresenceStatus());
            CarouselClampPanel.this.filterPresenceSensorPanel.updateOffset1(this.s.getFilterPresenceOffset1());
            CarouselClampPanel.this.filterPresenceSensorPanel.updateOffset2(this.s.getFilterPresenceOffset2());
            CarouselClampPanel.this.controllerSwitch.setColor(this.s.isControllerInFault() ? Color.RED : Tools.greenColor);
            CarouselClampPanel.this.actualCurrentLabel.setText(Integer.toString(this.s.getActualCurrent()));
            CarouselClampPanel.this.enableStatusLabel.setText(this.s.isControllerEnabled() ? "enable" : "disable");
        }
    }
}

