/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.lang;

import com.mchange.v1.lang.AmbiguousClassNameException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class ClassUtils {
    static final String[] EMPTY_SA = new String[0];
    static Map primitivesToClasses;

    public static Set publicSupertypesForMethods(Class cl, Method[] methods) {
        Set testClasses = ClassUtils.allAssignableFrom(cl);
        HashSet<Class> out = new HashSet<Class>();
        for (Class check : testClasses) {
            if (!ClassUtils.isPublic(check) || !ClassUtils.hasAllMethodsAsSupertype(check, methods)) continue;
            out.add(check);
        }
        return Collections.unmodifiableSet(out);
    }

    public static boolean isPublic(Class cl) {
        return (cl.getModifiers() & 1) != 0;
    }

    public static boolean hasAllMethodsAsSupertype(Class cl, Method[] methods) {
        return ClassUtils.hasAllMethods(cl, methods, true);
    }

    public static boolean hasAllMethodsAsSubtype(Class cl, Method[] methods) {
        return ClassUtils.hasAllMethods(cl, methods, false);
    }

    private static boolean hasAllMethods(Class cl, Method[] methods, boolean cl_as_supertype) {
        int len = methods.length;
        for (int i = 0; i < len; ++i) {
            if (ClassUtils.containsMethod(cl, methods[i], cl_as_supertype)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsMethodAsSupertype(Class cl, Method m) {
        return ClassUtils.containsMethod(cl, m, true);
    }

    public static boolean containsMethodAsSubtype(Class cl, Method m) {
        return ClassUtils.containsMethod(cl, m, false);
    }

    private static boolean containsMethod(Class cl, Method m, boolean cl_as_supertype) {
        try {
            Method check = cl.getMethod(m.getName(), m.getParameterTypes());
            Class<?> mRetType = m.getReturnType();
            Class<?> clRetType = check.getReturnType();
            return mRetType.equals(clRetType) || cl_as_supertype && clRetType.isAssignableFrom(mRetType) || !cl_as_supertype && mRetType.isAssignableFrom(clRetType);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static Set allAssignableFrom(Class type) {
        HashSet out = new HashSet();
        for (Class cl = type; cl != null; cl = cl.getSuperclass()) {
            out.add(cl);
        }
        ClassUtils.addSuperInterfacesToSet(type, out);
        return out;
    }

    public static String simpleClassName(Class cl) {
        int array_level = 0;
        while (cl.isArray()) {
            ++array_level;
            cl = cl.getComponentType();
        }
        String scn = ClassUtils.simpleClassName(cl.getName());
        if (array_level > 0) {
            StringBuffer sb = new StringBuffer(16);
            sb.append(scn);
            for (int i = 0; i < array_level; ++i) {
                sb.append("[]");
            }
            return sb.toString();
        }
        return scn;
    }

    private static String simpleClassName(String fqcn) {
        int pkgdot = fqcn.lastIndexOf(46);
        if (pkgdot < 0) {
            return fqcn;
        }
        String scn = fqcn.substring(pkgdot + 1);
        if (scn.indexOf(36) >= 0) {
            StringBuffer sb = new StringBuffer(scn);
            int len = sb.length();
            for (int i = 0; i < len; ++i) {
                if (sb.charAt(i) != '$') continue;
                sb.setCharAt(i, '.');
            }
            return sb.toString();
        }
        return scn;
    }

    public static boolean isPrimitive(String typeStr) {
        return primitivesToClasses.get(typeStr) != null;
    }

    public static Class classForPrimitive(String typeStr) {
        return (Class)primitivesToClasses.get(typeStr);
    }

    public static Class forName(String fqcnOrPrimitive) throws ClassNotFoundException {
        Class<?> out = ClassUtils.classForPrimitive(fqcnOrPrimitive);
        if (out == null) {
            out = Class.forName(fqcnOrPrimitive);
        }
        return out;
    }

    public static Class forName(String fqOrSimple, String[] importPkgs, String[] importClasses) throws AmbiguousClassNameException, ClassNotFoundException {
        try {
            return Class.forName(fqOrSimple);
        }
        catch (ClassNotFoundException e) {
            return ClassUtils.classForSimpleName(fqOrSimple, importPkgs, importClasses);
        }
    }

    public static Class classForSimpleName(String simpleName, String[] importPkgs, String[] importClasses) throws AmbiguousClassNameException, ClassNotFoundException {
        HashSet<String> checkSet = new HashSet<String>();
        Class<?> out = ClassUtils.classForPrimitive(simpleName);
        if (out == null) {
            if (importPkgs == null) {
                importPkgs = EMPTY_SA;
            }
            if (importClasses == null) {
                importClasses = EMPTY_SA;
            }
            int len = importClasses.length;
            for (int i = 0; i < len; ++i) {
                String importSimpleName = ClassUtils.fqcnLastElement(importClasses[i]);
                if (!checkSet.add(importSimpleName)) {
                    throw new IllegalArgumentException("Duplicate imported classes: " + importSimpleName);
                }
                if (!simpleName.equals(importSimpleName)) continue;
                out = Class.forName(importClasses[i]);
            }
            if (out == null) {
                try {
                    out = Class.forName("java.lang." + simpleName);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
                len = importPkgs.length;
                for (int i = 0; i < len; ++i) {
                    try {
                        String tryClass = importPkgs[i] + '.' + simpleName;
                        Class<?> test = Class.forName(tryClass);
                        if (out != null) {
                            throw new AmbiguousClassNameException(simpleName, out, test);
                        }
                        out = test;
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                }
            }
        }
        if (out == null) {
            throw new ClassNotFoundException("Could not find a class whose unqualified name is \"" + simpleName + "\" with the imports supplied. Import packages are " + Arrays.asList(importPkgs) + "; class imports are " + Arrays.asList(importClasses));
        }
        return out;
    }

    public static String resolvableTypeName(Class type, String[] importPkgs, String[] importClasses) throws ClassNotFoundException {
        String simpleName = ClassUtils.simpleClassName(type);
        try {
            ClassUtils.classForSimpleName(simpleName, importPkgs, importClasses);
        }
        catch (AmbiguousClassNameException e) {
            return type.getName();
        }
        return simpleName;
    }

    public static String fqcnLastElement(String fqcn) {
        int pkgdot = fqcn.lastIndexOf(46);
        if (pkgdot < 0) {
            return fqcn;
        }
        return fqcn.substring(pkgdot + 1);
    }

    private static void addSuperInterfacesToSet(Class type, Set set) {
        Class<?>[] ifaces = type.getInterfaces();
        int len = ifaces.length;
        for (int i = 0; i < len; ++i) {
            set.add(ifaces[i]);
            ClassUtils.addSuperInterfacesToSet(ifaces[i], set);
        }
    }

    private ClassUtils() {
    }

    static {
        HashMap<String, Class<Object>> tmp = new HashMap<String, Class<Object>>();
        tmp.put("boolean", Boolean.TYPE);
        tmp.put("int", Integer.TYPE);
        tmp.put("char", Character.TYPE);
        tmp.put("short", Short.TYPE);
        tmp.put("int", Integer.TYPE);
        tmp.put("long", Long.TYPE);
        tmp.put("float", Float.TYPE);
        tmp.put("double", Double.TYPE);
        tmp.put("void", Void.TYPE);
        primitivesToClasses = Collections.unmodifiableMap(tmp);
    }
}

