/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.lsst.ccs.subsystem.common.ui.TextFieldX;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;

public class SystemStatusPanel
extends JPanel
implements UiUtilities.ActionHandler {
    private static final int statusWidth = UiUtilities.maxLabelWidth(new String[]{"STOPPED", "RUNNING"}, "");
    private final CommandSender sender;
    private final UiUtilities uiUtils;
    private JLabel stateStatus;
    private TextFieldX periodTextField;
    private static final long serialVersionUID = 1L;

    public SystemStatusPanel(CommandSender cons) {
        this.sender = cons;
        this.uiUtils = new UiUtilities(this);
        this.initComponents();
        this.disablePanel();
    }

    public void updatePanel(int tickMillis) {
        this.stateStatus.setText("RUNNING");
        this.stateStatus.setForeground(UiConstants.GREEN);
        this.periodTextField.update((double)tickMillis / 1000.0, true);
    }

    public void disablePanel() {
        this.stateStatus.setText("STOPPED");
        this.stateStatus.setForeground(UiConstants.RED);
        this.periodTextField.setDisabled();
    }

    private void initComponents() {
        this.stateStatus = UiUtilities.newLabel("XXX", statusWidth);
        this.periodTextField = this.uiUtils.newTextFieldX("99999.9", "", 2, true);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbh = new GridBagConstraints();
        gbh.insets = new Insets(5, 5, 5, 0);
        gbh.gridx = 0;
        gbh.gridy = 0;
        gbh.anchor = 17;
        this.add((Component)UiUtilities.newLabel("System State: ", 0), gbh);
        ++gbh.gridx;
        this.add((Component)this.stateStatus, gbh);
        ++gbh.gridx;
        gbh.insets.left = 72;
        this.add((Component)UiUtilities.newLabel("Update Period: ", 0), gbh);
        ++gbh.gridx;
        gbh.insets.left = 5;
        gbh.insets.top -= 2;
        this.add((Component)this.periodTextField, gbh);
        ++gbh.gridx;
        gbh.insets.top += 2;
        this.add((Component)UiUtilities.newLabel("sec", 0), gbh);
    }

    @Override
    public void handleTextFieldX(String name, Object value) {
        this.sender.sendCommand(null, "setUpdatePeriod", (int)(1000.0 * (Double)value));
    }
}

