/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ccob;

import java.io.Serializable;
import org.lsst.ccs.drivers.commons.DriverException;

public class CCOBDataRead
implements Serializable {
    public static final int ADC_LED_VOLTAGE = 0;
    public static final int ADC_LED_CURRENT = 1;
    public static final int ADC_LED_VREF = 2;
    public static final int ADC_LED_TEMP1 = 3;
    public static final int ADC_LED_TEMP2 = 4;
    public static final int ADC_PD_CURRENT = 5;
    public static final int ADC_SPHERE_TEMP = 6;
    public static final int ADC_BOARD_TEMP = 7;
    public static final int NUM_ADCS = 8;
    private double ledVoltage;
    private double ledCurrent;
    private double ledVref;
    private double tempLed1;
    private double tempLed2;
    private double photodiodeCurrent;
    private double tempSphere;
    private double tempBrd;
    private double[] asDoubleArray;
    private String[] asStringArray;
    private String originalString;
    private static final long serialVersionUID = -5659896462402886077L;

    public double getLedCurrent() {
        return this.ledCurrent;
    }

    public double getPhotodiodeCurrent() {
        return this.photodiodeCurrent;
    }

    public double getTempSphere() {
        return this.tempSphere;
    }

    public double getTempBrd() {
        return this.tempBrd;
    }

    public double getTempLed1() {
        return this.tempLed1;
    }

    public double getTempLed2() {
        return this.tempLed2;
    }

    public double getLedVoltage() {
        return this.ledVoltage;
    }

    public double getLedVref() {
        return this.ledVref;
    }

    public String getInputString() {
        return this.originalString;
    }

    public String[] getInputStringAsArray() {
        return this.asStringArray;
    }

    public double[] getDoubleArray() {
        return this.asDoubleArray;
    }

    public String toString() {
        return String.format("\tLED Voltage = %g\n\tLED Current = %g\n\tLED Vref    = %g\n\tLED Temp1   = %g\n\tLED Temp2   = %g\n\tPhotodiode Current = %g\n\tSphere temperature = %g\n\tBoard temperature  = %g", this.ledVoltage, this.ledCurrent, this.ledVref, this.tempLed1, this.tempLed2, this.photodiodeCurrent, this.tempSphere, this.tempBrd);
    }

    public CCOBDataRead(double[] data) throws DriverException {
        if (data.length < 8) {
            throw new DriverException("CCOB ADC data array is too short");
        }
        this.asDoubleArray = new double[8];
        System.arraycopy(data, 0, this.asDoubleArray, 0, 8);
        this.ledVoltage = this.asDoubleArray[0];
        this.ledCurrent = this.asDoubleArray[1];
        this.ledVref = this.asDoubleArray[2];
        this.tempLed1 = this.asDoubleArray[3];
        this.tempLed2 = this.asDoubleArray[4];
        this.photodiodeCurrent = this.asDoubleArray[5];
        this.tempSphere = this.asDoubleArray[6];
        this.tempBrd = this.asDoubleArray[7];
        this.asStringArray = new String[8];
        this.originalString = "";
        for (int i = 0; i < 8; ++i) {
            this.asStringArray[i] = String.valueOf(this.asDoubleArray[i]);
            this.originalString = this.originalString + this.asStringArray[i] + ", ";
        }
    }

    public CCOBDataRead(String response) throws DriverException {
        this.originalString = response;
        this.asStringArray = this.originalString.split(" +");
        if (this.asStringArray.length < 8) {
            throw new DriverException("CCOB ADC data string is invalid");
        }
        this.asDoubleArray = new double[this.asStringArray.length];
        for (int j = 0; j < this.asStringArray.length; ++j) {
            this.asDoubleArray[j] = Double.valueOf(this.asStringArray[j]);
        }
        this.ledVoltage = this.asDoubleArray[0];
        this.ledCurrent = this.asDoubleArray[1];
        this.ledVref = this.asDoubleArray[2];
        this.tempLed1 = this.asDoubleArray[3];
        this.tempLed2 = this.asDoubleArray[4];
        this.photodiodeCurrent = this.asDoubleArray[5];
        this.tempSphere = this.asDoubleArray[6];
        this.tempBrd = this.asDoubleArray[7];
    }
}

