/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos.applets;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;

public class DrawApplet
extends Applet
implements MouseMotionListener,
ActionListener {
    private Graphics graphics = null;
    private Panel panel = null;
    private Panel sub_panel = null;
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private DataOutputStream outstream;
    private DataInputStream instream;
    private final Random random = new Random(System.currentTimeMillis());
    private Button clear_button;
    private Button leave_button;
    private Label mbr_label;
    private final Font default_font = new Font("Helvetica", 0, 12);
    private static final String groupname = "DrawGroup";
    private Channel channel = null;
    private int member_size = 1;
    private int red = 0;
    private int green = 0;
    private int blue = 0;
    private Color default_color = null;
    private String props = "tunnel.xml";
    private final List<Address> members = new ArrayList<Address>();
    private boolean fl = true;
    Log log = LogFactory.getLog(this.getClass());

    @Override
    public void init() {
        System.out.println("INIT");
        this.setLayout(new BorderLayout());
        String tmp_props = this.getParameter("properties");
        if (tmp_props != null) {
            System.out.println("Setting parameters " + tmp_props);
            this.props = tmp_props;
        }
        try {
            this.channel = new JChannel(this.props);
            this.channel.setReceiver(new ReceiverAdapter(){

                @Override
                public void viewAccepted(View v) {
                    List<Address> mbrs = v.getMembers();
                    System.out.println("View accepted: " + v);
                    DrawApplet.this.member_size = v.size();
                    if (DrawApplet.this.mbr_label != null) {
                        DrawApplet.this.mbr_label.setText(DrawApplet.this.member_size + " mbr(s)");
                    }
                    DrawApplet.this.members.clear();
                    DrawApplet.this.members.addAll(mbrs);
                }

                @Override
                public void receive(Message msg) {
                    if (msg == null || msg.getLength() == 0) {
                        DrawApplet.this.log.error("DrawApplet.run(): msg or msg.buffer is null !");
                        return;
                    }
                    DrawApplet.this.instream = new DataInputStream(new ByteArrayInputStream(msg.getRawBuffer(), msg.getOffset(), msg.getLength()));
                    int r = 0;
                    try {
                        r = DrawApplet.this.instream.readInt();
                        if (r == -13) {
                            DrawApplet.this.clearPanel();
                            return;
                        }
                        int g = DrawApplet.this.instream.readInt();
                        int b = DrawApplet.this.instream.readInt();
                        int my_x = DrawApplet.this.instream.readInt();
                        int my_y = DrawApplet.this.instream.readInt();
                        if (DrawApplet.this.graphics != null) {
                            DrawApplet.this.graphics.setColor(new Color(r, g, b));
                            DrawApplet.this.graphics.fillOval(my_x, my_y, 10, 10);
                            DrawApplet.this.graphics.setColor(DrawApplet.this.default_color);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            this.showStatus("Connecting to group DrawGroup");
            this.channel.connect(groupname);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.go();
    }

    @Override
    public void start() {
        System.out.println("------- START");
    }

    @Override
    public void destroy() {
        System.out.println("------- DESTROY");
        this.showStatus("Disconnecting from DrawGroup");
        this.channel.close();
        this.showStatus("Disconnected");
    }

    @Override
    public void paint(Graphics g) {
        Rectangle bounds = this.panel.getBounds();
        Color old = this.graphics.getColor();
        if (bounds == null || this.graphics == null) {
            return;
        }
        this.graphics.setColor(Color.black);
        this.graphics.drawRect(0, 0, bounds.width - 1, bounds.height - 1);
        this.graphics.setColor(old);
    }

    private void selectColor() {
        this.red = Math.abs(this.random.nextInt()) % 255;
        this.green = Math.abs(this.random.nextInt()) % 255;
        this.blue = Math.abs(this.random.nextInt()) % 255;
        this.default_color = new Color(this.red, this.green, this.blue);
    }

    public void go() {
        try {
            this.panel = new Panel();
            this.sub_panel = new Panel();
            this.resize(200, 200);
            this.add("Center", this.panel);
            this.clear_button = new Button("Clear");
            this.clear_button.setFont(this.default_font);
            this.clear_button.addActionListener(this);
            this.leave_button = new Button("Exit");
            this.leave_button.setFont(this.default_font);
            this.leave_button.addActionListener(this);
            this.mbr_label = new Label("0 mbr(s)");
            this.mbr_label.setFont(this.default_font);
            this.sub_panel.add("South", this.clear_button);
            this.sub_panel.add("South", this.leave_button);
            this.sub_panel.add("South", this.mbr_label);
            this.add("South", this.sub_panel);
            this.panel.addMouseMotionListener(this);
            this.setVisible(true);
            this.mbr_label.setText(this.member_size + " mbrs");
            this.graphics = this.panel.getGraphics();
            this.selectColor();
            this.graphics.setColor(this.default_color);
            this.panel.setBackground(Color.white);
            this.clear_button.setForeground(Color.blue);
            this.leave_button.setForeground(Color.blue);
        }
        catch (Exception e) {
            this.log.error(e.toString());
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int[] tmp = new int[]{0};
        int x = e.getX();
        int y = e.getY();
        this.graphics.fillOval(x, y, 10, 10);
        try {
            this.out.reset();
            this.outstream = new DataOutputStream(this.out);
            this.outstream.writeInt(this.red);
            this.outstream.writeInt(this.green);
            this.outstream.writeInt(this.blue);
            this.outstream.writeInt(x);
            this.outstream.writeInt(y);
            this.channel.send(new Message(null, null, this.out.toByteArray()));
            this.out.reset();
        }
        catch (Exception ex) {
            this.log.error(ex.toString());
        }
    }

    public void clearPanel() {
        Rectangle bounds = null;
        if (this.panel == null || this.graphics == null) {
            return;
        }
        bounds = this.panel.getBounds();
        this.graphics.clearRect(1, 1, bounds.width - 2, bounds.height - 2);
    }

    public void sendClearPanelMsg() {
        int[] tmp = new int[]{0};
        this.clearPanel();
        try {
            this.out.reset();
            this.outstream = new DataOutputStream(this.out);
            this.outstream.writeInt(-13);
            this.channel.send(new Message(null, null, this.out.toByteArray()));
            this.outstream.flush();
        }
        catch (Exception ex) {
            this.log.error(ex.toString());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command == "Clear") {
            System.out.println("Members are " + this.members);
            this.sendClearPanelMsg();
        } else if (command == "Exit") {
            try {
                this.destroy();
                this.setVisible(false);
            }
            catch (Exception ex) {
                this.log.error(ex.toString());
            }
        } else {
            System.out.println("Unknown action");
        }
    }
}

