/*
 * Decompiled with CFR 0.152.
 */
package plotter;

import data.DiscretePlotData;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import javax.swing.Icon;
import menus.IncludeInMenu;
import org.freehep.util.Value;
import plotter.Axis;
import plotter.ContinuousAxisModel;
import plotter.DataArea;
import plotter.DataOverlay;

public class LineChartOverlay
extends DataOverlay {
    private ContinuousAxisModel xModel;
    private ContinuousAxisModel yModel;
    private final DiscretePlotData data;
    private float lineWidth = 2.0f;
    private Color lineColor = Color.RED;
    private final int xDim;
    private final int yDim;

    public LineChartOverlay(String title, DiscretePlotData data, int xDim, int yDim, ContinuousAxisModel x, ContinuousAxisModel y) {
        super(title);
        this.data = data;
        this.xModel = x;
        this.yModel = y;
        this.xDim = xDim;
        this.yDim = yDim;
    }

    @Override
    protected void paint(Graphics2D g) {
        DataArea da = this.getDataArea();
        Axis x = da.getAxisForModel(this.xModel);
        Axis y = da.getAxisForModel(this.yModel);
        GeneralPath poly = new GeneralPath();
        Value value = new Value();
        for (int i = 0; i < this.data.getNPoints(); ++i) {
            this.data.getValue(value, this.xDim, i);
            double xValue = x.getPhysicalCoordinateFromAxisCoordinate(this.xModel.getAxisCoordinateFromModelCoordinate(value.getDouble()), da);
            this.data.getValue(value, this.yDim, i);
            double yValue = y.getPhysicalCoordinateFromAxisCoordinate(this.yModel.getAxisCoordinateFromModelCoordinate(value.getDouble()), da);
            if (i == 0) {
                poly.moveTo(xValue, yValue);
                continue;
            }
            poly.lineTo(xValue, yValue);
        }
        BasicStroke s = new BasicStroke(this.lineWidth, 2, 1);
        g.setStroke(s);
        g.setColor(this.lineColor);
        g.draw(poly);
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    @IncludeInMenu(value="Line Color")
    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    @IncludeInMenu(value="Line Width")
    public void setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
    }

    public Icon getKeyIcon() {
        return new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2 = (Graphics2D)g;
                BasicStroke s = new BasicStroke(LineChartOverlay.this.lineWidth, 2, 1);
                g2.setStroke(s);
                g2.setColor(LineChartOverlay.this.lineColor);
                GeneralPath poly = new GeneralPath();
                poly.moveTo(0.0f, 5.0f);
                poly.lineTo(10.0f, 5.0f);
                g2.draw(poly);
            }

            @Override
            public int getIconWidth() {
                return 10;
            }

            @Override
            public int getIconHeight() {
                return 10;
            }
        };
    }
}

