/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.services.persist;

import java.awt.Component;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.HashMap;
import javax.swing.JComponent;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.base.panel.PanelManager;

public class DataPanelDescriptor
implements Serializable,
Cloneable {
    private boolean open;
    private HashMap<String, Serializable> data;

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public HashMap<String, Serializable> getData() {
        return this.data;
    }

    public void setData(HashMap<String, Serializable> data) {
        this.data = data;
    }

    public DataPanelDescriptor clone() {
        try {
            DataPanelDescriptor d = (DataPanelDescriptor)super.clone();
            if (this.data != null) {
                d.data = (HashMap)this.data.clone();
            }
            return d;
        }
        catch (CloneNotSupportedException x) {
            return null;
        }
    }

    public static DataPanelDescriptor get(JComponent component) {
        DataPanelDescriptor desc = new DataPanelDescriptor();
        try {
            PanelManager panMan = Console.getConsole().getPanelManager();
            boolean docked = (Boolean)panMan.get((Component)component, Panel.DOCKED);
            desc.setOpen(true);
            if (!docked) {
                HashMap<String, Serializable> m = panMan.get((Component)component, EnumSet.of(Panel.DEVICE, new Panel[]{Panel.DOCKED, Panel.ICONIZED, Panel.LAST_DESELECTED, Panel.LOCATION, Panel.MAXIMIZED, Panel.SELECTED, Panel.SIZE}));
                desc.setData(m);
            }
        }
        catch (ClassCastException | IllegalArgumentException | NullPointerException x) {
            desc.setOpen(false);
        }
        return desc;
    }
}

