/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.states.DataProviderState;
import org.lsst.ccs.gconsole.plugins.monitor.FormattedValue;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorFormat;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.command.CommandService;

public class MonitorField {
    private static final HashMap<String, MonitorField> fields = new HashMap();
    public static final MonitorField NULL = new MonitorField(null, "", null);
    public static final MonitorField NAME = new MonitorField("name", "Name", null);
    public static final MonitorField VALUE;
    public static final MonitorField UNITS;
    public static final MonitorField LOW_ALARM;
    public static final MonitorField LOW_WARN;
    public static final MonitorField ALERT_LOW;
    public static final MonitorField HIGH_ALARM;
    public static final MonitorField HIGH_WARN;
    public static final MonitorField ALERT_HIGH;
    public static final MonitorField DESCR;
    public static final MonitorField AVERAGE_VALUE;
    public static final MonitorField MAX_VALUE;
    public static final MonitorField MIN_VALUE;
    public static final MonitorField MEDIAN_VALUE;
    protected final String key;
    protected final String title;
    protected final FormattedValue template;
    protected final Set<String> keys;

    public MonitorField(String key, String title, FormattedValue template, Set<String> keys) {
        this.key = key;
        this.title = title;
        FormattedValue formattedValue = this.template = template == null ? new FormattedValue() : new FormattedValue(template);
        this.keys = keys == null ? (key == null ? Collections.emptySet() : Collections.singleton(key)) : keys;
    }

    public MonitorField(String key, String title, FormattedValue template) {
        this(key, title, template, null);
    }

    public MonitorField(MonitorField other) {
        this.key = other.key;
        this.title = other.title;
        this.template = other.template;
        this.keys = other.keys;
    }

    public static synchronized void registerInstance(MonitorField field) {
        String key = field.getKey();
        if (fields.containsKey(key)) {
            throw new IllegalArgumentException("Field with key " + key + " is already registered.");
        }
        fields.put(key, field);
    }

    public static synchronized MonitorField getInstance(String key) {
        MonitorField field = MonitorField.getRegisteredInstance(key);
        if (field == null) {
            try {
                if (key.startsWith("MonitorField.")) {
                    key = key.substring("MonitorField.".length());
                }
                field = (MonitorField)MonitorField.class.getField(key).get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NullPointerException | SecurityException exception) {
                // empty catch block
            }
        }
        if (field == null) {
            field = new MonitorField(key, key, null);
            MonitorField.registerInstance(field);
        }
        return field;
    }

    @Deprecated
    public static synchronized MonitorField valueOf(String key) {
        return fields.get(key);
    }

    public static synchronized MonitorField getRegisteredInstance(String key) {
        return fields.get(key);
    }

    public static synchronized List<MonitorField> getDefaultFields(Collection<String> keys) {
        return keys.stream().map(k -> MonitorField.getRegisteredInstance(k)).filter(f -> f != null).collect(Collectors.toList());
    }

    public static List<MonitorField> getAffectedFields(Collection<String> keys, Collection<MonitorField> fields) {
        if (keys == null) {
            return null;
        }
        return fields.stream().filter(field -> {
            Set<String> att = field.getKeys();
            return keys.stream().anyMatch(k -> att.contains(k));
        }).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<MonitorField> getAffectedFields(Collection<String> keys) {
        if (keys == null) {
            return null;
        }
        Class<MonitorField> clazz = MonitorField.class;
        synchronized (MonitorField.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return MonitorField.getAffectedFields(keys, fields.values());
        }
    }

    public Object getValue(AgentChannel channel) {
        return channel == null || this.key == null ? null : channel.get(this.key);
    }

    public void setValue(Object value, AgentChannel channel) {
        try {
            ConfigurationParameterInfo conf = (ConfigurationParameterInfo)this.getValue(channel);
            if (value instanceof String) {
                value = ((String)value).trim();
            }
            CommandService.getService().execute(channel.getAgentName() + "/change", conf.getComponentName(), conf.getParameterName(), value);
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            // empty catch block
        }
    }

    public String getKey() {
        return this.key;
    }

    public String getTitle() {
        return this.title;
    }

    public Set<String> getKeys() {
        return this.keys;
    }

    public boolean isUpdatable() {
        return !this.getKeys().isEmpty();
    }

    public FormattedValue format(AgentChannel channel) {
        DataProviderState state;
        if (channel == null) {
            return FormattedValue.NA;
        }
        FormattedValue fv = new FormattedValue(this.template);
        if (fv.bgColor == null && this.keys.contains(AgentChannel.Key.STATE) && (state = (DataProviderState)channel.get(AgentChannel.Key.STATE)) != null) {
            fv.bgColor = MonitorFormat.COLOR_STATE.get(state);
        }
        if (fv.format == null) {
            fv.format = (String)channel.get(AgentChannel.Key.FORMAT);
        }
        fv.value = this.getValue(channel);
        return fv;
    }

    public FormattedValue format(List<AgentChannel> channels) {
        return null;
    }

    public String toString() {
        return this.title;
    }

    static {
        MonitorField.registerInstance(NAME);
        VALUE = new MonitorField("value", "Value", new FormattedValue(null, null, null, 4, null, null), Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("value", AgentChannel.Key.STATE))));
        MonitorField.registerInstance(VALUE);
        UNITS = new MonitorField(AgentChannel.Key.UNITS, "Units", new FormattedValue(null, null, null, 2, null, false));
        MonitorField.registerInstance(UNITS);
        LOW_ALARM = new Limit("limitLo", "Low Limit");
        MonitorField.registerInstance(LOW_ALARM);
        LOW_WARN = new Limit("dbandLo", "Low Warn"){
            private final Set<String> keys = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("dbandLo", "limitLo")));

            @Override
            public Set<String> getKeys() {
                return this.keys;
            }

            @Override
            public FormattedValue format(AgentChannel channel) {
                try {
                    FormattedValue fv = super.format(channel);
                    Object o = fv.value;
                    if (o instanceof ConfigurationParameterInfo) {
                        o = ((ConfigurationParameterInfo)o).getCurrentValue();
                    }
                    if (!(o instanceof Double)) {
                        o = Double.valueOf(o.toString());
                    }
                    double d = (Double)o;
                    o = channel.get("limitLo");
                    if (o instanceof ConfigurationParameterInfo) {
                        o = ((ConfigurationParameterInfo)o).getCurrentValue();
                    }
                    if (!(o instanceof Double)) {
                        o = Double.valueOf(o.toString());
                    }
                    d = (Double)o + d;
                    fv.text = String.format(fv.format, d);
                    return fv;
                }
                catch (NullPointerException | NumberFormatException | IllegalFormatException x) {
                    return FormattedValue.NA;
                }
            }

            @Override
            public void setValue(Object value, AgentChannel channel) {
                try {
                    if (!(value instanceof Double)) {
                        value = Double.valueOf(value.toString());
                    }
                    double d = (Double)value;
                    Object o = channel.get("limitLo");
                    if (o instanceof ConfigurationParameterInfo) {
                        o = ((ConfigurationParameterInfo)o).getCurrentValue();
                    }
                    if (!(o instanceof Double)) {
                        o = Double.valueOf(o.toString());
                    }
                    value = String.valueOf(d -= ((Double)o).doubleValue());
                    ConfigurationParameterInfo conf = (ConfigurationParameterInfo)this.getValue(channel);
                    CommandService.getService().execute(channel.getAgentName() + "/change", conf.getComponentName(), conf.getParameterName(), value);
                }
                catch (ClassCastException | NullPointerException runtimeException) {
                    // empty catch block
                }
            }
        };
        MonitorField.registerInstance(LOW_WARN);
        ALERT_LOW = new Alert(AgentChannel.Key.ALERT_LOW);
        MonitorField.registerInstance(ALERT_LOW);
        HIGH_ALARM = new Limit("limitHi", "High Limit");
        MonitorField.registerInstance(HIGH_ALARM);
        HIGH_WARN = new Limit("dbandHi", "High Warn"){
            private final Set<String> keys = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("dbandHi", "limitHi")));

            @Override
            public Set<String> getKeys() {
                return this.keys;
            }

            @Override
            public FormattedValue format(AgentChannel channel) {
                try {
                    FormattedValue fv = super.format(channel);
                    Object o = fv.value;
                    if (o instanceof ConfigurationParameterInfo) {
                        o = ((ConfigurationParameterInfo)o).getCurrentValue();
                    }
                    if (!(o instanceof Double)) {
                        o = Double.valueOf(o.toString());
                    }
                    double d = (Double)o;
                    o = channel.get("limitHi");
                    if (o instanceof ConfigurationParameterInfo) {
                        o = ((ConfigurationParameterInfo)o).getCurrentValue();
                    }
                    if (!(o instanceof Double)) {
                        o = Double.valueOf(o.toString());
                    }
                    d = (Double)o - d;
                    fv.text = String.format(fv.format, d);
                    return fv;
                }
                catch (NullPointerException | NumberFormatException | IllegalFormatException x) {
                    return FormattedValue.NA;
                }
            }

            @Override
            public void setValue(Object value, AgentChannel channel) {
                try {
                    if (!(value instanceof Double)) {
                        value = Double.valueOf(value.toString());
                    }
                    double d = (Double)value;
                    Object o = channel.get("limitHi");
                    if (o instanceof ConfigurationParameterInfo) {
                        o = ((ConfigurationParameterInfo)o).getCurrentValue();
                    }
                    if (!(o instanceof Double)) {
                        o = Double.valueOf(o.toString());
                    }
                    d = (Double)o - d;
                    value = String.valueOf(d);
                    ConfigurationParameterInfo conf = (ConfigurationParameterInfo)this.getValue(channel);
                    CommandService.getService().execute(channel.getAgentName() + "/change", conf.getComponentName(), conf.getParameterName(), value);
                }
                catch (ClassCastException | NullPointerException runtimeException) {
                    // empty catch block
                }
            }
        };
        MonitorField.registerInstance(HIGH_WARN);
        ALERT_HIGH = new Alert(AgentChannel.Key.ALERT_HIGH);
        MonitorField.registerInstance(ALERT_HIGH);
        DESCR = new MonitorField("description", "Description", new FormattedValue(null, null, null, 2, null, false));
        MonitorField.registerInstance(DESCR);
        AVERAGE_VALUE = new StateColor("value", "Average", MonitorField.VALUE.template, (Set)Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("value", AgentChannel.Key.STATE)))){

            @Override
            public FormattedValue format(List<AgentChannel> channels) {
                if (channels.isEmpty()) {
                    return FormattedValue.EMPTY;
                }
                FormattedValue fv = super.format(channels);
                int n = 0;
                double sum = 0.0;
                for (AgentChannel ch : channels) {
                    if (ch == null) continue;
                    try {
                        Double value = (Double)ch.get(this.key);
                        if (value == null || value.isInfinite() || value.isNaN()) continue;
                        ++n;
                        sum += value.doubleValue();
                    }
                    catch (ClassCastException classCastException) {}
                }
                fv.text = n > 0 ? (fv.format == null ? String.format(MonitorFormat.DEFAULT.FLOAT_FORMAT, sum) : String.format(fv.format, sum /= (double)n, n)) : "";
                return fv;
            }
        };
        MAX_VALUE = new StateColor("value", "Max", MonitorField.VALUE.template, (Set)Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("value", AgentChannel.Key.STATE)))){

            @Override
            public FormattedValue format(List<AgentChannel> channels) {
                if (channels.isEmpty()) {
                    return FormattedValue.EMPTY;
                }
                FormattedValue fv = super.format(channels);
                int n = 0;
                double sum = Double.NEGATIVE_INFINITY;
                for (AgentChannel ch : channels) {
                    if (ch == null) continue;
                    try {
                        Double value = (Double)ch.get(this.key);
                        if (value == null || value.isInfinite() || value.isNaN()) continue;
                        ++n;
                        sum = Math.max(sum, value);
                    }
                    catch (ClassCastException classCastException) {}
                }
                fv.text = n > 0 ? (fv.format == null ? String.format(MonitorFormat.DEFAULT.FLOAT_FORMAT, sum) : String.format(fv.format, sum, n)) : "";
                return fv;
            }
        };
        MIN_VALUE = new StateColor("value", "Min", MonitorField.VALUE.template, (Set)Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("value", AgentChannel.Key.STATE)))){

            @Override
            public FormattedValue format(List<AgentChannel> channels) {
                if (channels.isEmpty()) {
                    return FormattedValue.EMPTY;
                }
                FormattedValue fv = super.format(channels);
                int n = 0;
                double sum = Double.POSITIVE_INFINITY;
                for (AgentChannel ch : channels) {
                    if (ch == null) continue;
                    try {
                        Double value = (Double)ch.get(this.key);
                        if (value == null || value.isInfinite() || value.isNaN()) continue;
                        ++n;
                        sum = Math.min(sum, value);
                    }
                    catch (ClassCastException classCastException) {}
                }
                fv.text = n > 0 ? (fv.format == null ? String.format(MonitorFormat.DEFAULT.FLOAT_FORMAT, sum) : String.format(fv.format, sum, n)) : "";
                return fv;
            }
        };
        MEDIAN_VALUE = new StateColor("value", "Median", MonitorField.VALUE.template, (Set)Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("value", AgentChannel.Key.STATE)))){

            @Override
            public FormattedValue format(List<AgentChannel> channels) {
                if (channels.isEmpty()) {
                    return FormattedValue.EMPTY;
                }
                FormattedValue fv = super.format(channels);
                int n = 0;
                double[] vv = new double[channels.size()];
                for (AgentChannel ch : channels) {
                    if (ch == null) continue;
                    try {
                        Double value = (Double)ch.get(this.key);
                        if (value == null || value.isInfinite() || value.isNaN()) continue;
                        vv[n++] = value;
                    }
                    catch (ClassCastException classCastException) {}
                }
                if (n > 0) {
                    Arrays.sort(vv);
                    double m = n % 2 == 0 ? (vv[n / 2] + vv[n / 2 - 1]) / 2.0 : vv[n / 2];
                    fv.text = fv.format == null ? String.format(MonitorFormat.DEFAULT.FLOAT_FORMAT, m) : String.format(fv.format, m, n);
                } else {
                    fv.text = "";
                }
                return fv;
            }
        };
    }

    public static class Average
    extends MonitorField {
        private final boolean checkState;

        public Average(String key, String title, FormattedValue template, Set<String> keys) {
            super(key, title, template, keys);
            this.checkState = keys.contains(AgentChannel.Key.STATE);
        }

        @Override
        public FormattedValue format(List<AgentChannel> channels) {
            if (channels.isEmpty()) {
                return FormattedValue.EMPTY;
            }
            int n = 0;
            double sum = 0.0;
            int highestState = -1;
            for (AgentChannel ch : channels) {
                if (ch == null) continue;
                if (this.checkState) {
                    DataProviderState state = (DataProviderState)ch.get(AgentChannel.Key.STATE);
                    int ordinal = state == null ? -1 : state.ordinal();
                    highestState = Math.max(highestState, ordinal);
                    if (ordinal < DataProviderState.NOMINAL.ordinal()) continue;
                }
                try {
                    Double value = (Double)ch.get(this.key);
                    if (value == null || value.isInfinite() || value.isNaN()) continue;
                    ++n;
                    sum += value.doubleValue();
                }
                catch (ClassCastException classCastException) {}
            }
            if (n > 0) {
                sum /= (double)n;
            } else {
                return FormattedValue.NA;
            }
            FormattedValue fv = new FormattedValue(this.template);
            if (fv.bgColor == null && highestState >= 0) {
                fv.bgColor = MonitorFormat.COLOR_STATE.get(DataProviderState.values()[highestState]);
            }
            fv.text = fv.format == null ? String.format(MonitorFormat.DEFAULT.FLOAT_FORMAT, sum) : String.format(fv.format, sum, n);
            return fv;
        }
    }

    private static class StateColor
    extends MonitorField {
        private final boolean checkState;

        public StateColor(String key, String title, FormattedValue template, Set<String> keys) {
            super(key, title, template, keys);
            this.checkState = keys.contains(AgentChannel.Key.STATE);
        }

        @Override
        public FormattedValue format(List<AgentChannel> channels) {
            int highestState = -1;
            for (AgentChannel ch : channels) {
                if (ch == null || !this.checkState) continue;
                DataProviderState state = (DataProviderState)ch.get(AgentChannel.Key.STATE);
                int ordinal = state == null ? -1 : state.ordinal();
                highestState = Math.max(highestState, ordinal);
            }
            FormattedValue fv = new FormattedValue(this.template);
            if (fv.bgColor == null && highestState >= 0) {
                fv.bgColor = MonitorFormat.COLOR_STATE.get(DataProviderState.values()[highestState]);
            }
            return fv;
        }
    }

    private static class Limit
    extends MonitorField {
        Limit(String key, String title) {
            super(key, title, null);
        }

        @Override
        public FormattedValue format(AgentChannel channel) {
            if (channel == null) {
                return FormattedValue.NA;
            }
            FormattedValue fv = new FormattedValue();
            fv.value = channel.get(this.key);
            fv.horizontalAlignment = 4;
            Object f = channel.get(AgentChannel.Key.FORMAT);
            fv.format = f instanceof String ? (String)f : MonitorFormat.DEFAULT.FLOAT_FORMAT;
            return fv;
        }
    }

    private static class Alert
    extends MonitorField {
        Alert(String key) {
            super(key, "Al.", null);
        }

        @Override
        public FormattedValue format(AgentChannel channel) {
            String text;
            String alertName;
            Object value = channel.get(this.key);
            if (value instanceof String && !((String)value).trim().isEmpty() && !((String)value).equals("null")) {
                alertName = (String)value;
                text = "  \u2713  ";
            } else {
                alertName = "No alert";
                text = " ";
            }
            return new FormattedValue(text, MonitorFormat.COLOR_FG, MonitorFormat.COLOR_BG, 0, alertName, false);
        }
    }
}

