/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.bus.gantry;

import java.io.Serializable;
import org.lsst.ccs.subsystem.motorplatform.bus.gantry.GantryOrientation;
import org.lsst.ccs.subsystem.motorplatform.bus.gantry.GantryReplyCaller;
import org.lsst.ccs.subsystem.motorplatform.bus.gantry.GantryReplyListener;

public class GantryStatus
implements Serializable,
GantryReplyCaller {
    private static final long serialVersionUID = 1L;
    private final double lcReading;
    private final double raftWeight;
    private final double airPressure;
    private final int pressureOK;
    private final int orientation;
    private final boolean ignoreLoadCell;

    public GantryStatus(double lcReading, double raftWeight, double airPressure, boolean pressureOK, GantryOrientation orientation, boolean ignoreLoadCell) {
        this.lcReading = lcReading;
        this.raftWeight = raftWeight;
        this.airPressure = airPressure;
        this.pressureOK = pressureOK ? 1 : 0;
        this.orientation = orientation.ordinal();
        this.ignoreLoadCell = ignoreLoadCell;
    }

    public double getLoadCellReading() {
        return this.lcReading;
    }

    public boolean loadCellIsIgnored() {
        return this.ignoreLoadCell;
    }

    public double getRaftWeight() {
        return this.raftWeight;
    }

    public double getAirPressure() {
        return this.airPressure;
    }

    public GantryOrientation getOrientation() {
        return GantryOrientation.values()[this.orientation];
    }

    public boolean getPressureOK() {
        return this.pressureOK == 1;
    }

    @Override
    public void callGantryReplyHandler(GantryReplyListener listener) {
        listener.gantryStatus(this);
    }
}

