/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.test;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.ErrInfo;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Metadata;
import org.astrogrid.samp.RegInfo;
import org.astrogrid.samp.Response;
import org.astrogrid.samp.SampUtils;
import org.astrogrid.samp.Subscriptions;
import org.astrogrid.samp.client.CallableClient;
import org.astrogrid.samp.client.ClientProfile;
import org.astrogrid.samp.client.DefaultClientProfile;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.gui.HubMonitor;
import org.astrogrid.samp.test.CalcStorm;
import org.astrogrid.samp.test.Calculator;
import org.astrogrid.samp.test.ReplyCollector;
import org.astrogrid.samp.test.TestException;
import org.astrogrid.samp.test.TestXmlrpcClient;
import org.astrogrid.samp.test.Tester;
import org.astrogrid.samp.xmlrpc.LockInfo;
import org.astrogrid.samp.xmlrpc.StandardClientProfile;

public class HubTester
extends Tester {
    private final ClientProfile profile_;
    private final String hubId_;
    private final Client[] ignoreClients_;
    private final Set selfIds_;
    private final Set privateKeys_;
    private final ClientWatcher clientWatcher_;
    private final Random random_ = new Random(233333L);
    private static final String WAITMILLIS_KEY = "test.wait";
    private static final String MSGIDQUERY_KEY = "test.msgid";
    private static final String ECHO_MTYPE = "test.echo";
    private static final String PING_MTYPE = "samp.app.ping";
    private static final String FAIL_MTYPE = "test.fail";
    private static final String REGISTER_MTYPE = "samp.hub.event.register";
    private static final String UNREGISTER_MTYPE = "samp.hub.event.unregister";
    private static final String METADATA_MTYPE = "samp.hub.event.metadata";
    private static final String SUBSCRIPTIONS_MTYPE = "samp.hub.event.subscriptions";
    private static final String ERROR_KEY = "test.error";
    private static final char[] ALPHA_CHARS;
    private static final char[] GENERAL_CHARS;
    private static Logger logger_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public HubTester(ClientProfile profile) throws IOException {
        this.profile_ = profile;
        this.selfIds_ = new HashSet();
        this.privateKeys_ = new HashSet();
        HubConnection conn = this.profile_.register();
        if (conn == null) {
            throw new IOException("No hub is running");
        }
        conn.ping();
        this.clientWatcher_ = new ClientWatcher(conn);
        conn.setCallable(this.clientWatcher_);
        HubTester hubTester = this;
        conn.declareSubscriptions(hubTester.clientWatcher_.getSubscriptions());
        HubTester hubTester2 = this;
        conn.declareMetadata(hubTester2.clientWatcher_.getMetadata());
        RegInfo regInfo = conn.getRegInfo();
        regInfo.check();
        this.hubId_ = regInfo.getHubId();
        this.selfIds_.add(regInfo.getSelfId());
        this.privateKeys_.add(regInfo.getPrivateKey());
        String[] clientIds = conn.getRegisteredClients();
        HubTester.assertTrue(Arrays.asList(clientIds).contains(regInfo.getHubId()));
        HubTester.assertTrue(!Arrays.asList(clientIds).contains(regInfo.getSelfId()));
        String[] clientIds1 = new String[clientIds.length + 1];
        System.arraycopy(clientIds, 0, clientIds1, 0, clientIds.length);
        clientIds1[clientIds.length] = regInfo.getSelfId();
        clientIds = clientIds1;
        int nc = clientIds.length;
        Client[] clients = new Client[nc];
        for (int ic = 0; ic < nc; ++ic) {
            final String id = clientIds[ic];
            final Metadata meta = conn.getMetadata(id);
            meta.check();
            final Subscriptions subs = conn.getSubscriptions(id);
            subs.check();
            clients[ic] = new Client(){

                public String getId() {
                    return id;
                }

                public Metadata getMetadata() {
                    return meta;
                }

                public Subscriptions getSubscriptions() {
                    return subs;
                }
            };
        }
        this.ignoreClients_ = clients;
    }

    private HubConnection register() throws SampException {
        HubConnection conn = this.profile_.register();
        RegInfo regInfo = conn.getRegInfo();
        regInfo.check();
        String selfId = regInfo.getSelfId();
        String privateKey = regInfo.getPrivateKey();
        HubTester.assertEquals(this.hubId_, regInfo.getHubId());
        HubTester.assertTrue(!this.selfIds_.contains(selfId));
        this.selfIds_.add(selfId);
        HubTester.assertTrue(!this.privateKeys_.contains(privateKey));
        this.privateKeys_.add(privateKey);
        HubTester.assertTrue(!Arrays.asList(conn.getRegisteredClients()).contains(selfId));
        HubTester.assertEquals(new HashMap(), conn.getMetadata(selfId));
        HubTester.assertEquals(new HashMap(), conn.getSubscriptions(selfId));
        return conn;
    }

    public void run() throws IOException {
        if (this.profile_ == StandardClientProfile.getInstance()) {
            this.testStandardLockfile();
        }
        if (this.profile_ instanceof StandardClientProfile) {
            this.testLockInfo(((StandardClientProfile)this.profile_).getLockInfo());
        }
        this.testClients();
        this.testStress();
    }

    private void testStandardLockfile() throws IOException {
        LockInfo lockInfo = StandardClientProfile.getInstance().getLockInfo();
        if (lockInfo == null) {
            throw new TestException("No lockfile (no hub)");
        }
    }

    private void testLockInfo(LockInfo lockInfo) throws IOException {
        if (lockInfo == null) {
            throw new TestException("No LockInfo (no hub)");
        }
        lockInfo.check();
        String secret = lockInfo.getSecret();
        URL hubUrl = lockInfo.getXmlrpcUrl();
        TestXmlrpcClient xclient = new TestXmlrpcClient(hubUrl);
        xclient.checkSuccessCall("samp.hub.ping", new ArrayList());
        xclient.checkFailureCall("samp.hub.register", Collections.singletonList(secret + "-NOT!"));
        xclient.checkFailureCall("samp.hub.not-a-method", Collections.singletonList(secret));
    }

    private void testClients() throws IOException {
        Message msg;
        String val3;
        Object val2;
        Object val1;
        Message msg2;
        int i;
        HubConnection c0 = this.register();
        String id0 = c0.getRegInfo().getSelfId();
        Metadata meta0 = new Metadata();
        meta0.setName("Shorty");
        meta0.setDescriptionText("Short-lived test client");
        c0.declareMetadata(meta0);
        TestCallableClient callable0 = new TestCallableClient(c0);
        c0.setCallable(callable0);
        Subscriptions subs0 = new Subscriptions();
        subs0.put(ECHO_MTYPE, new HashMap());
        subs0.check();
        c0.declareSubscriptions(subs0);
        c0.unregister();
        HubConnection c1 = this.register();
        String id1 = c1.getRegInfo().getSelfId();
        Metadata meta1 = new Metadata();
        meta1.setName("Test1");
        meta1.setDescriptionText("HubTester client application");
        meta1.put("test.drink", "cider");
        c1.declareMetadata(meta1);
        this.assertTestClients(c1, new String[0]);
        HubConnection c2 = this.register();
        String id2 = c2.getRegInfo().getSelfId();
        Metadata meta2 = new Metadata(meta1);
        meta2.put("test.drink", "ribena");
        c2.declareMetadata(meta2);
        this.assertTestClients(c2, new String[]{id1});
        this.assertTestClients(c1, new String[]{id2});
        HubTester.assertEquals(meta1, c1.getMetadata(id1));
        HubTester.assertEquals(meta1, c2.getMetadata(id1));
        HubTester.assertEquals(meta2, c1.getMetadata(id2));
        HubTester.assertEquals(meta2, c2.getMetadata(id2));
        HubTester.assertEquals("cider", c2.getMetadata(id1).get("test.drink"));
        meta1.put("test.drink", "scrumpy");
        c1.declareMetadata(meta1);
        HubTester.assertEquals(meta1, c1.getMetadata(id1));
        HubTester.assertEquals(meta1, c2.getMetadata(id1));
        HubTester.assertEquals("scrumpy", c2.getMetadata(id1).get("test.drink"));
        TestCallableClient callable1 = new TestCallableClient(c1);
        c1.setCallable(callable1);
        Subscriptions subs1 = new Subscriptions();
        subs1.put("test.dummy.1", new HashMap());
        subs1.put("test.dummy.2", new HashMap());
        c1.declareSubscriptions(subs1);
        HubTester.assertEquals(subs1, c1.getSubscriptions(id1));
        HubTester.assertEquals(subs1, c2.getSubscriptions(id1));
        HashMap<String, String> d3atts = new HashMap<String, String>();
        d3atts.put("size", "big");
        d3atts.put("colour", "blue");
        subs1.put("test.dummy.3", d3atts);
        c1.declareSubscriptions(subs1);
        HubTester.assertEquals(subs1, c2.getSubscriptions(id1));
        HubTester.assertEquals(new HashMap(), (Map)c2.getSubscriptions(id1).get("test.dummy.1"));
        HubTester.assertEquals("big", ((Map)c2.getSubscriptions(id1).get("test.dummy.3")).get("size"));
        c1.declareSubscriptions(TestCallableClient.SUBS);
        TestCallableClient callable2 = new TestCallableClient(c2);
        c2.setCallable(callable2);
        c2.declareSubscriptions(TestCallableClient.SUBS);
        try {
            c1.getMetadata("Sir Not-Appearing-in-this-Hub");
            HubTester.fail();
        }
        catch (SampException e) {
            // empty catch block
        }
        try {
            c1.getSubscriptions("Sir Not-Appearing-in-this-Hub");
            HubTester.fail();
        }
        catch (SampException e) {
            // empty catch block
        }
        HubConnection c4 = this.register();
        TestCallableClient callable4 = new TestCallableClient(c4);
        callable4.setAllowTagReuse(true);
        c4.setCallable(callable4);
        int necho = 5;
        Map[] echoParams = new Map[necho];
        String[] msgIds2 = new String[necho];
        String[] msgIds4 = new String[necho];
        for (i = 0; i < necho; ++i) {
            msg2 = new Message(ECHO_MTYPE);
            val1 = this.createRandomObject(2, false);
            val2 = this.createRandomObject(4, false);
            val3 = new String(GENERAL_CHARS);
            msg2.put(WAITMILLIS_KEY, SampUtils.encodeInt(200 + 100 * i));
            msg2.put(MSGIDQUERY_KEY, SampUtils.encodeBoolean(true));
            msg2.addParam("val1", val1);
            msg2.addParam("val2", val2);
            msg2.addParam("val3", val3);
            echoParams[i] = msg2.getParams();
            c2.notify(id1, msg2);
            msgIds2[i] = callable2.call(id1, "tag" + i, msg2);
            msgIds4[i] = callable4.call(id1, "sametag", msg2);
        }
        if (callable2.getReplyCount() > necho / 2) {
            logger_.warning("Looks like hub call()/notify() methods not completing quickly (" + callable2.getReplyCount() + "/" + necho + ")");
        }
        while (callable2.getReplyCount() < necho || callable4.getReplyCount() < necho) {
            HubTester.delay(100);
        }
        HubTester.assertEquals(necho, callable2.getReplyCount());
        HubTester.assertEquals(necho, callable4.getReplyCount());
        for (i = 0; i < necho; ++i) {
            HubTester.assertEquals(necho - i, callable2.getReplyCount());
            Response r2 = callable2.getReply(id1, "tag" + i);
            HubTester.assertEquals("samp.ok", r2.getStatus());
            HubTester.assertEquals(echoParams[i], r2.getResult());
            HubTester.assertEquals(msgIds2[i], r2.get(MSGIDQUERY_KEY));
            HubTester.assertEquals(necho - i, callable4.getReplyCount());
            Response r4 = callable4.getReply(id1, "sametag");
            HubTester.assertEquals("samp.ok", r4.getStatus());
        }
        HubTester.assertEquals(0, callable2.getReplyCount());
        HubTester.assertEquals(0, callable4.getReplyCount());
        c4.unregister();
        for (i = 0; i < necho; ++i) {
            msg2 = new Message(ECHO_MTYPE);
            val1 = this.createRandomObject(2, false);
            val2 = this.createRandomObject(4, false);
            val3 = new String(GENERAL_CHARS);
            msg2.put(WAITMILLIS_KEY, SampUtils.encodeInt(100 * i));
            msg2.addParam("val1", val1);
            msg2.addParam("val2", val2);
            msg2.addParam("val3", val3);
            echoParams[i] = msg2.getParams();
            Response syncR = c2.callAndWait(id1, msg2, 0);
            HubTester.assertEquals(echoParams[i], syncR.getResult());
        }
        for (int ie = 0; ie < 5; ++ie) {
            int num = (int)Math.pow(10.0, ie);
            ArrayList<String> list = new ArrayList<String>(num);
            for (int in = 0; in < num; ++in) {
                list.add(SampUtils.encodeInt(in + 1));
            }
            msg = new Message(ECHO_MTYPE);
            msg.addParam("list", list);
            msg.check();
            Response response = c2.callAndWait(id1, msg, 0);
            response.check();
            HubTester.assertEquals("samp.ok", response.getStatus());
            HubTester.assertEquals(list, response.getResult().get("list"));
        }
        Message msg3 = new Message(ECHO_MTYPE);
        msg3.addParam("text", "copy");
        int delay = 10000;
        msg3.put(WAITMILLIS_KEY, SampUtils.encodeInt(delay));
        long start = System.currentTimeMillis();
        try {
            c2.callAndWait(id1, msg3, 1);
            if (!$assertionsDisabled && System.currentTimeMillis() - start < (long)delay) {
                throw new AssertionError();
            }
            logger_.warning("callAndWait() did not timeout as requested");
        }
        catch (SampException e) {
            // empty catch block
        }
        HubConnection c3 = this.register();
        TestCallableClient callable3 = new TestCallableClient(c3);
        c3.setCallable(callable3);
        Set recipientSet = c3.getSubscribedClients(ECHO_MTYPE).keySet();
        try {
            HubTester.assertEquals(new HashSet<String>(Arrays.asList(id1, id2)), recipientSet);
        }
        catch (TestException e) {
            throw new TestException("You may need to shut down other SAMP clients first", e);
        }
        msg = new Message(ECHO_MTYPE);
        Object val4 = this.createRandomObject(4, false);
        msg.addParam("val4", val4);
        msg.put(WAITMILLIS_KEY, SampUtils.encodeInt(400));
        List notifyList = c3.notifyAll(msg);
        HubTester.assertEquals(recipientSet, new HashSet(notifyList));
        String tag = "tag99";
        msg.put(MSGIDQUERY_KEY, "1");
        Map callMap = callable3.callAll(tag, msg);
        if (callable3.getReplyCount() != 0) {
            logger_.warning("Looks like hub call()/notify() methods not completing quickly");
        }
        Iterator it = recipientSet.iterator();
        while (it.hasNext()) {
            String rid = (String)it.next();
            Response response = callable3.waitForReply(rid, tag);
            HubTester.assertEquals("samp.ok", response.getStatus());
            HubTester.assertEquals(val4, response.getResult().get("val4"));
            HubTester.assertEquals((String)callMap.get(rid), response.get(MSGIDQUERY_KEY));
        }
        HubTester.assertEquals(0, callable3.getReplyCount());
        HubTester.delay(500);
        HubTester.assertEquals(0, callable3.getReplyCount());
        Message pingMsg = new Message(PING_MTYPE);
        pingMsg.put(WAITMILLIS_KEY, SampUtils.encodeInt(100));
        int pingsCount = 50;
        Set recipients = c3.getSubscribedClients(PING_MTYPE).keySet();
        HubTester.assertTrue(recipients.contains(id1));
        HubTester.assertTrue(recipients.contains(id2));
        c3.declareSubscriptions(TestCallableClient.SUBS);
        HubTester.assertEquals(recipients, c3.getSubscribedClients(PING_MTYPE).keySet());
        for (int i2 = 0; i2 < pingsCount; ++i2) {
            c3.notify(id1, pingMsg);
            callable3.call(id1, "abc1-" + i2, pingMsg);
            List notifyList2 = c3.notifyAll(pingMsg);
            callMap = callable3.callAll("abc2-" + i2, pingMsg);
            HubTester.assertEquals(recipients, new HashSet(notifyList2));
            HubTester.assertEquals(recipients, callMap.keySet());
        }
        int np1 = pingsCount * 4;
        int np2 = pingsCount * 2;
        int np3 = 0;
        int nr3 = pingsCount * (1 + recipients.size());
        while (callable1.pingCount_ < np1 || callable2.pingCount_ < np2 || callable3.pingCount_ < np3 || callable3.getReplyCount() < nr3) {
            HubTester.delay(100);
        }
        HubTester.delay(400);
        HubTester.assertEquals(np1, callable1.pingCount_);
        HubTester.assertEquals(np2, callable2.pingCount_);
        HubTester.assertEquals(np3, callable3.pingCount_);
        HubTester.assertEquals(nr3, callable3.getReplyCount());
        c3.declareSubscriptions(new Subscriptions());
        Message failMsg = new Message(FAIL_MTYPE);
        HashMap<String, String> error = new HashMap<String, String>();
        error.put("samp.errortxt", "failure");
        error.put("samp.code", "999");
        error.put("do.what", "do.that");
        failMsg.addParam(ERROR_KEY, error);
        Response reply = c3.callAndWait(id2, failMsg, 0);
        ErrInfo errInfo = reply.getErrInfo();
        errInfo.check();
        HubTester.assertEquals("samp.error", reply.getStatus());
        HubTester.assertEquals("failure", errInfo.getErrortxt());
        HubTester.assertEquals("999", errInfo.getCode());
        HubTester.assertEquals("do.that", errInfo.get("do.what"));
        String dummyMtype = "not.an.mtype";
        Message dummyMsg = new Message(dummyMtype);
        Set subscribed = c3.getSubscribedClients(dummyMtype).keySet();
        HubTester.assertTrue(!subscribed.contains(id1));
        HubTester.assertTrue(!subscribed.contains(id2));
        try {
            c3.notify(id1, dummyMsg);
            HubTester.fail();
        }
        catch (SampException e) {
            // empty catch block
        }
        try {
            c3.call(id1, "xxx", dummyMsg);
            HubTester.fail();
        }
        catch (SampException e) {
            // empty catch block
        }
        try {
            c3.callAndWait(id1, dummyMsg, 0);
            HubTester.fail();
        }
        catch (SampException e) {
            // empty catch block
        }
        notifyList = c3.notifyAll(dummyMsg);
        HubTester.assertEquals(0, notifyList.size());
        Map callMap2 = c3.callAll("yyy", dummyMsg);
        HubTester.assertEquals(0, callMap2.size());
        Throwable cwError = this.clientWatcher_.getError();
        if (cwError != null) {
            throw new TestException("Error encountered during hub event processing", cwError);
        }
        WatchedClient client0 = this.clientWatcher_.getClient(id0);
        HubTester.assertTrue(client0 != null);
        HubTester.assertTrue(client0.reg_);
        HubTester.assertTrue(client0.unreg_);
        HubTester.assertEquals(meta0, client0.meta_);
        HubTester.assertEquals(subs0, client0.subs_);
        String cwId = this.clientWatcher_.getConnection().getRegInfo().getSelfId();
        WatchedClient cwClient = this.clientWatcher_.getClient(cwId);
        HubTester.assertTrue(cwClient != null);
        HubTester.assertTrue(!cwClient.unreg_);
        HubTester hubTester = this;
        HubTester.assertEquals(hubTester.clientWatcher_.getMetadata(), cwClient.meta_);
        HubTester hubTester2 = this;
        HubTester.assertEquals(hubTester2.clientWatcher_.getSubscriptions(), cwClient.subs_);
        c3.unregister();
        this.assertTestClients(c1, new String[]{id2});
        this.assertTestClients(c2, new String[]{id1});
        c1.unregister();
        c2.unregister();
    }

    private void testStress() throws IOException {
        ClientProfile profile = new ClientProfile(){

            public boolean isHubRunning() {
                return HubTester.this.profile_.isHubRunning();
            }

            public HubConnection register() throws SampException {
                return HubTester.this.register();
            }
        };
        new CalcStorm(profile, this.random_, 10, 20, Calculator.RANDOM_MODE).run();
    }

    private void assertTestClients(HubConnection conn, String[] otherIds) throws IOException {
        HashSet<String> knownOtherIds = new HashSet<String>(Arrays.asList(conn.getRegisteredClients()));
        for (int ic = 0; ic < this.ignoreClients_.length; ++ic) {
            String id = this.ignoreClients_[ic].getId();
            knownOtherIds.remove(this.ignoreClients_[ic].getId());
        }
        HubTester.assertEquals(knownOtherIds, new HashSet<String>(Arrays.asList(otherIds)));
    }

    public Object createRandomObject(int level, boolean ugly) {
        if (level == 0) {
            return this.createRandomString(ugly);
        }
        int type = this.random_.nextInt(2);
        if (type == 0) {
            int nel = this.random_.nextInt(ugly ? 23 : 3);
            ArrayList<Object> list = new ArrayList<Object>(nel);
            for (int i = 0; i < nel; ++i) {
                list.add(this.createRandomObject(level - 1, ugly));
            }
            SampUtils.checkList(list);
            return list;
        }
        if (type == 1) {
            int nent = this.random_.nextInt(ugly ? 23 : 3);
            HashMap<String, Object> map = new HashMap<String, Object>(nent);
            for (int i = 0; i < nent; ++i) {
                map.put(this.createRandomString(ugly), this.createRandomObject(level - 1, ugly));
            }
            SampUtils.checkMap(map);
            return map;
        }
        throw new AssertionError();
    }

    public String createRandomString(boolean ugly) {
        int nchar = this.random_.nextInt(ugly ? 99 : 4);
        StringBuffer sbuf = new StringBuffer(nchar);
        char[] chrs = ugly ? GENERAL_CHARS : ALPHA_CHARS;
        for (int i = 0; i < nchar; ++i) {
            sbuf.append(chrs[this.random_.nextInt(chrs.length)]);
        }
        String str = sbuf.toString();
        SampUtils.checkString(str);
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void delay(int millis) {
        Object lock = new Object();
        try {
            Object object = lock;
            synchronized (object) {
                lock.wait(millis);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted", e);
        }
    }

    private static char[] createAlphaCharacters() {
        char c;
        StringBuffer sbuf = new StringBuffer();
        for (c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
            sbuf.append(c);
        }
        for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
            sbuf.append(c);
        }
        return sbuf.toString().toCharArray();
    }

    private static char[] createGeneralCharacters() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('\t');
        sbuf.append('\n');
        for (char c = ' '; c <= '\u007f'; c = (char)(c + '\u0001')) {
            sbuf.append(c);
        }
        return sbuf.toString().toCharArray();
    }

    public static void main(String[] args) throws IOException {
        int status = HubTester.runMain(args);
        if (status != 0) {
            System.exit(status);
        }
    }

    public static int runMain(String[] args) throws IOException {
        JFrame frame;
        String usage = "\n   Usage:" + "\n      " + HubTester.class.getName() + "\n           " + " [-help]" + " [-/+verbose]" + "\n           " + " [-gui]" + "\n";
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        boolean gui = false;
        int verbAdjust = 0;
        Iterator it = argList.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if (arg.equals("-gui")) {
                it.remove();
                gui = true;
                continue;
            }
            if (arg.equals("-nogui")) {
                it.remove();
                gui = false;
                continue;
            }
            if (arg.startsWith("-v")) {
                it.remove();
                --verbAdjust;
                continue;
            }
            if (arg.startsWith("+v")) {
                it.remove();
                ++verbAdjust;
                continue;
            }
            if (arg.startsWith("-h")) {
                it.remove();
                System.out.println(usage);
                return 0;
            }
            it.remove();
            System.err.println(usage);
            return 1;
        }
        if (!$assertionsDisabled && !argList.isEmpty()) {
            throw new AssertionError();
        }
        int logLevel = Level.WARNING.intValue() + 100 * verbAdjust;
        Logger.getLogger("org.astrogrid.samp").setLevel(Level.parse(Integer.toString(logLevel)));
        ClientProfile profile = DefaultClientProfile.getProfile();
        if (gui) {
            frame = new JFrame("HubTester Monitor");
            frame.getContentPane().add(new HubMonitor(profile, true, 1));
            frame.pack();
            frame.setVisible(true);
        } else {
            frame = null;
        }
        new HubTester(profile).run();
        if (frame != null) {
            frame.dispose();
        }
        return 0;
    }

    static {
        $assertionsDisabled = !HubTester.class.desiredAssertionStatus();
        ALPHA_CHARS = HubTester.createAlphaCharacters();
        GENERAL_CHARS = HubTester.createGeneralCharacters();
        logger_ = Logger.getLogger(HubTester.class.getName());
    }

    private static class WatchedClient {
        boolean reg_;
        boolean unreg_;
        Metadata meta_;
        Subscriptions subs_;

        private WatchedClient() {
        }
    }

    private static class ClientWatcher
    implements CallableClient {
        private final HubConnection connection_;
        private final Map clientMap_;
        private Throwable error_;

        ClientWatcher(HubConnection connection) {
            this.connection_ = connection;
            this.clientMap_ = Collections.synchronizedMap(new HashMap());
        }

        public WatchedClient getClient(String id) {
            return (WatchedClient)this.clientMap_.get(id);
        }

        public Throwable getError() {
            return this.error_;
        }

        public HubConnection getConnection() {
            return this.connection_;
        }

        public void receiveCall(String senderId, String msgId, Message msg) {
            this.receiveNotification(senderId, msg);
            Response response = this.error_ == null ? Response.createSuccessResponse(new HashMap()) : Response.createErrorResponse(new ErrInfo("broken"));
            try {
                this.connection_.reply(msgId, response);
            }
            catch (SampException e) {
                this.error_ = e;
            }
        }

        public void receiveNotification(String senderId, Message msg) {
            if (this.error_ == null) {
                try {
                    this.processMessage(senderId, msg);
                }
                catch (Throwable e) {
                    this.error_ = e;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processMessage(String senderId, Message msg) throws IOException {
            Tester.assertEquals(senderId, this.connection_.getRegInfo().getHubId());
            String mtype = msg.getMType();
            Map params = msg.getParams();
            String id = (String)msg.getParam("id");
            Tester.assertTrue(id != null);
            Map map = this.clientMap_;
            synchronized (map) {
                if (!this.clientMap_.containsKey(id)) {
                    this.clientMap_.put(id, new WatchedClient());
                }
                WatchedClient client = (WatchedClient)this.clientMap_.get(id);
                if (HubTester.REGISTER_MTYPE.equals(mtype)) {
                    Tester.assertTrue(!client.reg_);
                    client.reg_ = true;
                } else if (HubTester.UNREGISTER_MTYPE.equals(mtype)) {
                    Tester.assertTrue(!client.unreg_);
                    client.unreg_ = true;
                } else if (HubTester.METADATA_MTYPE.equals(mtype)) {
                    Tester.assertTrue(params.containsKey("metadata"));
                    Metadata meta = Metadata.asMetadata((Map)params.get("metadata"));
                    meta.check();
                    client.meta_ = meta;
                } else if (HubTester.SUBSCRIPTIONS_MTYPE.equals(mtype)) {
                    Tester.assertTrue(params.containsKey("subscriptions"));
                    Subscriptions subs = Subscriptions.asSubscriptions((Map)params.get("subscriptions"));
                    subs.check();
                    client.subs_ = subs;
                } else {
                    Tester.fail();
                }
                this.clientMap_.notifyAll();
            }
        }

        public void receiveResponse(String responderId, String msgTag, Response response) {
            throw new UnsupportedOperationException();
        }

        public static Subscriptions getSubscriptions() {
            Subscriptions subs = new Subscriptions();
            subs.addMType(HubTester.REGISTER_MTYPE);
            subs.addMType(HubTester.UNREGISTER_MTYPE);
            subs.addMType(HubTester.METADATA_MTYPE);
            subs.addMType(HubTester.SUBSCRIPTIONS_MTYPE);
            subs.check();
            return subs;
        }

        public static Metadata getMetadata() {
            Metadata meta = new Metadata();
            meta.setName("ClientWatcher");
            meta.setDescriptionText("Tracks other clients for HubTester");
            meta.check();
            return meta;
        }
    }

    private static class TestCallableClient
    extends ReplyCollector
    implements CallableClient {
        private final HubConnection connection_;
        private int pingCount_;
        public static final Subscriptions SUBS = TestCallableClient.getSubscriptions();

        TestCallableClient(HubConnection connection) {
            super(connection);
            this.connection_ = connection;
        }

        public void receiveNotification(String senderId, Message msg) {
            this.processCall(senderId, msg);
        }

        public void receiveCall(String senderId, String msgId, Message msg) throws SampException {
            Response response;
            int waitMillis;
            String swaitMillis = (String)msg.get(HubTester.WAITMILLIS_KEY);
            if (swaitMillis != null && (waitMillis = SampUtils.decodeInt(swaitMillis)) > 0) {
                HubTester.delay(waitMillis);
            }
            if (msg.getMType().equals(HubTester.FAIL_MTYPE)) {
                Map errs = (Map)msg.getParam(HubTester.ERROR_KEY);
                if (errs == null) {
                    throw new IllegalArgumentException();
                }
                response = Response.createErrorResponse(new ErrInfo(errs));
            } else {
                try {
                    response = Response.createSuccessResponse(this.processCall(senderId, msg));
                }
                catch (Throwable e) {
                    response = Response.createErrorResponse(new ErrInfo(e));
                }
            }
            String msgIdQuery = (String)msg.get(HubTester.MSGIDQUERY_KEY);
            if (msgIdQuery != null && SampUtils.decodeBoolean(msgIdQuery)) {
                response.put(HubTester.MSGIDQUERY_KEY, msgId);
            }
            response.check();
            this.connection_.reply(msgId, response);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map processCall(String senderId, Message msg) {
            String mtype = msg.getMType();
            if (HubTester.ECHO_MTYPE.equals(mtype)) {
                return msg.getParams();
            }
            if (HubTester.PING_MTYPE.equals(mtype)) {
                TestCallableClient testCallableClient = this;
                synchronized (testCallableClient) {
                    ++this.pingCount_;
                }
                return new HashMap();
            }
            throw new TestException("Unsubscribed MType? " + mtype);
        }

        private static Subscriptions getSubscriptions() {
            Subscriptions subs = new Subscriptions();
            subs.addMType(HubTester.ECHO_MTYPE);
            subs.addMType(HubTester.PING_MTYPE);
            subs.addMType(HubTester.FAIL_MTYPE);
            subs.check();
            return subs;
        }
    }
}

