/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.daq.ims.Camera;
import org.lsst.ccs.daq.ims.Catalog;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.daq.ims.ImageListener;
import org.lsst.ccs.daq.ims.ImageMetaData;
import org.lsst.ccs.daq.ims.Source;
import org.lsst.ccs.daq.ims.SourceMetaData;
import org.lsst.ccs.daq.ims.StoreImplementation;
import org.lsst.ccs.daq.ims.StoreNativeImplementation;
import org.lsst.ccs.daq.ims.StoreSimulatedImplementation;
import org.lsst.ccs.daq.ims.StreamListener;
import org.lsst.ccs.daq.ims.Version;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.location.LocationSet;

public class Store
implements AutoCloseable {
    private final Camera camera;
    private final Catalog catalog;
    private final String partition;
    private final long store;
    private final List<ImageListener> imageListeners = new CopyOnWriteArrayList<ImageListener>();
    private final Map<Long, Map<Integer, List<StreamListener>>> imageStreamMap = new ConcurrentHashMap<Long, Map<Integer, List<StreamListener>>>();
    private static final Logger LOG = Logger.getLogger(Store.class.getName());
    private static final int IMAGE_TIMEOUT_MICROS = 0;
    private static final int SOURCE_TIMEOUT_MICROS = 10000000;
    private static final StoreImplementation impl;
    private final ExecutorService executor;
    private Future<?> waitForImageTask;

    public Store(String partition) throws DAQException {
        this(partition, ForkJoinPool.commonPool());
    }

    public Store(String partition, ExecutorService executor) throws DAQException {
        this.partition = partition;
        this.executor = executor;
        this.catalog = new Catalog(this);
        this.camera = new Camera(this);
        this.store = impl.attachStore(partition);
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public String getPartition() {
        return this.partition;
    }

    public long getCapacity() throws DAQException {
        return impl.capacity(this.store);
    }

    public long getRemaining() throws DAQException {
        return impl.remaining(this.store);
    }

    public LocationSet getConfiguredSources() throws DAQException {
        BitSet locations = impl.getConfiguredSources(this.store);
        return new LocationSet(locations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImageListener(ImageListener l) {
        this.imageListeners.add(l);
        Store store = this;
        synchronized (store) {
            if (this.waitForImageTask == null || this.waitForImageTask.isCancelled() || this.waitForImageTask.isDone()) {
                this.waitForImageTask = this.executor.submit(() -> {
                    try {
                        Thread.currentThread().setName("ImageStreamThread_" + this.partition);
                        long waitForImageStore = impl.attachStore(this.partition);
                        try {
                            while (!Thread.currentThread().isInterrupted()) {
                                int rc = impl.waitForImage(this, waitForImageStore, 0, 10000000);
                                if (rc == 0 || rc == 68) continue;
                                LOG.log(Level.SEVERE, "Unexpected rc from waitForImage: {0}", rc);
                            }
                        }
                        finally {
                            impl.detachStore(this.store);
                        }
                    }
                    catch (Throwable x) {
                        LOG.log(Level.SEVERE, x, () -> String.format("Thread %s exiting", Thread.currentThread().getName()));
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImageListener(ImageListener l) {
        Store store = this;
        synchronized (store) {
            if (this.imageListeners.remove(l) && this.imageListeners.isEmpty()) {
                this.waitForImageTask.cancel(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void imageCreatedCallback(ImageMetaData meta) {
        Image image = new Image(this, meta);
        LOG.log(Level.INFO, "Image created: {0}", image);
        Map<Long, Map<Integer, List<StreamListener>>> map = this.imageStreamMap;
        synchronized (map) {
            this.imageStreamMap.put(image.getMetaData().getId(), new ConcurrentHashMap());
        }
        this.imageListeners.forEach(l -> l.imageCreated(image));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void imageCompleteCallback(ImageMetaData meta) {
        Map<Integer, List<StreamListener>> streamListeners;
        Image image = new Image(this, meta);
        LOG.log(Level.INFO, "Image complete: {0}", image);
        Map<Long, Map<Integer, List<StreamListener>>> map = this.imageStreamMap;
        synchronized (map) {
            streamListeners = this.imageStreamMap.remove(image.getMetaData().getId());
        }
        streamListeners.forEach((locationIndex, listeners) -> {
            try {
                SourceMetaData sourceMeta = this.findSource(meta.getId(), (int)locationIndex);
                listeners.forEach(l -> l.imageComplete(sourceMeta.getLength()));
            }
            catch (DAQException ex) {
                LOG.log(Level.SEVERE, "Exception during image complete callback", ex);
            }
        });
        this.imageListeners.forEach(l -> l.imageComplete(image));
    }

    void imageSourceStreamCallback(long imageId, int location, long length) {
        List<StreamListener> listeners;
        LOG.log(Level.FINE, "Image stream: imageId={0} location={1} length={2}", new Object[]{imageId, location, length});
        Map<Integer, List<StreamListener>> streamListeners = this.imageStreamMap.get(imageId);
        if (streamListeners != null && (listeners = streamListeners.get(location)) != null) {
            listeners.forEach(l -> l.streamLength(length));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addStreamListener(long imageId, int location, StreamListener listener) {
        Map<Integer, List<StreamListener>> streamListeners;
        Map<Long, Map<Integer, List<StreamListener>>> map = this.imageStreamMap;
        synchronized (map) {
            streamListeners = this.imageStreamMap.get(imageId);
        }
        if (streamListeners == null) {
            try {
                SourceMetaData sourceMeta = this.findSource(imageId, location);
                listener.imageComplete(sourceMeta.getLength());
            }
            catch (DAQException ex) {
                LOG.log(Level.SEVERE, "Unexpected exception while adding stream listener", ex);
            }
        } else {
            List<StreamListener> listeners = streamListeners.get(location);
            if (listeners == null) {
                listeners = new CopyOnWriteArrayList<StreamListener>();
                streamListeners.put(location, listeners);
            }
            listeners.add(listener);
        }
    }

    void removeStreamListener(long imageId, int location, StreamListener listener) {
        List<StreamListener> listeners;
        Map<Integer, List<StreamListener>> streamListeners = this.imageStreamMap.get(imageId);
        if (streamListeners != null && (listeners = streamListeners.get(location)) != null) {
            listeners.remove(listener);
        }
    }

    @Override
    public void close() throws DAQException {
        if (this.waitForImageTask != null && !this.waitForImageTask.isDone()) {
            this.waitForImageTask.cancel(true);
        }
        impl.detachStore(this.store);
    }

    List<String> listFolders() throws DAQException {
        ArrayList<String> result = new ArrayList<String>();
        impl.listFolders(this.store, result);
        return result;
    }

    int insertFolder(String folderName) throws DAQException {
        return impl.insertFolder(this.store, folderName);
    }

    int removeFolder(String folderName) throws DAQException {
        return impl.removeFolder(this.store, folderName);
    }

    boolean findFolder(String folderName) throws DAQException {
        return impl.findFolder(this.store, folderName);
    }

    void listImages(String folderName, List<ImageMetaData> result) throws DAQException {
        impl.listImages(this.store, folderName, result);
    }

    int moveImageToFolder(long id, String folderName) throws DAQException {
        return impl.moveImageToFolder(this.store, id, folderName);
    }

    int deleteImage(long id) throws DAQException {
        return impl.deleteImage(this.store, id);
    }

    SourceMetaData findSource(long id, int location) throws DAQException {
        return impl.findSource(this.store, id, location);
    }

    ImageMetaData addImageToFolder(String imageName, String folderName, ImageMetaData meta) throws DAQException {
        return impl.addImageToFolder(this.store, imageName, folderName, meta.getAnnotation(), meta.getOpcode(), meta.getLocationBitSet());
    }

    ImageMetaData findImage(String imageName, String folderName) throws DAQException {
        return impl.findImage(this.store, imageName, folderName);
    }

    long openSourceChannel(long id, Location location, Source.ChannelMode mode) throws DAQException {
        return impl.openSourceChannel(this.store, id, location.index(), mode == Source.ChannelMode.WRITE);
    }

    SourceMetaData addSourceToImage(long id, Location location, int[] registerValues) throws DAQException {
        return impl.addSourceToImage(this.store, id, location.index(), (byte)location.type().getCCDCount(), "test-platform", registerValues);
    }

    ImageMetaData triggerImage(ImageMetaData meta, Map<Location.LocationType, int[]> registerLists) throws DAQException {
        return impl.triggerImage(this.store, meta, registerLists);
    }

    long startSequencer(int opcode) throws DAQException {
        return impl.startSequencer(this.store, opcode);
    }

    public static Version getClientVersion() throws DAQException {
        return impl.getClientVersion();
    }

    static String decodeException(int rc) {
        return impl.decodeException(rc);
    }

    static {
        LOG.log(Level.INFO, "runMode={0}", System.getProperty("org.lsst.ccs.run.mode"));
        impl = "simulation".equals(System.getProperty("org.lsst.ccs.run.mode")) ? new StoreSimulatedImplementation() : new StoreNativeImplementation();
    }
}

