/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui.jas;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.filter.AgentChannelsFilter;
import org.lsst.ccs.gconsole.plugins.monitor.SectionedTableView;
import org.lsst.ccs.gconsole.plugins.monitor.TabbedView;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.subsystem.common.ui.jas.ControlPanel;
import org.lsst.ccs.subsystem.common.ui.jas.PathMonitorFilter;
import org.lsst.ccs.subsystem.refrig.data.RefrigUtils;

public class CmprOptionalPage
implements OptionalPage {
    private static final String[] exclSections = new String[]{"RefrigState", "UpdatePeriod"};
    private final Map<String, ControlPanel> controls = new ConcurrentHashMap<String, ControlPanel>();
    private final Map<String, String> agentMap = new ConcurrentHashMap<String, String>();
    private final Map<String, String> assocAgentMap = new ConcurrentHashMap<String, String>();
    private final String agentProperty;
    private final String assocAgentProperty;
    private final Class controlClass;

    public CmprOptionalPage(String agentProperty, Class controlClass, String assocAgentProperty) {
        this.agentProperty = agentProperty;
        this.controlClass = controlClass;
        this.assocAgentProperty = assocAgentProperty;
    }

    public boolean isAutoOpen() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPage(AgentInfo agent) {
        if (agent == null) {
            return null;
        }
        if (agent.hasAgentProperty(this.agentProperty)) {
            return this.getPageName(agent.getName());
        }
        if (agent.hasAgentProperty(this.assocAgentProperty)) {
            String group = RefrigUtils.getGroupName(agent);
            String assocAgentName = agent.getName();
            CmprOptionalPage cmprOptionalPage = this;
            synchronized (cmprOptionalPage) {
                ControlPanel control;
                String agentName;
                if (this.assocAgentMap.put(group, assocAgentName) == null && (agentName = this.agentMap.get(group)) != null && (control = this.controls.get(this.getPageName(agentName))) != null) {
                    ArrayList<String> agents = new ArrayList<String>();
                    agents.addAll(Arrays.asList(agentName, assocAgentName));
                    control.getView().setFilter((AgentChannelsFilter)new PathMonitorFilter(agents, exclSections));
                }
            }
        }
        return null;
    }

    public boolean agentDisconnected(AgentInfo agent) {
        ControlPanel control = this.controls.get(this.getPageName(agent.getName()));
        if (control == null) {
            return true;
        }
        control.disableControlPanel();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JComponent open(AgentInfo agent, JComponent existingComponent) {
        String agentName = agent.getName();
        String pageName = this.getPageName(agentName);
        ControlPanel control = this.controls.get(pageName);
        if (control != null) {
            control.initControlPanel();
            return existingComponent;
        }
        try {
            control = (ControlPanel)this.controlClass.newInstance();
            this.controls.put(pageName, control);
        }
        catch (Exception e) {
            return null;
        }
        TabbedView view = new TabbedView();
        control.setView(view);
        view.setViewFactory(name -> new SectionedTableView());
        String group = RefrigUtils.getGroupName(agent);
        CmprOptionalPage cmprOptionalPage = this;
        synchronized (cmprOptionalPage) {
            this.agentMap.put(group, agentName);
            ArrayList<String> agents = new ArrayList<String>();
            agents.add(agentName);
            String assocAgentName = this.assocAgentMap.get(group);
            if (assocAgentName != null) {
                agents.add(assocAgentName);
            }
            view.setFilter((AgentChannelsFilter)new PathMonitorFilter(agents, exclSections));
        }
        view.install();
        JPanel cPanel = control.getControlPanel(agentName);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)view.getPanel(), "Center");
        panel.add((Component)cPanel, "South");
        AgentMessagingLayer aml = Console.getConsole().getMessagingAccess();
        aml.addStatusMessageListener(control.getListener(), msg -> msg.getOriginAgentInfo().getName().equals(agentName) && msg instanceof StatusSubsystemData);
        control.initControlPanel();
        return panel;
    }

    public void closed(String pageName) {
        ControlPanel control = this.controls.remove(pageName);
        if (control == null) {
            throw new RuntimeException("No page exists with the name " + pageName);
        }
        Console.getConsole().getMessagingAccess().removeStatusMessageListener(control.getListener());
    }

    private String getPageName(String agentName) {
        return "CCS Subsystems/" + agentName + "/" + agentName;
    }
}

