/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class CarouselStatusPanel
extends JPanel {
    public static final String title = "Carousel Protection Status";
    private static final long serialVersionUID = 1L;
    private final DigitalSwitch carousel_CFC_Switch = new DigitalSwitch();
    private final DigitalSwitch carousel_CS_Switch = new DigitalSwitch();
    private final DigitalSwitch carousel_CF0_Switch = new DigitalSwitch();
    private final DigitalSwitch carousel_CF1_Switch = new DigitalSwitch();

    public CarouselStatusPanel() {
        this.initComponents();
    }

    public void updateAutochanger(StatusDataPublishedByAutoChanger s) {
        SwingUtilities.invokeLater(new UpdateAutochanger(s));
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createLineBorder(Color.MAGENTA, 6));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = Tools.insets_std;
        gbc.anchor = 17;
        this.add((Component)new JLabel("Carousel_CFC (filter clamped)"), gbc);
        ++gbc.gridy;
        this.add((Component)new JLabel("Carousel_CS (socket stop at Standby)"), gbc);
        ++gbc.gridy;
        this.add((Component)new JLabel("Carousel_CF0 (no filter)"), gbc);
        ++gbc.gridy;
        this.add((Component)new JLabel("Carousel_CF1 (filter on socket)"), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 13;
        this.add((Component)this.carousel_CFC_Switch, gbc);
        ++gbc.gridy;
        this.add((Component)this.carousel_CS_Switch, gbc);
        ++gbc.gridy;
        this.add((Component)this.carousel_CF0_Switch, gbc);
        ++gbc.gridy;
        this.add((Component)this.carousel_CF1_Switch, gbc);
        this.setDefaultValues();
    }

    private void setDefaultValues() {
        this.carousel_CFC_Switch.setColor(Color.GRAY);
        this.carousel_CS_Switch.setColor(Color.GRAY);
        this.carousel_CF0_Switch.setColor(Color.GRAY);
        this.carousel_CF1_Switch.setColor(Color.GRAY);
    }

    @Override
    public String toString() {
        return title;
    }

    public static void main(String[] argv) {
        CarouselStatusPanel d = new CarouselStatusPanel();
        JFrame frame = new JFrame("Carousel Status Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class UpdateAutochanger
    implements Runnable {
        private StatusDataPublishedByAutoChanger s;

        public UpdateAutochanger(StatusDataPublishedByAutoChanger status) {
            this.s = status;
        }

        @Override
        public void run() {
            CarouselStatusPanel.this.carousel_CFC_Switch.updateColor(this.s.isCarouselHoldingFilterInError(), this.s.isCarouselHoldingFilter());
            CarouselStatusPanel.this.carousel_CS_Switch.updateColor(this.s.isCarousel_CS_InError(), this.s.isCarousel_CS());
            CarouselStatusPanel.this.carousel_CF0_Switch.updateColor(this.s.isCarousel_CF0_InError(), this.s.isCarousel_CF0());
            CarouselStatusPanel.this.carousel_CF1_Switch.updateColor(this.s.isCarousel_CF1_InError(), this.s.isCarousel_CF1());
        }
    }
}

