/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims.example;

import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.daq.ims.DAQDriverStats;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.DAQFirmwareStats;
import org.lsst.ccs.daq.ims.DAQRdsStats;
import org.lsst.ccs.daq.ims.DAQRmsStats;
import org.lsst.ccs.daq.ims.Stats;
import org.lsst.ccs.utilities.location.Location;

public class TestStats {
    private Stats stats;
    private static final Logger LOG = Logger.getLogger(TestStats.class.getName());

    @Command(name="timestamp", description="Prints current time")
    public String timestamp() {
        Date now = new Date();
        return now.toString();
    }

    @Command(name="connect", description="Open connection to DAQ partition")
    public void connect(@Argument(name="partition", description="DAQ partition") String partition) throws DAQException {
        if (this.stats != null) {
            this.stats.close();
        }
        this.stats = new Stats(partition);
    }

    @Command(name="close", description="Closes connection to DAQ partition")
    public void close() throws DAQException {
        if (this.stats != null) {
            this.stats.close();
            this.stats = null;
        }
    }

    private String makeStatsTable(String sname, Map<String, Long> statMap, String location) {
        Set<String> keys = statMap.keySet();
        String table = "DAQ " + sname + " Stats for " + location + "\n" + this.timestamp() + "\n";
        for (String key : keys) {
            table = table + String.format("\n  %-22s %d", key, statMap.get(key));
        }
        table = table + "\n";
        return table;
    }

    @Command(name="readAllStats", description="Read all sets of DAQ stats")
    public String readAllStats(@Argument(name="location", description="readout board in format R<nn>Reb<m>") String location) throws DAQException {
        return "\n" + this.readAllRms(location) + "\n" + this.readAllRds(location) + "\n" + this.readAllDriver(location) + "\n" + this.readAllFirmware(location) + "\n";
    }

    @Command(name="clearAllStats", description="Read and clear all sets of DAQ stats")
    public String clearAllStats(@Argument(name="location", description="clearout board in format R<nn>Reb<m>") String location) throws DAQException {
        return "\n" + this.clearAllRms(location) + "\n" + this.clearAllRds(location) + "\n" + this.clearAllDriver(location) + "\n" + this.clearAllFirmware(location) + "\n";
    }

    @Command(name="readAllRms", description="Read all DAQ Rms stats")
    public String readAllRms(@Argument(name="location", description="readout board in format R<nn>Reb<m>") String location) throws DAQException {
        DAQRmsStats rmsStats = this.stats.getDAQRmsStats(Location.of((String)location), Stats.Clear.NO);
        Map<String, Long> statMap = rmsStats.getMap();
        return this.makeStatsTable("Rms", statMap, location);
    }

    @Command(name="readAllRds", description="Read all DAQ Rds stats")
    public String readAllRds(@Argument(name="location", description="readout board in format R<nn>Reb<m>") String location) throws DAQException {
        DAQRdsStats rdsStats = this.stats.getDAQRdsStats(Location.of((String)location), Stats.Clear.NO);
        Map<String, Long> statMap = rdsStats.getMap();
        return this.makeStatsTable("Rds", statMap, location);
    }

    @Command(name="readAllDriver", description="Read all DAQ Driver stats")
    public String readAllDriver(@Argument(name="location", description="readout board in format R<nn>Reb<m>") String location) throws DAQException {
        DAQDriverStats driverStats = this.stats.getDAQDriverStats(Location.of((String)location), Stats.Clear.NO);
        Map<String, Long> statMap = driverStats.getMap();
        return this.makeStatsTable("Driver", statMap, location);
    }

    @Command(name="readAllFirmware", description="Read all DAQ Firmware stats")
    public String readAllFirmware(@Argument(name="location", description="readout board in format R<nn>Reb<m>") String location) throws DAQException {
        DAQFirmwareStats firmwareStats = this.stats.getDAQFirmwareStats(Location.of((String)location), Stats.Clear.NO);
        Map<String, Long> statMap = firmwareStats.getMap();
        return this.makeStatsTable("Firmware", statMap, location);
    }

    @Command(name="clearAllRms", description="Read and clear DAQ Rms stats")
    public String clearAllRms(@Argument(name="location", description="readout board in format R<nn>Reb<m>") String location) throws DAQException {
        DAQRmsStats rmsStats = this.stats.getDAQRmsStats(Location.of((String)location), Stats.Clear.YES);
        Map<String, Long> statMap = rmsStats.getMap();
        return this.makeStatsTable("Rms", statMap, location) + "Cleared";
    }

    @Command(name="clearAllRds", description="Read and clear DAQ Rds stats")
    public String clearAllRds(@Argument(name="location", description="readout board in format R<nn>Reb<m>") String location) throws DAQException {
        DAQRdsStats rdsStats = this.stats.getDAQRdsStats(Location.of((String)location), Stats.Clear.YES);
        Map<String, Long> statMap = rdsStats.getMap();
        return this.makeStatsTable("Rds", statMap, location) + "Cleared";
    }

    @Command(name="clearAllDriver", description="Read and clear DAQ Driver stats")
    public String clearAllDriver(@Argument(name="location", description="readout board in format R<nn>Reb<m>") String location) throws DAQException {
        DAQDriverStats driverStats = this.stats.getDAQDriverStats(Location.of((String)location), Stats.Clear.YES);
        Map<String, Long> statMap = driverStats.getMap();
        return this.makeStatsTable("Driver", statMap, location) + "Cleared";
    }

    @Command(name="clearAllFirmware", description="Read and clear DAQ Firmware stats")
    public String clearAllFirmware(@Argument(name="location", description="readout board in format R<nn>Reb<m>") String location) throws DAQException {
        DAQFirmwareStats firmwareStats = this.stats.getDAQFirmwareStats(Location.of((String)location), Stats.Clear.YES);
        Map<String, Long> statMap = firmwareStats.getMap();
        return this.makeStatsTable("Firmware", statMap, location) + "Cleared";
    }

    @Command(name="readRmsStat", description="read specified DAQ Rms statistic for specified locaation")
    public String readRmsStat(@Argument(name="location", description="readout board in format R<nn>Reb<m>") String location, @Argument(name="statistic name") String quantity) throws DAQException {
        DAQRmsStats rmsStats = this.stats.getDAQRmsStats(Location.of((String)location), Stats.Clear.NO);
        return rmsStats.getStatistic(quantity).toString();
    }

    @Command(name="readRdsStat", description="read specified DAQ Rds statistic for specified locaation")
    public String readRdsStat(@Argument(name="location", description="readout board in format R<nn>Reb<m>") String location, @Argument(name="statistic name") String quantity) throws DAQException {
        DAQRdsStats rdsStats = this.stats.getDAQRdsStats(Location.of((String)location), Stats.Clear.NO);
        return rdsStats.getStatistic(quantity).toString();
    }

    @Command(name="readDriverStat", description="read specified DAQ Driver statistic for specified locaation")
    public String readDriverStat(@Argument(name="location", description="readout board in format R<nn>Reb<m>") String location, @Argument(name="statistic name") String quantity) throws DAQException {
        DAQDriverStats driverStats = this.stats.getDAQDriverStats(Location.of((String)location), Stats.Clear.NO);
        return driverStats.getStatistic(quantity).toString();
    }

    @Command(name="readFirmwareStat", description="read specified DAQ Firmware statistic for specified locaation")
    public String readFirmwareStat(@Argument(name="location", description="readout board in format R<nn>Reb<m>") String location, @Argument(name="statistic name") String quantity) throws DAQException {
        DAQFirmwareStats firmwareStats = this.stats.getDAQFirmwareStats(Location.of((String)location), Stats.Clear.NO);
        return firmwareStats.getStatistic(quantity).toString();
    }
}

