/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.tracer.filters;

import org.lsst.ccs.gconsole.plugins.tracer.FilteredMessage;
import org.lsst.ccs.gconsole.plugins.tracer.MessageFilter;
import org.lsst.ccs.gconsole.plugins.tracer.MessageFilterFactory;
import org.lsst.ccs.gconsole.plugins.tracer.filters.AbstractMessageFilter;

public class HeartBeatSelector
implements MessageFilterFactory {
    @Override
    public String getDescription() {
        return "Filter that rejects heartbeat status messages.<p>";
    }

    @Override
    public String getPath() {
        return "BuiltIn/Remove HeartBeat";
    }

    @Override
    public String getName() {
        return "HeartBeat Remover";
    }

    @Override
    public MessageFilter get(String[] parameters) {
        return new Filter();
    }

    public MessageFilter getInstance() {
        return new Filter();
    }

    private class Filter
    extends AbstractMessageFilter {
        private Filter() {
        }

        @Override
        public FilteredMessage test(FilteredMessage filteredMessage) {
            boolean isHeartBeat = filteredMessage.getBusMessage().getClass().getName().contains("StatusHeartBeat");
            return isHeartBeat ? null : filteredMessage;
        }

        @Override
        public String getDescription() {
            return HeartBeatSelector.this.getDescription();
        }

        @Override
        public String getPath() {
            return HeartBeatSelector.this.getPath();
        }

        @Override
        public String getName() {
            return HeartBeatSelector.this.getName();
        }
    }
}

