/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.zip.GZIPOutputStream;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ChecksumUtils;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.StatusDataProviderDictionary;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.framework.TreeWalkerUtils;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.services.AgentCommandDictionaryService;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.services.DataProviderDictionaryImpl;
import org.lsst.ccs.services.HasDataProviderInfos;
import org.lsst.ccs.utilities.logging.Logger;

public final class DataProviderDictionaryService
implements ServiceLifecycle,
HasLifecycle,
AgentService {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.services");
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentCommandDictionaryService agentCommandDictionaryService;
    private final List<DataProviderDictionaryListener> listeners = new CopyOnWriteArrayList<DataProviderDictionaryListener>();
    private ClientSideDataProviderDictionaryBookkeeper bookkeeper;
    private final ConcurrentHashMap<AgentInfo, DataProviderDictionary> agentDictionaries = new ConcurrentHashMap();
    private final DataProviderDictionaryImpl dataProviderDictionary = new DataProviderDictionaryImpl();
    private byte[] serializedDataProviderDictionary;
    private final DataProviderDictionaryCommands dictionaryCommands = new DataProviderDictionaryCommands();
    private final AgentPresenceListener dictionaryServiceAgentPresenceManager = new DictionaryServiceAgentPresenceListener();
    private volatile boolean canAddToDictionary = true;
    private long dictionaryChecksum = -1L;
    private String compressionProtocol = "none";

    @Override
    public String getAgentServiceName() {
        return "dataProviderDictionaryService";
    }

    @Override
    public boolean startForAgent(AgentInfo agentInfo) {
        return agentInfo.isGraphicalConsole() || agentInfo.isAgentWorkerOrService();
    }

    @Override
    public void init() {
        this.agentCommandDictionaryService.addCommandSetToObject(this.dictionaryCommands, this.agent);
    }

    private static boolean needsDataProviderDictionary(AgentInfo agentInfo) {
        return agentInfo.getType().compareTo((Enum)AgentInfo.AgentType.SERVICE) >= 0 || agentInfo.isGraphicalConsole();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void afterInit() {
        void var3_10;
        TreeWalkerUtils.proceduralWalk(this.agent.getComponentLookup(), null, HasDataProviderInfos.class, hasDataProviderInfos -> {
            List<DataProviderInfo> sortedList = hasDataProviderInfos.getDataProviderInfos();
            for (DataProviderInfo dataProviderInfo : sortedList) {
                ComponentNode node = this.agent.getComponentLookup().getNodeByPath(dataProviderInfo.getPath());
                if (node == null) {
                    log.warn((Object)("No component is linked to path " + dataProviderInfo.getPath()));
                }
                while (node != null) {
                    this.dataProviderDictionary.addDataProviderDescriptionToGroup(dataProviderInfo, node.getPath());
                    node = node.getParent();
                }
            }
        }, null);
        HashMap<String, ArrayList<DataProviderInfo>> pathOfConfigurationsWithoutUnitsMap = new HashMap<String, ArrayList<DataProviderInfo>>();
        for (DataProviderInfo dataProviderInfo : this.dataProviderDictionary.getDataProviderInfos()) {
            String dataTypeAttr = dataProviderInfo.getAttributeValue(DataProviderInfo.Attribute.DATA_TYPE);
            if (dataTypeAttr == null || !dataTypeAttr.equals(DataProviderInfo.Type.CONFIGURATION.name()) || dataProviderInfo.getAttributeValue(DataProviderInfo.Attribute.UNITS) != null) continue;
            ArrayList<DataProviderInfo> configs = (ArrayList<DataProviderInfo>)pathOfConfigurationsWithoutUnitsMap.get(dataProviderInfo.getPath());
            if (configs == null) {
                configs = new ArrayList<DataProviderInfo>();
                pathOfConfigurationsWithoutUnitsMap.put(dataProviderInfo.getPath(), configs);
            }
            configs.add(dataProviderInfo);
        }
        for (Map.Entry entry : pathOfConfigurationsWithoutUnitsMap.entrySet()) {
            String path = (String)entry.getKey();
            DataProviderInfo monitoringChannel = null;
            for (DataProviderInfo info : this.dataProviderDictionary.getDataProviderInfos()) {
                String dataTypeAttr = info.getAttributeValue(DataProviderInfo.Attribute.DATA_TYPE);
                if (dataTypeAttr == null || !dataTypeAttr.equals(DataProviderInfo.Type.MONITORING.name()) && !dataTypeAttr.equals(DataProviderInfo.Type.TRENDING.name()) || !info.getPath().equals(path)) continue;
                monitoringChannel = info;
                break;
            }
            if (monitoringChannel == null || monitoringChannel.getAttributeValue(DataProviderInfo.Attribute.UNITS) == null) continue;
            for (DataProviderInfo configPar : (List)entry.getValue()) {
                configPar.addAttribute(DataProviderInfo.Attribute.UNITS, monitoringChannel.getAttributeValue(DataProviderInfo.Attribute.UNITS));
            }
        }
        this.canAddToDictionary = false;
        this.dictionaryChecksum = ChecksumUtils.evaluateChecksum(this.dataProviderDictionary);
        AgentInfo agentInfo = this.agent.getAgentInfo();
        agentInfo.getAgentProperties().setProperty(this.getClass().getSimpleName() + ":checksum", String.valueOf(this.dictionaryChecksum));
        Object var3_6 = null;
        if (agentInfo.isGraphicalConsole()) {
            String string = "console";
        } else if (agentInfo.isScriptingConsole()) {
            String string = "scripting";
        } else if (agentInfo.getType() == AgentInfo.AgentType.CONSOLE) {
            String string = "shell";
        }
        if (var3_10 != null) {
            agentInfo.getAgentProperties().setProperty(this.getClass().getSimpleName() + ":type", (String)var3_10);
        }
        this.compressionProtocol = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.compress.dictionary", "none").toLowerCase();
        if (!this.compressionProtocol.equals("none") && !this.compressionProtocol.equals("gzip")) {
            throw new RuntimeException("Unknown compression protocol: " + this.compressionProtocol);
        }
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             GZIPOutputStream gzipOut = this.compressionProtocol.equals("gzip") ? new GZIPOutputStream(bos) : null;){
            ObjectOutputStream oos = new ObjectOutputStream(this.compressionProtocol.equals("gzip") ? gzipOut : bos);
            oos.writeObject(this.dataProviderDictionary);
            oos.flush();
            oos.close();
            this.serializedDataProviderDictionary = bos.toByteArray();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Problem serializing the dictionaries.", ioe);
        }
    }

    @Override
    public void preStart() {
        if (DataProviderDictionaryService.needsDataProviderDictionary(this.agent.getAgentInfo())) {
            this.bookkeeper = new ClientSideDataProviderDictionaryBookkeeper();
            this.agent.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this.bookkeeper, BusMessageFilterFactory.messageClass(StatusDataProviderDictionary.class));
            this.agent.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this.bookkeeper);
        }
    }

    public long getDictionaryChecksum() {
        return this.dictionaryChecksum;
    }

    @Override
    public void afterStart() {
        if (this.agent.getAgentInfo().isAgentWorkerOrService()) {
            this.agent.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener(this.dictionaryServiceAgentPresenceManager);
        }
    }

    @Override
    public void shutdown() {
        if (this.agent.getAgentInfo().isAgentWorkerOrService()) {
            this.agent.getMessagingAccess().getAgentPresenceManager().removeAgentPresenceListener(this.dictionaryServiceAgentPresenceManager);
        }
    }

    public void addDataProviderInfoToDictionary(DataProviderInfo info, String nodePath) {
        if (!this.canAddToDictionary) {
            throw new RuntimeException("Cannot add to DataProviderDictionary after the HasLifecycle::init phase");
        }
        this.dataProviderDictionary.addDataProviderDescriptionToGroup(info, nodePath);
    }

    public DataProviderDictionary getDataProviderDictionary() {
        return this.dataProviderDictionary;
    }

    public void addMetadataForDataGroup(KeyValueDataList data, String metadataName, String metadataValue, String dataGroupName) {
        data.addData(dataGroupName + "/" + metadataName, (Serializable)((Object)String.valueOf(metadataValue)), KeyValueData.KeyValueDataType.KeyValueMetaData);
    }

    public void addMetadataForObject(KeyValueDataList data, String metadataName, String metadataValue, Object origin) {
        ComponentNode n = this.agent.getComponentLookup().getComponentNodeForObject(origin);
        if (n == null) {
            throw new RuntimeException("Cannot publish metadata for an Object that is not in the lookup tree.");
        }
        this.addMetadataForDataGroup(data, metadataName, metadataValue, n.getPath());
    }

    public void publishMetadataForDataGroup(String metadataName, String metadataValue, String dataGroupName) {
        if (this.agent.isConnectedToTheBuses()) {
            if (dataGroupName == null) {
                dataGroupName = "";
            }
            if (!this.dataProviderDictionary.getGroups().contains(dataGroupName)) {
                throw new IllegalArgumentException("Group: " + dataGroupName + " does not exist");
            }
            KeyValueDataList data = new KeyValueDataList();
            this.addMetadataForDataGroup(data, metadataName, String.valueOf(metadataValue), dataGroupName);
            this.agent.publishSubsystemDataOnStatusBus((KeyValueData)data);
        }
    }

    public void publishMetadataForObject(String metadataName, String metadataValue, Object origin) {
        ComponentNode n = this.agent.getComponentLookup().getComponentNodeForObject(origin);
        if (n == null) {
            throw new RuntimeException("Cannot publish metadata for an Object that is not in the lookup tree.");
        }
        this.publishMetadataForDataGroup(metadataName, metadataValue, n.getPath());
    }

    public void purge(AgentInfo agent) {
        this.agentDictionaries.remove(agent);
    }

    public void purge() {
        this.agentDictionaries.clear();
    }

    public void registerData(KeyValueData kvd) {
        StatusSubsystemData ssd = new StatusSubsystemData(kvd);
        KeyValueDataList list = ssd.getEncodedData();
        for (KeyValueData d : list) {
            this.doTheRegistration(d);
        }
    }

    private void doTheRegistration(KeyValueData kvd) {
        DataProviderInfo info = new DataProviderInfo(kvd.getKey(), DataProviderInfo.Type.TRENDING, kvd.getKey());
        this.dataProviderDictionary.addDataProviderDescriptionToGroup(info, info.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataProviderDictionaryListener(DataProviderDictionaryListener listener) {
        ConcurrentHashMap<AgentInfo, DataProviderDictionary> concurrentHashMap = this.agentDictionaries;
        synchronized (concurrentHashMap) {
            for (Map.Entry<AgentInfo, DataProviderDictionary> entry : this.agentDictionaries.entrySet()) {
                listener.dataProviderDictionaryUpdate(new DataProviderDictionaryEvent(entry.getKey(), DataProviderDictionaryEvent.EventType.ADDED, entry.getValue()));
            }
            this.listeners.add(listener);
        }
    }

    public void removeDataProviderDictionaryListener(DataProviderDictionaryListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyDataProviderDictionaryListeners(DataProviderDictionaryEvent evt) {
        for (DataProviderDictionaryListener listener : this.listeners) {
            listener.dataProviderDictionaryUpdate(evt);
        }
    }

    private class ClientSideDataProviderDictionaryBookkeeper
    implements StatusMessageListener,
    AgentPresenceListener {
        private ClientSideDataProviderDictionaryBookkeeper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disconnecting(AgentInfo agent) {
            ConcurrentHashMap concurrentHashMap = DataProviderDictionaryService.this.agentDictionaries;
            synchronized (concurrentHashMap) {
                DataProviderDictionary dict = (DataProviderDictionary)DataProviderDictionaryService.this.agentDictionaries.remove(agent);
                if (dict != null) {
                    DataProviderDictionaryService.this.notifyDataProviderDictionaryListeners(new DataProviderDictionaryEvent(agent, DataProviderDictionaryEvent.EventType.REMOVED, dict));
                }
            }
        }

        public void onStatusMessage(StatusMessage msg) {
            if (DataProviderDictionaryService.this.agent.getName().equals(msg.getOriginAgentInfo().getName())) {
                return;
            }
            AgentInfo agentInfo = msg.getOriginAgentInfo();
            this.addDataProviderDictionary(agentInfo, ((StatusDataProviderDictionary)msg).getDataProviderDictionary());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addDataProviderDictionary(AgentInfo agent, DataProviderDictionary dictionary) {
            ConcurrentHashMap concurrentHashMap = DataProviderDictionaryService.this.agentDictionaries;
            synchronized (concurrentHashMap) {
                if (!DataProviderDictionaryService.this.agentDictionaries.containsKey(agent)) {
                    DataProviderDictionaryService.this.agentDictionaries.put(agent, dictionary);
                    DataProviderDictionaryService.this.notifyDataProviderDictionaryListeners(new DataProviderDictionaryEvent(agent, DataProviderDictionaryEvent.EventType.ADDED, dictionary));
                }
            }
        }
    }

    public static class DataProviderDictionaryEvent {
        private final EventType eventType;
        private final AgentInfo agentInfo;
        private final DataProviderDictionary dictionary;

        DataProviderDictionaryEvent(AgentInfo agentInfo, EventType eventType, DataProviderDictionary dictionary) {
            this.eventType = eventType;
            this.agentInfo = agentInfo;
            this.dictionary = dictionary;
        }

        public EventType getEventType() {
            return this.eventType;
        }

        public AgentInfo getAgentInfo() {
            return this.agentInfo;
        }

        public DataProviderDictionary getDictionary() {
            return this.dictionary;
        }

        public static enum EventType {
            ADDED,
            REMOVED;

        }
    }

    public static interface DataProviderDictionaryListener {
        public void dataProviderDictionaryUpdate(DataProviderDictionaryEvent var1);
    }

    class DictionaryServiceAgentPresenceListener
    implements AgentPresenceListener {
        DictionaryServiceAgentPresenceListener() {
        }

        public void connected(AgentInfo ... agents) {
            for (AgentInfo info : agents) {
                if (!DataProviderDictionaryService.needsDataProviderDictionary(info)) continue;
                DataProviderDictionaryService.this.dictionaryCommands.publishDataProviderDictionary();
                return;
            }
        }
    }

    public class DataProviderDictionaryCommands {
        @Command(description="Publish on the status bus the Agent's dictionary of data.", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
        public void publishDataProviderDictionary() {
            if (DataProviderDictionaryService.this.serializedDataProviderDictionary == null) {
                throw new RuntimeException("The DataProviderInfo dictionary is not ready yet for publication");
            }
            DataProviderDictionaryService.this.agent.sendStatusMessage((StatusMessage)new StatusDataProviderDictionary(DataProviderDictionaryService.this.serializedDataProviderDictionary, DataProviderDictionaryService.this.compressionProtocol));
            this.publishDataProviderCurrentData();
        }

        @Command(description="Publish on the status bus the Agent's current data.", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
        public void publishDataProviderCurrentData() {
            TreeWalkerUtils.proceduralWalk(DataProviderDictionaryService.this.agent.getComponentLookup(), null, HasDataProviderInfos.class, hasDataProviderInfos -> hasDataProviderInfos.publishDataProviderCurrentData(), null);
        }

        @Command(description="Publish Metadata for a data group", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
        public void publishMetadataForDataGroup(@Argument(name="metadataName") String metadataName, @Argument(name="metadataValue") String metadataValue, @Argument(name="dataGroupName", defaultValue="") String dataGroupName) {
            DataProviderDictionaryService.this.publishMetadataForDataGroup(metadataName, metadataValue, dataGroupName);
        }

        @Command(description="Get the available data groups", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
        public Set<String> getAvailableDataGroups() {
            return DataProviderDictionaryService.this.dataProviderDictionary.getGroups();
        }

        @Command(description="Show the trending data in a group", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
        public List<DataProviderInfo> getDataInGroup(@Argument(name="dataGroupName", defaultValue="") String dataGroupName) {
            if (dataGroupName == null || dataGroupName.isEmpty()) {
                dataGroupName = "";
            }
            if (!DataProviderDictionaryService.this.dataProviderDictionary.getGroups().contains(dataGroupName)) {
                throw new IllegalArgumentException("Group: " + dataGroupName + " does not exist");
            }
            return DataProviderDictionaryService.this.dataProviderDictionary.getDataProviderDescriptionsForGroup(dataGroupName);
        }

        @Command(description="Show the trending data in a group", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
        public String printDataProviderDictionary() {
            StringBuilder sb = new StringBuilder();
            for (DataProviderInfo info : DataProviderDictionaryService.this.dataProviderDictionary.getDataProviderInfos()) {
                sb.append(info.toString()).append("\n");
            }
            return sb.toString();
        }
    }
}

