/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.metrology.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.time.Duration;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.NumberFormatter;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.subsystem.metrology.data.MetrologyConfig;

public class PointSetConfigurableSubsystemMainPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Map<String, MetrologyConfigurablePanel> panelMap = new TreeMap<String, MetrologyConfigurablePanel>();
    private static AgentMessagingLayer agentMessagingLayer;
    private final JLabel descriptionNameLbl = new JLabel();
    private static String metrology_dest;
    private static final Logger log;

    public PointSetConfigurableSubsystemMainPanel(AgentMessagingLayer aml, String DEST) {
        agentMessagingLayer = aml;
        metrology_dest = DEST;
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.descriptionNameLbl);
        for (MetrologyConfigurablePanel panel : panelMap.values()) {
            this.add(panel);
        }
    }

    public void updateWithConfigInfo(ConfigurationInfo configurationInfo) {
        log.info("updating config info");
        for (Map.Entry<String, MetrologyConfigurablePanel> entry : panelMap.entrySet()) {
            Map configForComponent = configurationInfo.getCurrentValuesFor(entry.getKey());
            log.info("updating for " + entry.getKey());
            if (configForComponent.isEmpty()) continue;
            entry.getValue().updateWithConfigInfo(configForComponent);
        }
        log.info("Done updating config info");
    }

    public void setDescriptionName(final String descriptionName) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PointSetConfigurableSubsystemMainPanel.this.descriptionNameLbl.setText(descriptionName);
            }
        });
    }

    static {
        metrology_dest = "metrology";
        log = Logger.getLogger("org.lsst.ccs.subsystem.metrology.ui.MetrologyGUI");
        for (MetrologyConfig.pointset_states componentState : MetrologyConfig.pointset_states.values()) {
            String componentName = componentState.name();
            panelMap.put(componentName, new MetrologyConfigurablePanel(componentName));
        }
    }

    private static class MetrologyConfigurablePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private final String componentName;
        private final NumberFormatter fmt5 = new NumberFormatter(new DecimalFormat("####0"));
        private final NumberFormatter fmt5d = new NumberFormatter(new DecimalFormat("###0.##"));
        private final NumberFormatter fmt5e = new NumberFormatter(new DecimalFormat("0.####E00"));
        private final JLabel stateLbl = new JLabel();
        private final JFormattedTextField PointXLbl = new JFormattedTextField(this.fmt5d);
        private final JFormattedTextField PointYLbl = new JFormattedTextField(this.fmt5d);
        private final JFormattedTextField PointZLbl = new JFormattedTextField(this.fmt5d);
        private static final JButton btsavechanges = new JButton("Save Changes");

        private MetrologyConfigurablePanel(final String componentName) {
            super(new GridBagLayout());
            this.componentName = componentName;
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), componentName));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.fill = 0;
            this.add((Component)new JLabel("X : "), gbc);
            ++gbc.gridy;
            this.add((Component)new JLabel("Y : "), gbc);
            ++gbc.gridy;
            this.add((Component)new JLabel("Z : "), gbc);
            gbc.gridy += 4;
            this.add((Component)btsavechanges, gbc);
            btsavechanges.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("Saving all changes");
                    this.sendSyncMetrologyCommand(null, "saveAllChanges", new Object[0]);
                }
            });
            Dimension d = this.PointXLbl.getPreferredSize();
            d.width = 100;
            d.height = 20;
            this.PointXLbl.setPreferredSize(d);
            this.PointYLbl.setPreferredSize(d);
            this.PointZLbl.setPreferredSize(d);
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            this.add((Component)this.PointXLbl, gbc);
            ++gbc.gridy;
            gbc.gridwidth = 1;
            this.add((Component)this.PointYLbl, gbc);
            ++gbc.gridy;
            gbc.gridwidth = 1;
            this.add((Component)this.PointZLbl, gbc);
            this.PointXLbl.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("changing PointX value");
                    this.sendSyncMetrologyCommand(componentName, "change", "PointX", PointXLbl.getText());
                }
            });
            this.PointYLbl.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("changing PointY value");
                    this.sendSyncMetrologyCommand(componentName, "change", "PointY", PointYLbl.getText());
                }
            });
            this.PointZLbl.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("changing PointZ value");
                    this.sendSyncMetrologyCommand(componentName, "change", "PointZ", PointZLbl.getText());
                }
            });
        }

        private void updateWithConfigInfo(final Map<String, String> configForComponent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PointXLbl.setText((String)configForComponent.get("PointX"));
                    PointYLbl.setText((String)configForComponent.get("PointY"));
                    PointZLbl.setText((String)configForComponent.get("PointZ"));
                }
            });
        }

        protected Object sendSyncMetrologyCommand(String target, String name, Object ... params) {
            String dest = target == null ? metrology_dest : metrology_dest + "/" + target;
            ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(agentMessagingLayer);
            CommandRequest cmd = new CommandRequest(dest, name, params);
            try {
                return cmu.sendSynchronousCommand(cmd, Duration.ofMillis(1440000L));
            }
            catch (Exception e) {
                log.warning("Unable to perform jgroup communication with destination " + dest + " - Exception " + e);
                return null;
            }
        }
    }
}

