/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.CommandState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class SubsystemPanel
extends JPanel {
    private static final long serialVersionUID = -5966882812912397723L;
    private static final String UNKNOWN = "UNKNOWN";
    private String title;
    private GeneralGUI subs;
    private final JPanel subsStatePanel = new JPanel();
    private final JPanel controlPanel = new JPanel();
    private final JLabel controlRealHardwareLabel = new JLabel("unknown hardware type");
    private final JLabel phLabel = new JLabel("PhaseState");
    private final JLabel opLabel = new JLabel("OperationalState");
    private final JLabel coLabel = new JLabel("CommandState");
    private final JLabel alLabel = new JLabel("AlertState");
    private final JLabel phaseStateLabel = new JLabel(PhaseState.OFF_LINE.toString());
    private final JLabel operationalStateLabel = new JLabel("UNKNOWN");
    private final JLabel commandStateLabel = new JLabel("UNKNOWN");
    private final JLabel alarmStateLabel = new JLabel("UNKNOWN");
    private final JPanel fcsStatePanel = new JPanel();
    private final JLabel subsystemFcsStateLabel = new JLabel("UNKNOWN");
    private final JLabel hardwareStateLabel = new JLabel("UNKNOWN");
    private final JButton updateStateWithSensorsButton = new JButton("updateStateWithSensors");
    private final JButton abortButton = new JButton("Abort");
    private final JButton shutdownButton = new JButton("Shutdown FCS");

    public SubsystemPanel(String title) {
        this.title = title;
        this.initComponents();
    }

    public void setSubsystem(GeneralGUI newSubs) {
        this.subs = newSubs;
        this.title = newSubs.destination;
    }

    public void setcontrolRealHardwareLabelText(String atext) {
        this.controlRealHardwareLabel.setText(atext);
    }

    public void initializeGui(ConfigurationInfo configInfo) {
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }

    public void updateState(StateBundle state) {
        SwingUtilities.invokeLater(new UpdateSubsystemPanel(state));
    }

    private void initComponents() {
        this.controlRealHardwareLabel.setFont(Tools.BIG_FONT);
        this.phaseStateLabel.setFont(Tools.BIG_FONT);
        this.operationalStateLabel.setFont(Tools.BIG_FONT);
        this.commandStateLabel.setFont(Tools.BIG_FONT);
        this.alarmStateLabel.setFont(Tools.BIG_FONT);
        this.subsStatePanel.setBackground(Color.GRAY);
        this.subsStatePanel.setPreferredSize(new Dimension(600, 50));
        this.subsStatePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc0 = new GridBagConstraints();
        gbc0.insets = Tools.insets_std;
        gbc0.anchor = 21;
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.anchor = 10;
        this.subsStatePanel.add((Component)this.phLabel, gbc0);
        ++gbc0.gridx;
        this.subsStatePanel.add((Component)this.opLabel, gbc0);
        ++gbc0.gridx;
        this.subsStatePanel.add((Component)this.coLabel, gbc0);
        ++gbc0.gridx;
        this.subsStatePanel.add((Component)this.alLabel, gbc0);
        gbc0.gridx = 0;
        gbc0.gridy = 1;
        this.subsStatePanel.add((Component)this.phaseStateLabel, gbc0);
        ++gbc0.gridx;
        this.subsStatePanel.add((Component)this.operationalStateLabel, gbc0);
        ++gbc0.gridx;
        this.subsStatePanel.add((Component)this.commandStateLabel, gbc0);
        ++gbc0.gridx;
        this.subsStatePanel.add((Component)this.alarmStateLabel, gbc0);
        this.updateStateWithSensorsButton.addActionListener(evt -> this.updateStateWithSensorsActionPerformed(evt));
        this.abortButton.addActionListener(evt -> this.abortActionPerformed(evt));
        this.shutdownButton.addActionListener(evt -> this.shutdownActionPerformed(evt));
        this.controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.anchor = 23;
        gbc1.fill = 2;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        this.controlPanel.add((Component)this.updateStateWithSensorsButton, gbc1);
        ++gbc1.gridy;
        this.controlPanel.add((Component)this.abortButton, gbc1);
        ++gbc1.gridy;
        this.controlPanel.add((Component)this.shutdownButton, gbc1);
        this.fcsStatePanel.setBorder(BorderFactory.createLineBorder(Color.ORANGE, 2));
        this.fcsStatePanel.setLayout(new GridBagLayout());
        this.fcsStatePanel.setFont(Tools.BIG_FONT);
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        gbc2.anchor = 21;
        this.fcsStatePanel.add((Component)new JLabel("FCS State :"), gbc2);
        ++gbc2.gridy;
        this.fcsStatePanel.add((Component)new JLabel("Hardware State :"), gbc2);
        gbc2.anchor = 22;
        gbc2.gridx = 1;
        gbc2.gridy = 0;
        this.subsystemFcsStateLabel.setFont(Tools.BIG_FONT);
        this.fcsStatePanel.add((Component)this.subsystemFcsStateLabel, gbc2);
        ++gbc2.gridy;
        this.hardwareStateLabel.setFont(Tools.BIG_FONT);
        this.fcsStatePanel.add((Component)this.hardwareStateLabel, gbc2);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(this.title));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        this.add((Component)this.subsStatePanel, gbc);
        gbc.gridwidth = 1;
        ++gbc.gridy;
        this.add((Component)this.controlRealHardwareLabel, gbc);
        ++gbc.gridx;
        gbc.anchor = 13;
        gbc.fill = 1;
        this.add((Component)this.fcsStatePanel, gbc);
        gbc.anchor = 18;
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        this.add((Component)this.controlPanel, gbc);
    }

    private void updateStateWithSensorsActionPerformed(ActionEvent evt) {
        this.subs.updateStateWithSensors();
    }

    private void abortActionPerformed(ActionEvent evt) {
        this.subs.abortAction();
    }

    private void shutdownActionPerformed(ActionEvent evt) {
        System.out.println("About to shutdown subs.....");
        this.subs.shutdownMyDestinationSubsystem();
    }

    public static void main(String[] argv) {
        SubsystemPanel d = new SubsystemPanel("FCS");
        JFrame frame = new JFrame("Subsystem Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class UpdateSubsystemPanel
    implements Runnable {
        private final StateBundle bState;

        public UpdateSubsystemPanel(StateBundle state) {
            this.bState = state;
        }

        @Override
        public void run() {
            SubsystemPanel.this.phaseStateLabel.setText(((PhaseState)this.bState.getState(PhaseState.class)).name());
            SubsystemPanel.this.operationalStateLabel.setText(((OperationalState)this.bState.getState(OperationalState.class)).name());
            SubsystemPanel.this.commandStateLabel.setText(((CommandState)this.bState.getState(CommandState.class)).name());
            SubsystemPanel.this.alarmStateLabel.setText(((AlertState)this.bState.getState(AlertState.class)).name());
            if (this.bState.getState(FcsEnumerations.FilterState.class) == null) {
                SubsystemPanel.this.subsystemFcsStateLabel.setText(SubsystemPanel.UNKNOWN);
                SubsystemPanel.this.hardwareStateLabel.setText(SubsystemPanel.UNKNOWN);
            } else {
                SubsystemPanel.this.subsystemFcsStateLabel.setText(((FcsEnumerations.FilterState)this.bState.getState(FcsEnumerations.FilterState.class)).name());
                SubsystemPanel.this.hardwareStateLabel.setText(((FcsEnumerations.FilterReadinessState)this.bState.getState(FcsEnumerations.FilterReadinessState.class)).name());
            }
            Color bgColor = Color.gray;
            if (this.bState.isInState((Enum)PhaseState.INITIALIZING)) {
                bgColor = Color.orange;
            } else if (this.bState.isInState((Enum)PhaseState.OFF_LINE)) {
                bgColor = Color.GRAY;
            } else if (this.bState.isInState((Enum)OperationalState.ENGINEERING_FAULT)) {
                bgColor = Color.RED;
            } else if (this.bState.isInState((Enum)OperationalState.ENGINEERING_OK)) {
                bgColor = Color.YELLOW;
            } else if (this.bState.isInState((Enum)CommandState.ACTIVE)) {
                bgColor = Color.BLUE;
            } else if (this.bState.isInState((Enum)PhaseState.OPERATIONAL) && this.bState.isInState((Enum)CommandState.READY) && this.bState.isInState((Enum)OperationalState.NORMAL) && this.bState.isInState((Enum)AlertState.NOMINAL)) {
                bgColor = Tools.greenColor;
            }
            SubsystemPanel.this.subsStatePanel.setBackground(bgColor);
            if (this.bState.isInState((Enum)FcsEnumerations.FilterState.HOMING_TO_BE_DONE)) {
                SubsystemPanel.this.subsystemFcsStateLabel.setForeground(Color.orange);
            } else if (this.bState.isInState((Enum)FcsEnumerations.FilterState.READY)) {
                SubsystemPanel.this.subsystemFcsStateLabel.setForeground(Tools.greenColor);
            } else if (this.bState.isInState((Enum)FcsEnumerations.FilterState.CAN_DEVICES_BOOTING)) {
                SubsystemPanel.this.subsystemFcsStateLabel.setForeground(Color.RED);
            } else {
                SubsystemPanel.this.subsystemFcsStateLabel.setForeground(Color.gray);
            }
            if (this.bState.isInState((Enum)FcsEnumerations.FilterReadinessState.READY)) {
                SubsystemPanel.this.hardwareStateLabel.setForeground(Tools.greenColor);
            } else if (this.bState.isInState((Enum)FcsEnumerations.FilterReadinessState.NOT_READY)) {
                SubsystemPanel.this.hardwareStateLabel.setForeground(Color.RED);
            } else {
                SubsystemPanel.this.hardwareStateLabel.setForeground(Color.GRAY);
            }
        }
    }

    private class GuiInitialization
    implements Runnable {
        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
        }
    }
}

