/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JPanel;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.ui.commons.CanOpenHardwareListPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.InterfaceGeneralGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public abstract class GatherPanel
extends JPanel
implements StatusMessageListener {
    protected static final Logger FCSLOG = Logger.getLogger(GatherPanel.class.getName());
    private static final long serialVersionUID = 3948843130488926276L;
    protected CanOpenHardwareListPanel canOpenHardwareListPanel;

    public GatherPanel(String tcpProxyName) {
        this.canOpenHardwareListPanel = new CanOpenHardwareListPanel(tcpProxyName);
        this.setName("gatherPanel");
    }

    public void setHardwareNames(List<String> hardwareNames) {
        FCSLOG.info("setHardwareNames with names=" + hardwareNames);
        this.canOpenHardwareListPanel.setHardwareNames(hardwareNames);
    }

    public CanOpenHardwareListPanel getCanOpenHardwareListPanel() {
        return this.canOpenHardwareListPanel;
    }

    public abstract void updateFromConfigurationInfo(ConfigurationInfo var1);

    public abstract void updateFromStatusData(KeyValueData var1);

    public void onStatusMessage(StatusMessage msg) {
        if (msg instanceof StatusConfigurationInfo) {
            FCSLOG.finer(this.getName() + " read data StatusConfigurationInfo");
            this.updateFromConfigurationInfo(((StatusConfigurationInfo)msg).getConfigurationInfo());
        } else {
            StatusSubsystemData d = (StatusSubsystemData)msg;
            KeyValueData data = (KeyValueData)d.getObject();
            FCSLOG.finer(this.getName() + " read data dataType:" + data.getKey());
            this.updateFromStatusData(data);
        }
    }

    public void updateCanOpenHardwarePanel(String deviceToUpdateName, StatusDataPublishedByHardware statusDataPublishedByHardware) {
        this.canOpenHardwareListPanel.updateCanOpenHardwarePanel(Tools.getShortComponentName(deviceToUpdateName), statusDataPublishedByHardware);
    }

    public void updateCanOpenHardwarePanel(int bootedNodesNb) {
        this.canOpenHardwareListPanel.updateCanOpenHardwarePanel(bootedNodesNb);
    }

    public void initializeGUIWithConfigInfo(ConfigurationInfo configInfo, List<String> hardwareList) {
        this.canOpenHardwareListPanel.initializeGui(configInfo, hardwareList);
    }

    public void initializeGUIWithLoaderConfigInfo(ConfigurationInfo configInfo, List<String> hardwareList) throws InterruptedException, InvocationTargetException {
    }

    public void initializeGUIWithFiltersInfo(ConfigurationInfo configInfo, List<String> filterNamesList) throws InterruptedException, InvocationTargetException {
    }

    public void initializeGUIWithControllersMap(Map<String, String> controllersMap) {
    }

    public void initializeGuiWithAutochangerSensorsList(ConfigurationInfo configInfo, List<String> sensorsList) {
    }

    public void initializeGuiWithLoaderSensorsList(ConfigurationInfo configInfo, List<String> sensorsList) {
    }

    public abstract InterfaceGeneralGUI getSubs();

    public boolean isMyHardware(String hardwareName) {
        FCSLOG.info("hardwareNameList" + hardwareName);
        return this.canOpenHardwareListPanel.getHardwareNames().contains(hardwareName);
    }

    public void resetPanel() {
        this.canOpenHardwareListPanel.resetPanel();
    }
}

