/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.ui.commons.InterfaceGeneralGUI;

public interface InterfaceCarouselGUI
extends InterfaceGeneralGUI {
    public static final long timeoutForOpeningClamps = 10000L;
    public static final long timeoutForRotation = 20000L;
    public static final long timeoutForCheckingFilterLocation = 2000L;
    public static final long timeoutForCANbus = 500L;
    public static final String carouselName = "carousel";

    default public void checkFiltersLocation() {
        this.sendCommand("checkFiltersLocation", 2000L);
    }

    default public void rotate(int socketID) {
        FCSCst.FCSLOG.info((Object)"Carousel rotating");
        FCSCst.FCSLOG.info((Object)"/timeout=20000");
        if (socketID < 1 || socketID > 5) {
            throw new IllegalArgumentException(socketID + " bad socket ID; enter a digit between 1 and 5");
        }
        this.sendCommand("rotateSocketToStandby socket" + socketID, 20000L, carouselName);
    }

    default public void updatePosition() {
        FCSCst.FCSLOG.info((Object)"Carousel updating position");
        FCSCst.FCSLOG.info((Object)"/timeout=1000");
        this.sendCommand("updatePosition", 1000L, carouselName);
    }

    default public void setSlowMode() {
        FCSCst.FCSLOG.info((Object)"Carousel entering slow mode");
        this.sendCommand("setSlowMode", 1000L, carouselName);
    }

    default public void setFastMode() {
        FCSCst.FCSLOG.info((Object)"Carousel entering slow mode");
        this.sendCommand("setFastMode", 1000L, carouselName);
    }

    default public void unlockClamps() {
        FCSCst.FCSLOG.info((Object)"Carousel unlocking clamps");
        FCSCst.FCSLOG.info((Object)"/timeout=10000");
        this.sendCommand("unlockClamps", 10000L);
    }
}

