/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.time.Duration;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.daq.ims.Source;
import org.lsst.ccs.daq.ims.Store;
import org.lsst.ccs.daq.ims.StreamListener;

class DAQSourceChannel
implements ByteChannel {
    protected final Store store;
    protected long channel_;
    private final Source.ChannelMode mode;

    static ByteChannel open(Source source, Source.ChannelMode mode) throws DAQException {
        switch (mode) {
            case READ: {
                if (source.getMetaData().getLength() == 0L) {
                    throw new DAQException("Cannot read from source which is not fully written, did you mean to use ChennelMode.STREAM?");
                }
                return new ReadableDAQSourceChannel(source);
            }
            case STREAM: {
                return new StreamingDAQSourceChannel(source);
            }
            case WRITE: {
                return new WritableDAQSourceChannel(source);
            }
        }
        throw new UnsupportedOperationException("Unsupported mode " + (Object)((Object)mode));
    }

    DAQSourceChannel(Source source, Source.ChannelMode mode) throws DAQException {
        Image image = source.getImage();
        this.store = image.getStore();
        if (mode != Source.ChannelMode.STREAM) {
            this.channel_ = this.store.openSourceChannel(image.getMetaData().getId(), source.getLocation(), mode);
        }
        this.mode = mode;
    }

    @Override
    public boolean isOpen() {
        return this.channel_ != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.channel_ != 0L) {
            Store store = this.store;
            synchronized (store) {
                this.close(this.channel_, this.mode == Source.ChannelMode.WRITE);
            }
            this.channel_ = 0L;
        }
    }

    void checkOpen(ByteBuffer dst) throws IOException {
        if (this.channel_ == 0L) {
            throw new IOException("Channel not open for read");
        }
        if (!dst.isDirect()) {
            throw new IOException("Supplied ByteBuffer is not direct");
        }
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        throw new IOException("Channel not open for read.");
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        throw new IOException("Channel not open for write.");
    }

    protected native int read(long var1, ByteBuffer var3, int var4, long var5, int var7);

    protected native int write(long var1, ByteBuffer var3, int var4, int var5);

    private native void close(long var1, boolean var3);

    private static class WritableDAQSourceChannel
    extends DAQSourceChannel {
        public WritableDAQSourceChannel(Source source) throws DAQException {
            super(source, Source.ChannelMode.WRITE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int write(ByteBuffer src) throws IOException {
            int err;
            this.checkOpen(src);
            int remaining = src.remaining();
            int position = src.position();
            Store store = this.store;
            synchronized (store) {
                err = this.write(this.channel_, src, position, remaining);
            }
            if (err != 0) {
                DAQException daq = new DAQException("Error reading DAQ data", err);
                throw new IOException("DAQ IO exception", daq);
            }
            src.position(position + remaining);
            return remaining - position;
        }
    }

    static class StreamingDAQSourceChannel
    extends DAQSourceChannel
    implements StreamListener {
        private volatile long length = 0L;
        private volatile boolean isComplete = false;
        private long offset = 0L;
        private final Source source;
        private static final Duration READ_TIMEOUT = Duration.ofSeconds(10L);

        StreamingDAQSourceChannel(Source source) throws DAQException {
            super(source, Source.ChannelMode.STREAM);
            this.source = source;
            source.addStreamListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(ByteBuffer dst) throws IOException {
            try {
                int err;
                int l = this.waitForData(dst);
                if (l < 0) {
                    return -1;
                }
                if (this.channel_ == 0L) {
                    Image image = this.source.getImage();
                    this.channel_ = this.store.openSourceChannel(image.getMetaData().getId(), this.source.getLocation(), Source.ChannelMode.STREAM);
                }
                this.checkOpen(dst);
                int position = dst.position();
                Store store = this.store;
                synchronized (store) {
                    err = this.read(this.channel_, dst, position, this.offset, l);
                }
                if (err != 0) {
                    throw new DAQException("Error reading DAQ data", err);
                }
                this.offset += (long)l;
                dst.position(position + l);
                return l;
            }
            catch (DAQException x) {
                throw new IOException("DAQ IO exception", x);
            }
        }

        private synchronized int waitForData(ByteBuffer dst) throws IOException {
            int l = (int)Math.min((long)dst.remaining(), this.length - this.offset);
            long finishBy = System.currentTimeMillis() + READ_TIMEOUT.toMillis();
            while (l == 0) {
                try {
                    if (this.isComplete) {
                        return -1;
                    }
                    long remainingTime = finishBy - System.currentTimeMillis();
                    if (remainingTime <= 0L) {
                        throw new IOException("Streaming read timed out");
                    }
                    this.wait(remainingTime);
                    l = (int)Math.min((long)dst.remaining(), this.length - this.offset);
                }
                catch (InterruptedException x) {
                    throw new InterruptedIOException();
                }
            }
            return l;
        }

        @Override
        public synchronized void streamLength(long length) {
            this.length = length;
            this.notifyAll();
        }

        @Override
        public synchronized void imageComplete(long length) {
            this.length = length;
            this.isComplete = true;
            this.notifyAll();
        }

        @Override
        public void close() throws IOException {
            this.source.removeStreamListener(this);
            super.close();
        }
    }

    static class ReadableDAQSourceChannel
    extends DAQSourceChannel {
        private final long length;
        private long offset = 0L;

        ReadableDAQSourceChannel(Source source) throws DAQException {
            super(source, Source.ChannelMode.READ);
            this.length = source.getMetaData().getLength();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(ByteBuffer dst) throws IOException {
            int err;
            this.checkOpen(dst);
            int l = (int)Math.min((long)dst.remaining(), this.length - this.offset);
            if (l == 0) {
                return -1;
            }
            int position = dst.position();
            Store store = this.store;
            synchronized (store) {
                err = this.read(this.channel_, dst, position, this.offset, l);
            }
            if (err != 0) {
                DAQException daq = new DAQException("Error reading DAQ data", err);
                throw new IOException("DAQ IO exception", daq);
            }
            this.offset += (long)l;
            dst.position(position + l);
            return l;
        }
    }
}

