/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.yaskawa;

import java.io.PrintStream;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.yaskawa.A1000;

public class TestA1000 {
    private static final PrintStream out = System.out;
    private final A1000 a1000 = new A1000();
    private final int MAX_READ = 16;

    @Command(description="Open connection to device")
    public void open(@Argument(description="Serial device name") String devc, @Argument(description="Slave node address") int address, @Argument(description="Baud Rate") int baudRate) throws DriverException {
        this.a1000.open(devc, address, baudRate);
    }

    @Command(description="Open connection to device")
    public void open(@Argument(description="Serial device name") String devc, @Argument(description="Slave node address") int address) throws DriverException {
        this.a1000.open(devc, address);
    }

    @Command(description="Open connection to device")
    public void open(@Argument(description="Serial device name") String devc) throws DriverException {
        this.a1000.open(devc);
    }

    @Command(description="Close connection to device")
    public void close() throws DriverException {
        this.a1000.close();
    }

    @Command(description="Set remote control")
    public void setRemoteControl() throws DriverException {
        this.a1000.setRemoteControl();
    }

    @Command(description="Set local control")
    public void setLocalControl() throws DriverException {
        this.a1000.setLocalControl();
    }

    @Command(description="Read a register")
    public void readRegister(@Argument(description="Register to read") int number) throws DriverException {
        out.format("%04x: %04x\n", number, this.a1000.readRegister((short)number));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="Read a set of registers")
    public void readRegisters(@Argument(description="First register to read") int number, @Argument(description="Number of registers to read") int count) throws DriverException {
        int lineSize = 8;
        int nRead = 0;
        try {
            while (nRead < count) {
                short[] reply = this.a1000.readRegisters((short)number, (short)Math.min(count - nRead, 16));
                int j = 0;
                while (j < reply.length) {
                    if (nRead % lineSize == 0) {
                        if (nRead != 0) {
                            out.println();
                        }
                        out.format("%04x:", number);
                    }
                    out.format(" %04x", reply[j]);
                    ++j;
                    ++nRead;
                    ++number;
                }
            }
        }
        finally {
            if (nRead != 0) {
                out.println();
            }
        }
    }

    @Command(description="Write a set of registers")
    public void writeRegisters(@Argument(description="First register to write") int number, int ... values) throws DriverException {
        int count = values.length;
        if (count == 0) {
            throw new DriverException("No values supplied");
        }
        short[] sValues = new short[count];
        for (int j = 0; j < count; ++j) {
            sValues[j] = (short)values[j];
        }
        this.a1000.writeRegisters((short)number, sValues);
    }

    @Command(description="Enter parameters")
    public void enterParameters() throws DriverException {
        this.a1000.enterParameters();
    }

    @Command(description="Save parameters")
    public void saveParameters() throws DriverException {
        this.a1000.saveParameters();
    }

    @Command(description="Set node address")
    public void setNodeAddress(@Argument(description="Node address") int address) throws DriverException {
        this.a1000.setNodeAddress(address);
    }

    @Command(description="Show node address")
    public int showNodeAddress() throws DriverException {
        return this.a1000.getNodeAddress();
    }

    @Command(description="Set baud rate")
    public void setBaudRate(@Argument(description="Baud rate enum") A1000.BaudRate baudRate) throws DriverException {
        this.a1000.setBaudRate(baudRate);
    }

    @Command(description="Show baud rate")
    public String showBaudRate() throws DriverException {
        return this.a1000.getBaudRate().toString().substring(1);
    }

    @Command(description="Set parity")
    public void setParity(@Argument(description="Parity enum") A1000.Parity parity) throws DriverException {
        this.a1000.setParity(parity);
    }

    @Command(description="Show parity")
    public A1000.Parity showParity() throws DriverException {
        return this.a1000.getParity();
    }

    @Command(description="Set access level")
    public void setAccessLevel(@Argument(description="Access level enum") A1000.AccessLevel level) throws DriverException {
        this.a1000.setAccessLevel(level);
    }

    @Command(description="Show access level")
    public A1000.AccessLevel showAccessLevel() throws DriverException {
        return this.a1000.getAccessLevel();
    }

    @Command(description="Set control mode")
    public void setControlMode(@Argument(description="Control mode enum") A1000.ControlMode mode) throws DriverException {
        this.a1000.setControlMode(mode);
    }

    @Command(description="Show control mode")
    public A1000.ControlMode showControlMode() throws DriverException {
        return this.a1000.getControlMode();
    }

    @Command(description="Set whether enter required")
    public void setEnterRequired(@Argument(description="Whether enter required") boolean required) throws DriverException {
        this.a1000.setEnterRequired(required);
    }

    @Command(description="Show whether enter required")
    public boolean isEnterRequired() throws DriverException {
        return this.a1000.isEnterRequired();
    }

    @Command(description="Set communications error action")
    public void setErrorAction(@Argument(description="Error action enum") A1000.ErrorAction action) throws DriverException {
        this.a1000.setErrorAction(action);
    }

    @Command(description="Show communications error action")
    public A1000.ErrorAction showErrorAction() throws DriverException {
        return this.a1000.getErrorAction();
    }

    @Command(description="Set whether fault detected")
    public void setFaultDetected(@Argument(description="Whether fault detected") boolean detect) throws DriverException {
        this.a1000.setFaultDetected(detect);
    }

    @Command(description="Show whether fault detected")
    public boolean isFaultDetected() throws DriverException {
        return this.a1000.isFaultDetected();
    }

    @Command(description="Set frequency reference source")
    public void setFreqRefSrc(@Argument(description="Freq refc source enum") A1000.FreqRefSrc source) throws DriverException {
        this.a1000.setFreqRefSrc(source);
    }

    @Command(description="Show frequency reference source")
    public A1000.FreqRefSrc showFreqRefSrc() throws DriverException {
        return this.a1000.getFreqRefSrc();
    }

    @Command(description="Set the input voltage")
    public void setInputVoltage(@Argument(description="The voltage") double voltage) throws DriverException {
        this.a1000.setInputVoltage(voltage);
    }

    @Command(description="Show input voltage")
    public double showInputVoltage() throws DriverException {
        return this.a1000.getInputVoltage();
    }

    @Command(description="Set whether reverse permitted")
    public void setReversePermitted(@Argument(description="Whether reverse permitted") boolean permit) throws DriverException {
        this.a1000.setReversePermitted(permit);
    }

    @Command(description="Show whether reverse permitted")
    public boolean isReversePermitted() throws DriverException {
        return this.a1000.isReversePermitted();
    }

    @Command(description="Set whether run command style is forward/reverse")
    public void setRunCmndFwdRev(@Argument(description="Whether forward/reverse") boolean fwdRev) throws DriverException {
        this.a1000.setRunCmndFwdRev(fwdRev);
    }

    @Command(description="Show whether run command style is forward/reverse")
    public boolean isRunCmndFwdRev() throws DriverException {
        return this.a1000.isRunCmndFwdRev();
    }

    @Command(description="Set run command source")
    public void setRunCmndSrc(@Argument(description="Run cmnd source enum") A1000.RunCmndSrc source) throws DriverException {
        this.a1000.setRunCmndSrc(source);
    }

    @Command(description="Show run command source")
    public A1000.RunCmndSrc showRunCmndSrc() throws DriverException {
        return this.a1000.getRunCmndSrc();
    }

    @Command(description="Set run/program interaction")
    public void setRunProg(@Argument(description="Run/program enum") A1000.RunProg runProg) throws DriverException {
        this.a1000.setRunProg(runProg);
    }

    @Command(description="Show run/program interaction")
    public A1000.RunProg showRunProg() throws DriverException {
        return this.a1000.getRunProg();
    }

    @Command(description="Set the stop method")
    public void setStopMethod(@Argument(description="Stop method enum") A1000.StopMethod method) throws DriverException {
        this.a1000.setStopMethod(method);
    }

    @Command(description="Show the stop method")
    public A1000.StopMethod showStopMethod() throws DriverException {
        return this.a1000.getStopMethod();
    }

    @Command(description="Set V/f profile selection")
    public void setVfSelection(@Argument(description="V/f selection enum") A1000.VfSelection select) throws DriverException {
        this.a1000.setVfSelection(select);
    }

    @Command(description="Show V/f profile selection")
    public A1000.VfSelection showVfSelection() throws DriverException {
        return this.a1000.getVfSelection();
    }

    @Command(description="Set the reference frequency")
    public void setFrequency(@Argument(description="The frequency") double freq) throws DriverException {
        this.a1000.setFrequency(freq);
    }

    @Command(description="Set voltage units")
    public void setVoltageUnits(@Argument(description="Voltage units enum") A1000.VoltageUnits units) throws DriverException {
        this.a1000.setVoltageUnits(units);
    }

    @Command(description="Show voltge units")
    public A1000.VoltageUnits showVoltageUnits() throws DriverException {
        return this.a1000.getVoltageUnits();
    }

    @Command(description="Show the reference frequency")
    public double showFrequency() throws DriverException {
        return this.a1000.getFrequency();
    }

    @Command(description="Show the applied reference frequency")
    public double showFrequencyApp() throws DriverException {
        return this.a1000.getFrequencyApp();
    }

    @Command(description="Run the motor forwards")
    public void runForward() throws DriverException {
        this.a1000.runForward();
    }

    @Command(description="Run the motor in reverse")
    public void runReverse() throws DriverException {
        this.a1000.runReverse();
    }

    @Command(description="Stop the motor")
    public void stop() throws DriverException {
        this.a1000.stop();
    }

    @Command(description="Read the frequency")
    public double readFrequency() throws DriverException {
        return this.a1000.readFrequency();
    }

    @Command(description="Read the current")
    public double readCurrent() throws DriverException {
        return this.a1000.readCurrent();
    }

    @Command(description="Read the voltage")
    public double readVoltage() throws DriverException {
        return this.a1000.readVoltage();
    }

    @Command(description="Read the bus voltage")
    public double readBusVoltage() throws DriverException {
        return this.a1000.readBusVoltage();
    }
}

