/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.lsst.ccs.subsystem.common.ui.SystemStatusPanel;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.utility.constants.FanState;
import org.lsst.ccs.subsystem.utility.constants.HeaterState;
import org.lsst.ccs.subsystem.utility.constants.PurgeTestFans;
import org.lsst.ccs.subsystem.utility.constants.PurgeTestHeaters;
import org.lsst.ccs.subsystem.utility.constants.PurgeTestSwitches;
import org.lsst.ccs.subsystem.utility.constants.PurgeTestValves;
import org.lsst.ccs.subsystem.utility.constants.SwitchState;
import org.lsst.ccs.subsystem.utility.constants.ValveState;
import org.lsst.ccs.subsystem.utility.constants.VpcControlState;
import org.lsst.ccs.subsystem.utility.data.PurgeTestState;

public class PurgeTestControlPanel
extends JPanel {
    private static final Map<Integer, String> switchNames = new LinkedHashMap<Integer, String>();
    private static final String[] heaterNames;
    private static final int switchNameWidth;
    private static final int switchStateWidth;
    private static final int fanStateWidth;
    private static final int valveStateWidth;
    private static final int heaterNameWidth;
    private static final int heaterStateWidth;
    private static final int vpcStateWidth;
    private static final int rbOffset = -4;
    private static final int tfOffset = -2;
    private final CommandSender sender;
    private SystemStatusPanel statusPanel;
    private JPanel switchPanel;
    private JPanel mpcPanel;
    private JPanel vpcPanel;
    private JPanel utPanel;
    private JPanel simPanel;
    private final JLabel[] switchLabel = new JLabel[5];
    private final JLabel[] switchState = new JLabel[5];
    private final ButtonGroup[] switchBG = new ButtonGroup[5];
    private final JRadioButton[] switchOffRB = new JRadioButton[5];
    private final JRadioButton[] switchOnRB = new JRadioButton[5];
    private final JLabel[] fanLabel = new JLabel[3];
    private final JLabel[] fanState = new JLabel[3];
    private final ButtonGroup[] fanBG = new ButtonGroup[3];
    private final JRadioButton[] fanOffRB = new JRadioButton[3];
    private final JRadioButton[] fanSpeedRB = new JRadioButton[3];
    private final JTextField[] fanSpeedTF = new JTextField[3];
    private final JRadioButton[] fanTempRB = new JRadioButton[3];
    private final JTextField[] fanTempTF = new JTextField[3];
    private final JLabel[] heaterLabel = new JLabel[3];
    private final JLabel[] heaterState = new JLabel[3];
    private final ButtonGroup[] heaterBG = new ButtonGroup[3];
    private final JRadioButton[] heaterOffRB = new JRadioButton[3];
    private final JRadioButton[] heaterOnRB = new JRadioButton[3];
    private final JTextField[] heaterPowerTF = new JTextField[3];
    private final JLabel[] valveLabel = new JLabel[2];
    private final JLabel[] valveState = new JLabel[2];
    private final ButtonGroup[] valveBG = new ButtonGroup[2];
    private final JRadioButton[] valveShutRB = new JRadioButton[2];
    private final JRadioButton[] valveOpenRB = new JRadioButton[2];
    private final JTextField[] valvePosnTF = new JTextField[2];
    private JLabel vpcLabel;
    private JLabel vpcState;
    private ButtonGroup vpcBG;
    private JRadioButton vpcManualRB;
    private JRadioButton vpcTempRB;
    private final Map<Integer, Integer> switchLines = new HashMap<Integer, Integer>();
    private final double[] fanSpeed = new double[3];
    private final double[] fanTemp = new double[3];
    private final double[] heaterPower = new double[3];
    private final double[] valvePosition = new double[2];
    private static final long serialVersionUID = 1L;

    public PurgeTestControlPanel(CommandSender sender) {
        this.sender = sender;
        this.initComponents();
        new UpdatePurgeStatus(new PurgeTestState()).run();
        new DisableSystem().run();
    }

    private void initComponents() {
        int line = 0;
        for (int swId : switchNames.keySet()) {
            this.switchLines.put(swId, line);
            this.switchLabel[line] = PurgeTestControlPanel.newLabel(switchNames.get(swId) + ":", switchNameWidth);
            this.switchState[line] = PurgeTestControlPanel.newLabel("XXX", switchStateWidth);
            this.switchOnRB[line] = this.newRadioButton("On", "ST" + swId);
            this.switchOffRB[line] = this.newRadioButton("Off", "SF" + swId);
            ButtonGroup bg = this.switchBG[line] = new ButtonGroup();
            bg.add(this.switchOnRB[line]);
            bg.add(this.switchOffRB[line]);
            ++line;
        }
        this.vpcLabel = PurgeTestControlPanel.newLabel("Mode:", 0);
        this.vpcState = PurgeTestControlPanel.newLabel("XXX", vpcStateWidth);
        this.vpcManualRB = this.newRadioButton("Manual", "MF0");
        this.vpcTempRB = this.newRadioButton("Temp", "MT0");
        this.vpcBG = new ButtonGroup();
        this.vpcBG.add(this.vpcManualRB);
        this.vpcBG.add(this.vpcTempRB);
        for (int fanId = 0; fanId < 3; ++fanId) {
            this.fanLabel[fanId] = PurgeTestControlPanel.newLabel("Fan:", 0);
            this.fanState[fanId] = PurgeTestControlPanel.newLabel("XXX", fanStateWidth);
            this.fanOffRB[fanId] = this.newRadioButton("Off", "FF" + fanId);
            this.fanSpeedRB[fanId] = this.newRadioButton("Speed", "FS" + fanId);
            this.fanTempRB[fanId] = this.newRadioButton("Temp", "FT" + fanId);
            ButtonGroup bg = this.fanBG[fanId] = new ButtonGroup();
            bg.add(this.fanOffRB[fanId]);
            bg.add(this.fanSpeedRB[fanId]);
            bg.add(this.fanTempRB[fanId]);
            this.fanSpeedTF[fanId] = this.newTextField("000000", "S" + fanId);
            this.fanTempTF[fanId] = this.newTextField("000.00", "T" + fanId);
        }
        for (int htrId = 0; htrId < 3; ++htrId) {
            this.heaterLabel[htrId] = PurgeTestControlPanel.newLabel(heaterNames[htrId] + ":", heaterNameWidth);
            this.heaterState[htrId] = PurgeTestControlPanel.newLabel("XXX", heaterStateWidth);
            this.heaterOffRB[htrId] = this.newRadioButton("Off", "HF" + htrId);
            this.heaterOnRB[htrId] = this.newRadioButton("On", "HT" + htrId);
            ButtonGroup bg = this.heaterBG[htrId] = new ButtonGroup();
            bg.add(this.heaterOffRB[htrId]);
            bg.add(this.heaterOnRB[htrId]);
            this.heaterPowerTF[htrId] = this.newTextField("00.000", "H" + htrId);
        }
        for (int vlvId = 0; vlvId < 2; ++vlvId) {
            this.valveLabel[vlvId] = PurgeTestControlPanel.newLabel("Valve:", 0);
            this.valveState[vlvId] = PurgeTestControlPanel.newLabel("XXX", valveStateWidth);
            this.valveShutRB[vlvId] = this.newRadioButton("Shut", "VF" + vlvId);
            this.valveOpenRB[vlvId] = this.newRadioButton("Open", "VT" + vlvId);
            ButtonGroup bg = this.valveBG[vlvId] = new ButtonGroup();
            bg.add(this.valveShutRB[vlvId]);
            bg.add(this.valveOpenRB[vlvId]);
            this.valvePosnTF[vlvId] = this.newTextField("00.000", "V" + vlvId);
        }
        this.statusPanel = new SystemStatusPanel(this.sender);
        this.switchPanel = PurgeTestControlPanel.newBorderedPanel("Power Control");
        GridBagConstraints gbs = new GridBagConstraints();
        gbs.anchor = 18;
        int numColm = 2;
        int colm = 0;
        gbs.gridy = 0;
        gbs.insets.top = 0;
        for (line = 0; line < this.switchLabel.length; ++line) {
            if (this.switchLabel[line] == null) continue;
            if (colm == 0) {
                gbs.gridx = 0;
                ++gbs.gridy;
            }
            gbs.insets.top = line < numColm ? 4 : 0;
            gbs.insets.left = colm == 0 ? 4 : 40;
            this.addSwitchLine(line, this.switchPanel, gbs);
            ++gbs.gridx;
            colm = (colm + 1) % numColm;
        }
        this.switchPanel.setMinimumSize(this.switchPanel.getPreferredSize());
        this.mpcPanel = PurgeTestControlPanel.newBorderedPanel("MPC Control");
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.anchor = 18;
        gbm.gridx = 0;
        gbm.gridy = 0;
        gbm.insets.top = 4;
        gbm.insets.left = 4;
        this.addFanLine(0, this.mpcPanel, gbm);
        this.mpcPanel.setMinimumSize(this.mpcPanel.getPreferredSize());
        this.vpcPanel = PurgeTestControlPanel.newBorderedPanel("VPC Control");
        GridBagConstraints gbv = new GridBagConstraints();
        gbv.anchor = 18;
        gbv.gridx = 0;
        gbv.gridy = 0;
        gbv.insets.top = 4;
        gbv.insets.left = 4;
        this.addModeLine(this.vpcPanel, gbv);
        ++gbv.gridy;
        gbv.insets.top = 0;
        gbv.insets.left = 4;
        gbv.gridx = 0;
        this.addValveLine(0, this.vpcPanel, gbv);
        ++gbv.gridy;
        gbv.insets.left = 4;
        gbv.gridx = 0;
        this.addHeaterLine(0, this.vpcPanel, gbv);
        ++gbv.gridy;
        gbv.insets.left = 4;
        gbv.gridx = 0;
        this.addHeaterLine(1, this.vpcPanel, gbv);
        ++gbv.gridy;
        gbv.insets.left = 4;
        gbv.gridx = 0;
        this.addFanLine(1, this.vpcPanel, gbv);
        this.vpcPanel.setMinimumSize(this.vpcPanel.getPreferredSize());
        this.simPanel = PurgeTestControlPanel.newBorderedPanel("Simulator Control");
        GridBagConstraints gbe = new GridBagConstraints();
        gbe.anchor = 18;
        gbe.gridx = 0;
        gbe.gridy = 0;
        gbe.insets.top = 4;
        gbe.insets.left = 4;
        this.addHeaterLine(2, this.simPanel, gbe);
        this.simPanel.setMinimumSize(this.simPanel.getPreferredSize());
        this.utPanel = PurgeTestControlPanel.newBorderedPanel("UT Cooling Control");
        GridBagConstraints gbu = new GridBagConstraints();
        gbu.anchor = 18;
        gbu.gridx = 0;
        gbu.gridy = 0;
        gbu.insets.top = 4;
        gbu.insets.left = 4;
        this.addFanLine(2, this.utPanel, gbu);
        ++gbu.gridy;
        gbu.insets.top = 0;
        gbu.insets.left = 4;
        gbu.gridx = 0;
        this.addValveLine(1, this.utPanel, gbu);
        this.utPanel.setMinimumSize(this.utPanel.getPreferredSize());
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(6, 6, 6, 6);
        gbc.anchor = 11;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.statusPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.switchPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.mpcPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.vpcPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.utPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.simPanel, gbc);
    }

    private static JLabel newLabel(String text, int width) {
        JLabel label = new JLabel(text);
        label.setFont(UiConstants.FONT);
        Dimension d = label.getPreferredSize();
        if (width > 0) {
            d.width = width;
        }
        label.setPreferredSize(d);
        return label;
    }

    private JRadioButton newRadioButton(String title, String name) {
        JRadioButton rb = new JRadioButton(title);
        rb.setFont(UiConstants.FONT);
        rb.setFocusable(false);
        rb.setName(name);
        rb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PurgeTestControlPanel.this.handleRadioButton(((JRadioButton)evt.getSource()).getName());
            }
        });
        return rb;
    }

    private JTextField newTextField(String text, String name) {
        JTextField tf = new JTextField(text);
        tf.setHorizontalAlignment(0);
        tf.setPreferredSize(tf.getPreferredSize());
        tf.setName(name);
        tf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTextField source = (JTextField)evt.getSource();
                PurgeTestControlPanel.this.handleTextField(source.getName(), source.getText());
            }
        });
        return tf;
    }

    private static JPanel newBorderedPanel(String title) {
        JPanel panel = new JPanel();
        TitledBorder border = new TitledBorder(new LineBorder(Color.BLACK), title);
        border.setTitleJustification(2);
        border.setTitleFont(UiConstants.FONT);
        border.setTitleColor(UiConstants.BLUE);
        panel.setBorder(border);
        panel.setLayout(new GridBagLayout());
        return panel;
    }

    private void addSwitchLine(int line, JPanel panel, GridBagConstraints gbc) {
        panel.add((Component)this.switchLabel[line], gbc);
        ++gbc.gridx;
        gbc.insets.left = 6;
        panel.add((Component)this.switchState[line], gbc);
        ++gbc.gridx;
        gbc.insets.top += -4;
        panel.add((Component)this.switchOffRB[line], gbc);
        ++gbc.gridx;
        gbc.insets.right = 4;
        panel.add((Component)this.switchOnRB[line], gbc);
        ++gbc.gridx;
        gbc.insets.right = 0;
        gbc.insets.top -= -4;
    }

    private void addFanLine(int fanId, JPanel panel, GridBagConstraints gbc) {
        panel.add((Component)this.fanLabel[fanId], gbc);
        ++gbc.gridx;
        gbc.insets.left = 6;
        panel.add((Component)this.fanState[fanId], gbc);
        ++gbc.gridx;
        gbc.insets.top += -4;
        panel.add((Component)this.fanOffRB[fanId], gbc);
        ++gbc.gridx;
        panel.add((Component)this.fanSpeedRB[fanId], gbc);
        ++gbc.gridx;
        gbc.insets.top += 2;
        panel.add((Component)this.fanSpeedTF[fanId], gbc);
        ++gbc.gridx;
        gbc.insets.top -= -2;
        if (PurgeTestFans.hasTempState[fanId]) {
            gbc.insets.top += -4;
            panel.add((Component)this.fanTempRB[fanId], gbc);
            ++gbc.gridx;
            gbc.insets.top += 2;
            gbc.insets.right = 4;
            panel.add((Component)this.fanTempTF[fanId], gbc);
            ++gbc.gridx;
            gbc.insets.top -= -2;
            gbc.insets.right = 0;
        }
    }

    private void addModeLine(JPanel panel, GridBagConstraints gbc) {
        panel.add((Component)this.vpcLabel, gbc);
        ++gbc.gridx;
        gbc.insets.left = 6;
        panel.add((Component)this.vpcState, gbc);
        ++gbc.gridx;
        gbc.insets.top += -4;
        panel.add((Component)this.vpcManualRB, gbc);
        ++gbc.gridx;
        panel.add((Component)this.vpcTempRB, gbc);
        ++gbc.gridx;
        gbc.insets.top += 2;
        panel.add((Component)this.fanTempTF[1], gbc);
        ++gbc.gridx;
        gbc.insets.top -= -2;
    }

    private void addValveLine(int valveId, JPanel panel, GridBagConstraints gbc) {
        panel.add((Component)this.valveLabel[valveId], gbc);
        ++gbc.gridx;
        gbc.insets.left = 6;
        panel.add((Component)this.valveState[valveId], gbc);
        ++gbc.gridx;
        gbc.insets.top += -4;
        panel.add((Component)this.valveShutRB[valveId], gbc);
        ++gbc.gridx;
        panel.add((Component)this.valveOpenRB[valveId], gbc);
        ++gbc.gridx;
        gbc.insets.top += 2;
        panel.add((Component)this.valvePosnTF[valveId], gbc);
        ++gbc.gridx;
        gbc.insets.top -= -2;
    }

    private void addHeaterLine(int htrId, JPanel panel, GridBagConstraints gbc) {
        panel.add((Component)this.heaterLabel[htrId], gbc);
        ++gbc.gridx;
        gbc.insets.left = 6;
        panel.add((Component)this.heaterState[htrId], gbc);
        ++gbc.gridx;
        gbc.insets.top += -4;
        panel.add((Component)this.heaterOffRB[htrId], gbc);
        ++gbc.gridx;
        panel.add((Component)this.heaterOnRB[htrId], gbc);
        ++gbc.gridx;
        gbc.insets.top -= -4;
        if (htrId == 2) {
            gbc.insets.top += -2;
            gbc.insets.right = 4;
            panel.add((Component)this.heaterPowerTF[htrId], gbc);
            gbc.insets.top -= -2;
            gbc.insets.right = 0;
        }
        ++gbc.gridx;
    }

    private void handleRadioButton(String name) {
        char type = name.charAt(0);
        char action = name.charAt(1);
        int id = Integer.valueOf(name.substring(2, 3));
        switch (type) {
            case 'S': {
                this.sender.sendCommand(null, "setSwitchOn", new Object[]{PurgeTestSwitches.switchIdToName.get(id), action == 'T'});
                break;
            }
            case 'M': {
                VpcControlState mState = action == 'T' ? VpcControlState.TEMP : VpcControlState.MANUAL;
                this.sender.sendCommand(null, "setVpcState", new Object[]{mState});
                break;
            }
            case 'F': {
                FanState fState = action == 'T' ? FanState.TEMP : (action == 'S' ? FanState.SPEED : FanState.OFF);
                this.sender.sendCommand(null, "setFanState", new Object[]{PurgeTestFans.fanIdToName.get(id), fState});
                break;
            }
            case 'V': {
                ValveState vState = action == 'T' ? ValveState.POSN : ValveState.SHUT;
                this.sender.sendCommand(null, "setValveState", new Object[]{PurgeTestValves.valveIdToName.get(id), vState});
                break;
            }
            case 'H': {
                HeaterState hState = action == 'T' ? HeaterState.ON : HeaterState.OFF;
                this.sender.sendCommand(null, "setHeaterState", new Object[]{PurgeTestHeaters.heaterIdToName.get(id), hState});
            }
        }
    }

    private void handleTextField(String name, String text) {
        char type = name.charAt(0);
        int id = Integer.valueOf(name.substring(1, 2));
        switch (type) {
            case 'S': {
                try {
                    double value;
                    this.fanSpeed[id] = value = Double.valueOf(text).doubleValue();
                    this.sender.sendCommand(null, "setFanSpeed", new Object[]{PurgeTestFans.fanIdToName.get(id), value});
                }
                catch (NumberFormatException e) {
                    this.fanSpeedTF[id].setText(String.valueOf(this.fanSpeed[id]));
                }
                break;
            }
            case 'T': {
                try {
                    double value;
                    this.fanTemp[id] = value = Double.valueOf(text).doubleValue();
                    this.sender.sendCommand(null, "setDeltaTemp", new Object[]{PurgeTestFans.fanIdToName.get(id), value});
                }
                catch (NumberFormatException e) {
                    this.fanTempTF[id].setText(String.valueOf(this.fanTemp[id]));
                }
                break;
            }
            case 'V': {
                try {
                    double value;
                    this.valvePosition[id] = value = Double.valueOf(text).doubleValue();
                    this.sender.sendCommand(null, "setValvePosition", new Object[]{PurgeTestValves.valveIdToName.get(id), value});
                }
                catch (NumberFormatException e) {
                    this.valvePosnTF[id].setText(String.valueOf(this.valvePosition[id]));
                }
                break;
            }
            case 'H': {
                try {
                    double value;
                    this.heaterPower[id] = value = Double.valueOf(text).doubleValue();
                    this.sender.sendCommand(null, "setHeaterPower", new Object[]{PurgeTestHeaters.heaterIdToName.get(id), value});
                    break;
                }
                catch (NumberFormatException e) {
                    this.heaterPowerTF[id].setText(String.valueOf(this.heaterPower[id]));
                }
            }
        }
    }

    public void updateControlPanel(PurgeTestState rs) {
        SwingUtilities.invokeLater(new UpdatePurgeStatus(rs));
    }

    public void disableSystem() {
        SwingUtilities.invokeLater(new DisableSystem());
    }

    static {
        switchNames.put(1, "BFR 24V PDU");
        switchNames.put(0, "BFR 48V PDU");
        switchNames.put(3, "24V PDU Main");
        switchNames.put(2, "48V PDU Main");
        switchNames.put(4, "Electronics");
        heaterNames = new String[3];
        PurgeTestControlPanel.heaterNames[0] = "Heater1";
        PurgeTestControlPanel.heaterNames[1] = "Heater2";
        PurgeTestControlPanel.heaterNames[2] = "Heater";
        JLabel label = new JLabel();
        label.setFont(UiConstants.FONT);
        int width = 0;
        for (String name : switchNames.values()) {
            label.setText(name + ":");
            width = Math.max(width, label.getPreferredSize().width);
        }
        switchNameWidth = width;
        width = 0;
        for (SwitchState switchState : SwitchState.values()) {
            label.setText(switchState.toString());
            width = Math.max(width, label.getPreferredSize().width);
        }
        switchStateWidth = width;
        width = 0;
        for (FanState fanState : FanState.values()) {
            label.setText(fanState.toString());
            width = Math.max(width, label.getPreferredSize().width);
        }
        fanStateWidth = width;
        width = 0;
        for (ValveState valveState : ValveState.values()) {
            label.setText(valveState.toString());
            width = Math.max(width, label.getPreferredSize().width);
        }
        valveStateWidth = width;
        width = 0;
        for (String string : heaterNames) {
            label.setText(string + ":");
            width = Math.max(width, label.getPreferredSize().width);
        }
        heaterNameWidth = width;
        width = 0;
        for (HeaterState heaterState : HeaterState.values()) {
            label.setText(heaterState.toString());
            width = Math.max(width, label.getPreferredSize().width);
        }
        heaterStateWidth = width;
        width = 0;
        for (VpcControlState vpcControlState : VpcControlState.values()) {
            label.setText(vpcControlState.toString());
            width = Math.max(width, label.getPreferredSize().width);
        }
        vpcStateWidth = width;
    }

    class DisableSystem
    implements Runnable {
        DisableSystem() {
        }

        @Override
        public void run() {
            PurgeTestControlPanel.this.statusPanel.disableSystem();
            Iterator iterator = switchNames.keySet().iterator();
            while (iterator.hasNext()) {
                int swId = (Integer)iterator.next();
                int line = (Integer)PurgeTestControlPanel.this.switchLines.get(swId);
                PurgeTestControlPanel.this.switchState[line].setEnabled(false);
                PurgeTestControlPanel.this.switchOffRB[line].setEnabled(false);
                PurgeTestControlPanel.this.switchOnRB[line].setEnabled(false);
            }
            for (int fanId = 0; fanId < 3; ++fanId) {
                PurgeTestControlPanel.this.fanState[fanId].setEnabled(false);
                PurgeTestControlPanel.this.fanOffRB[fanId].setEnabled(false);
                PurgeTestControlPanel.this.fanSpeedRB[fanId].setEnabled(false);
                PurgeTestControlPanel.this.fanTempRB[fanId].setEnabled(false);
                PurgeTestControlPanel.this.fanSpeedTF[fanId].setEnabled(false);
                PurgeTestControlPanel.this.fanTempTF[fanId].setEnabled(false);
            }
            for (int htrId = 0; htrId < 3; ++htrId) {
                PurgeTestControlPanel.this.heaterState[htrId].setEnabled(false);
                PurgeTestControlPanel.this.heaterOffRB[htrId].setEnabled(false);
                PurgeTestControlPanel.this.heaterOnRB[htrId].setEnabled(false);
                PurgeTestControlPanel.this.heaterPowerTF[htrId].setEnabled(false);
            }
            for (int vlvId = 0; vlvId < 2; ++vlvId) {
                PurgeTestControlPanel.this.valveState[vlvId].setEnabled(false);
                PurgeTestControlPanel.this.valveShutRB[vlvId].setEnabled(false);
                PurgeTestControlPanel.this.valveOpenRB[vlvId].setEnabled(false);
                PurgeTestControlPanel.this.valvePosnTF[vlvId].setEnabled(false);
            }
            PurgeTestControlPanel.this.vpcState.setEnabled(false);
            PurgeTestControlPanel.this.vpcManualRB.setEnabled(false);
            PurgeTestControlPanel.this.vpcTempRB.setEnabled(false);
            PurgeTestControlPanel.this.repaint();
        }
    }

    class UpdatePurgeStatus
    implements Runnable {
        private final PurgeTestState ps;

        UpdatePurgeStatus(PurgeTestState ps) {
            this.ps = ps;
        }

        @Override
        public void run() {
            JRadioButton selButton;
            PurgeTestControlPanel.this.statusPanel.updateStatus(this.ps.getTickMillis());
            Iterator iterator = switchNames.keySet().iterator();
            while (iterator.hasNext()) {
                int swId = (Integer)iterator.next();
                int line = (Integer)PurgeTestControlPanel.this.switchLines.get(swId);
                SwitchState st = this.ps.getSwitchState(swId);
                st = st == null ? SwitchState.OFFLINE : st;
                JLabel label = PurgeTestControlPanel.this.switchState[line];
                label.setText(st.toString());
                label.setForeground(st == SwitchState.ON ? UiConstants.GREEN : (st == SwitchState.OFF ? Color.BLACK : UiConstants.BLUE));
                st = this.ps.getSwitchBaseState(swId);
                JRadioButton selButton2 = st == SwitchState.ON ? PurgeTestControlPanel.this.switchOnRB[line] : PurgeTestControlPanel.this.switchOffRB[line];
                selButton2.setSelected(true);
                PurgeTestControlPanel.this.switchState[line].setEnabled(true);
                PurgeTestControlPanel.this.switchOffRB[line].setEnabled(true);
                PurgeTestControlPanel.this.switchOnRB[line].setEnabled(true);
            }
            for (int fanId = 0; fanId < 3; ++fanId) {
                double temp;
                double speed;
                FanState st = this.ps.getFanState(fanId);
                st = st == null ? FanState.OFFLINE : st;
                JLabel label = PurgeTestControlPanel.this.fanState[fanId];
                label.setText(st.toString());
                label.setForeground(st == FanState.TEMP ? UiConstants.GREEN : (st == FanState.SPEED ? UiConstants.YELLOW : (st == FanState.OFF ? Color.BLACK : UiConstants.BLUE)));
                st = this.ps.getFanBaseState(fanId);
                selButton = st == FanState.TEMP ? PurgeTestControlPanel.this.fanTempRB[fanId] : (st == FanState.SPEED ? PurgeTestControlPanel.this.fanSpeedRB[fanId] : PurgeTestControlPanel.this.fanOffRB[fanId]);
                selButton.setSelected(true);
                ((PurgeTestControlPanel)PurgeTestControlPanel.this).fanSpeed[fanId] = speed = this.ps.getFanSpeed(fanId);
                PurgeTestControlPanel.this.fanSpeedTF[fanId].setText(String.format("%.2f", speed));
                ((PurgeTestControlPanel)PurgeTestControlPanel.this).fanTemp[fanId] = temp = this.ps.getDeltaTemp(fanId);
                PurgeTestControlPanel.this.fanTempTF[fanId].setText(String.format("%.2f", temp));
                PurgeTestControlPanel.this.fanState[fanId].setEnabled(true);
                PurgeTestControlPanel.this.fanOffRB[fanId].setEnabled(true);
                PurgeTestControlPanel.this.fanSpeedRB[fanId].setEnabled(true);
                PurgeTestControlPanel.this.fanTempRB[fanId].setEnabled(true);
                PurgeTestControlPanel.this.fanSpeedTF[fanId].setEnabled(true);
                PurgeTestControlPanel.this.fanTempTF[fanId].setEnabled(true);
            }
            for (int htrId = 0; htrId < 3; ++htrId) {
                double power;
                HeaterState st = this.ps.getHeaterState(htrId);
                st = st == null ? HeaterState.OFFLINE : st;
                JLabel label = PurgeTestControlPanel.this.heaterState[htrId];
                label.setText(st.toString());
                label.setForeground(st == HeaterState.TEMP ? UiConstants.GREEN : (st == HeaterState.ON ? UiConstants.YELLOW : (st == HeaterState.OFF ? Color.BLACK : UiConstants.BLUE)));
                st = this.ps.getHeaterBaseState(htrId);
                selButton = st == HeaterState.ON ? PurgeTestControlPanel.this.heaterOnRB[htrId] : PurgeTestControlPanel.this.heaterOffRB[htrId];
                selButton.setSelected(true);
                ((PurgeTestControlPanel)PurgeTestControlPanel.this).heaterPower[htrId] = power = this.ps.getHeaterValue(htrId);
                PurgeTestControlPanel.this.heaterPowerTF[htrId].setText(String.format("%.2f", power));
                PurgeTestControlPanel.this.heaterState[htrId].setEnabled(true);
                PurgeTestControlPanel.this.heaterOffRB[htrId].setEnabled(true);
                PurgeTestControlPanel.this.heaterOnRB[htrId].setEnabled(true);
                PurgeTestControlPanel.this.heaterPowerTF[htrId].setEnabled(true);
            }
            for (int vlvId = 0; vlvId < 2; ++vlvId) {
                double position;
                ValveState st = this.ps.getValveState(vlvId);
                st = st == null ? ValveState.OFFLINE : st;
                JLabel label = PurgeTestControlPanel.this.valveState[vlvId];
                label.setText(st.toString());
                label.setForeground(st == ValveState.TEMP ? UiConstants.GREEN : (st == ValveState.POSN ? UiConstants.YELLOW : (st == ValveState.SHUT ? Color.BLACK : UiConstants.BLUE)));
                st = this.ps.getValveBaseState(vlvId);
                selButton = st == ValveState.POSN ? PurgeTestControlPanel.this.valveOpenRB[vlvId] : PurgeTestControlPanel.this.valveShutRB[vlvId];
                selButton.setSelected(true);
                ((PurgeTestControlPanel)PurgeTestControlPanel.this).valvePosition[vlvId] = position = this.ps.getValvePosition(vlvId);
                PurgeTestControlPanel.this.valvePosnTF[vlvId].setText(String.format("%.2f", position));
                PurgeTestControlPanel.this.valveState[vlvId].setEnabled(true);
                PurgeTestControlPanel.this.valveShutRB[vlvId].setEnabled(true);
                PurgeTestControlPanel.this.valveOpenRB[vlvId].setEnabled(true);
                PurgeTestControlPanel.this.valvePosnTF[vlvId].setEnabled(true);
            }
            VpcControlState vst = this.ps.getVpcState();
            vst = vst == null ? VpcControlState.MANUAL : vst;
            JLabel label = PurgeTestControlPanel.this.vpcState;
            label.setText(vst.toString());
            label.setForeground(vst == VpcControlState.TEMP ? UiConstants.GREEN : Color.BLACK);
            JRadioButton selButton3 = vst == VpcControlState.TEMP ? PurgeTestControlPanel.this.vpcTempRB : PurgeTestControlPanel.this.vpcManualRB;
            selButton3.setSelected(true);
            PurgeTestControlPanel.this.vpcState.setEnabled(true);
            PurgeTestControlPanel.this.vpcManualRB.setEnabled(true);
            PurgeTestControlPanel.this.vpcTempRB.setEnabled(true);
            PurgeTestControlPanel.this.repaint();
        }
    }
}

