/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.auxelex;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.auxelex.RebPS;
import org.lsst.ccs.drivers.auxelex.TestSrp;
import org.lsst.ccs.drivers.commons.DriverException;

public class TestRebPS
extends TestSrp {
    private static final Map<Integer, String> versionMap = new HashMap<Integer, String>();
    private static final Map<Integer, String> typeMap;
    private final RebPS ps;

    public TestRebPS() {
        super(new RebPS());
        this.ps = (RebPS)this.srp;
    }

    @Command(name="showserial", description="Show the serial number")
    public String showSerial() throws DriverException {
        return String.format("0x%016x", this.ps.getSerialNo());
    }

    @Command(name="showfirmware", description="Show the firmware version")
    public String showFirmware() throws DriverException {
        return String.format("0x%08x", this.ps.getFwVersion());
    }

    @Command(name="showgeogaddr", description="Show the geographical address")
    public String showGeogAddr() throws DriverException {
        return String.valueOf(this.ps.getGeogAddr());
    }

    @Command(name="showversion", description="Show the power supply version")
    public String showVersion() throws DriverException {
        int value = this.ps.getVersion();
        return String.format("%s (%s)", versionMap.get(value), value);
    }

    @Command(name="shownumrebs", description="Show the number of REBs")
    public String showNumRebs() throws DriverException {
        return String.valueOf(this.ps.getNumRebs());
    }

    @Command(name="shownumtemps", description="Show the number of temperatures")
    public String showNumTemps() throws DriverException {
        return String.valueOf(this.ps.getNumTemperatures());
    }

    @Command(name="showtype", description="Show the PS type")
    public String showType() throws DriverException {
        int value = this.ps.getType();
        return String.format("%s (%s)", typeMap.get(value), value);
    }

    @Command(name="configure", description="Configure a device")
    public void configure(@Argument(description="REB number") int rebNum, @Argument(description="Power supply number") int psNum, @Argument(description="Device number") int devc) throws DriverException {
        this.ps.configure(rebNum, psNum, devc);
    }

    @Command(name="configure", description="Configure all devices in a PS")
    public void configure(@Argument(description="REB number") int rebNum, @Argument(description="Power supply number") int psNum) throws DriverException {
        this.ps.configure(rebNum, psNum);
    }

    @Command(name="configure", description="Configure all devices in a REB")
    public void configure(@Argument(description="REB number") int rebNum) throws DriverException {
        this.ps.configure(rebNum);
    }

    @Command(name="readpower", description="Show a power value")
    public String readPower(@Argument(description="REB number") int rebNum, @Argument(description="Power supply number") int psNum, @Argument(description="Channel number") int chan) throws DriverException {
        return String.format("%.3f", this.ps.readChannel(rebNum, psNum, chan));
    }

    @Command(name="readpower", description="Show power values")
    public String readPower(@Argument(description="REB number") int rebNum, @Argument(description="Power supply number") int psNum) throws DriverException {
        double[] values = this.ps.readChannel(rebNum, psNum);
        StringBuilder text = new StringBuilder(String.format("PS%s:", psNum));
        for (double value : values) {
            text.append(String.format("  %.2f", value));
        }
        return text.toString();
    }

    @Command(name="readpower", description="Show power values")
    public String readPower(@Argument(description="REB number") int rebNum) throws DriverException {
        StringBuilder text = new StringBuilder(this.readPower(rebNum, 0));
        for (int psNum = 1; psNum < 7; ++psNum) {
            text.append("\n");
            text.append(this.readPower(rebNum, psNum));
        }
        return text.toString();
    }

    @Command(name="readextpower", description="Show extended power values")
    public String readExtPower(@Argument(description="REB number") int rebNum, @Argument(description="Power supply number") int psNum, @Argument(description="Channel number") int chan) throws DriverException {
        double[] values = this.ps.readChanExtended(rebNum, psNum, chan);
        return String.format("Curr = %.2f, Max = %.2f, Min = %.2f, LimH = %.2f, LimL = %.2f", values[0], values[1], values[2], values[3], values[4]);
    }

    @Command(name="readextpower", description="Show extended power values")
    public String readExtPower(@Argument(description="REB number") int rebNum, @Argument(description="Power supply number") int psNum) throws DriverException {
        double[][] values = this.ps.readChanExtended(rebNum, psNum);
        StringBuilder text = new StringBuilder();
        for (int j = 0; j < values.length; ++j) {
            double[] vals = values[j];
            String line = String.format("Chan %s: Curr = %.2f, Max = %.2f, Min = %.2f, LimH = %.2f, LimL = %.2f", j, vals[0], vals[1], vals[2], vals[3], vals[4]);
            text.append(line).append(j < values.length - 1 ? "\n" : "");
        }
        return text.toString();
    }

    @Command(name="resetextrema", description="Reset maximum and minimum power values")
    public void resetExtrema(@Argument(description="REB number") int rebNum, @Argument(description="Power supply number") int psNum, @Argument(description="Channel number") int chan) throws DriverException {
        this.ps.resetChanExtrema(rebNum, psNum, chan);
    }

    @Command(name="writedac", description="Write to a DAC")
    public void writeDac(@Argument(description="REB number") int rebNum, @Argument(description="Power supply number") int psNum, @Argument(description="DAC value") double value) throws DriverException {
        this.ps.writeDac(rebNum, psNum, value);
    }

    @Command(name="configtemp", description="Configure the temperature system")
    public void configTemperature() throws DriverException {
        this.ps.configTemperature();
    }

    @Command(name="settempres", description="Set a temperature resolution")
    public void setTemperatureRes(@Argument(description="The sensor number (0 - 6)") int sensor, @Argument(description="Resolution value (0 - 3)") int res) throws DriverException {
        this.ps.setTemperatureRes(sensor, res);
    }

    @Command(name="settempres", description="Set all temperature resolutions")
    public void setTemperatureRes(@Argument(description="Resolution value (0 - 3)") int res) throws DriverException {
        this.ps.setTemperatureRes(res);
    }

    @Command(name="showtempres", description="Show a temperature resolution")
    public String showTemperatureRes(@Argument(description="The sensor number (0 - 6)") int sensor) throws DriverException {
        return String.valueOf(this.ps.getTemperatureRes(sensor));
    }

    @Command(name="showtempres", description="Show all temperature resolutions")
    public String showTemperatureRes() throws DriverException {
        int[] values = this.ps.getTemperatureRes();
        StringBuilder text = new StringBuilder();
        for (int value : values) {
            text.append(value).append(" ");
        }
        return text.toString();
    }

    @Command(name="showtemp", description="Show a temperature")
    public String showTemperature(@Argument(description="The sensor number (0 - 6)") int sensor) throws DriverException {
        return String.format("%.2f", this.ps.readTemperature(sensor));
    }

    @Command(name="showtemp", description="Show all temperatures")
    public String showTemperature() throws DriverException {
        return this.formatValues(this.ps.readTemperature());
    }

    @Command(name="showtempwarn", description="Show all warning temperature limits")
    public String showTempWarn() throws DriverException {
        return this.formatValues(this.ps.readTempWarn());
    }

    @Command(name="showtemperror", description="Show all error temperature limits")
    public String showTempError() throws DriverException {
        return this.formatValues(this.ps.readTempError());
    }

    @Command(name="setpower", description="Sets the power")
    public void setPower(@Argument(description="REB number") int rebNum, @Argument(description="Action value") int action) throws DriverException {
        this.ps.setPower(rebNum, action);
    }

    @Command(name="showpower", description="Show the power")
    public String showPower(@Argument(description="REB number") int rebNum) throws DriverException {
        return String.format("0x%02x", this.ps.getPower(rebNum));
    }

    @Command(name="showinitstatus", description="Show the initialization status")
    public String showInitStatus() throws DriverException {
        return String.format("0x%08x", this.ps.getInitStatus());
    }

    @Command(name="showfailsummary", description="Show the failure summary word")
    public String showFailSummary() throws DriverException {
        return String.format("0x%08x", this.ps.getFailureSummary());
    }

    @Command(name="showfaildetail", description="Show the failure detail")
    public String showFailDetail(@Argument(description="REB number") int rebNum) throws DriverException {
        return String.format("0x%08x", this.ps.getFailureDetail(rebNum));
    }

    @Command(name="enablewrite", description="Enable writing to all registers")
    public void enableWrite(@Argument(description="Whether to enable (or not)") boolean enable) throws DriverException {
        this.ps.enableAllWrite(enable);
    }

    @Command(name="showenablewrite", description="Show whether writing to all registers is enabled")
    public String showEnableWrite() throws DriverException {
        return String.valueOf(this.ps.isAllWriteEnabled());
    }

    @Command(name="enablepower", description="Enable leaving power on after error")
    public void enablePower(@Argument(description="Whether to enable (or not)") boolean enable) throws DriverException {
        this.ps.enablePowerLeftOn(enable);
    }

    @Command(name="showenablepower", description="Show whether leaving power on is enabled")
    public String showEnablePower() throws DriverException {
        return String.valueOf(this.ps.isPowerLeftOnEnabled());
    }

    @Command(name="showerrors", description="Show the error counters")
    public String showErrors() throws DriverException {
        return String.format("Seq: %s   Tmo: %s", this.ps.getNumSeqErr(), this.ps.getNumTimeout());
    }

    @Command(name="contpower", description="Continuously read a power value")
    public String contPower(@Argument(description="REB number") int rebNum, @Argument(description="Power supply number") int psNum, @Argument(description="Channel number") int chan) throws DriverException {
        System.out.println("Press any key to terminate...");
        boolean[] done = new boolean[]{false};
        this.consThread.start(done);
        int nRead = 0;
        long startTime = System.currentTimeMillis();
        while (!done[0]) {
            this.ps.readChannel(rebNum, psNum, chan);
            ++nRead;
        }
        return TestRebPS.formatRate(startTime, nRead);
    }

    @Command(name="contextpower", description="Continuously read extended power values")
    public String contExtPower(@Argument(description="REB number") int rebNum, @Argument(description="Power supply number") int psNum, @Argument(description="Channel number") int chan) throws DriverException {
        System.out.println("Press any key to terminate...");
        boolean[] done = new boolean[]{false};
        this.consThread.start(done);
        int nRead = 0;
        long startTime = System.currentTimeMillis();
        while (!done[0]) {
            this.ps.readChanExtended(rebNum, psNum, chan);
            ++nRead;
        }
        return TestRebPS.formatRate(startTime, nRead);
    }

    @Command(name="conttemp", description="Continuously read a temperature value")
    public String contTemperature(@Argument(description="Channel number") int chan) throws DriverException {
        System.out.println("Press any key to terminate...");
        boolean[] done = new boolean[]{false};
        this.consThread.start(done);
        int nRead = 0;
        long startTime = System.currentTimeMillis();
        while (!done[0]) {
            this.ps.readTemperature(chan);
            ++nRead;
        }
        return TestRebPS.formatRate(startTime, nRead);
    }

    private String formatValues(double[] values) throws DriverException {
        StringBuilder text = new StringBuilder();
        for (double value : values) {
            text.append(String.format("%.2f", value)).append(" ");
        }
        return text.toString();
    }

    static {
        versionMap.put(1, "Production");
        versionMap.put(0, "Prototype");
        typeMap = new HashMap<Integer, String>();
        typeMap.put(0, "Science");
        typeMap.put(1, "Corner");
        typeMap.put(-1, "Unknown");
    }
}

