/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane.data;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.bus.data.DataProviderInfo;

public enum FocalPlaneDataGroup {
    ASPIC_TEMPERATURE("Aspic Temperature", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>Reb\\d|Reb[WG])/(?<aspicId>Aspic[UL])/Temp\\d")),
    REB_TEMPERATURE("Reb Temperature", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>Reb\\d|Reb[WG])/Temp\\d+")),
    CCD_TEMPERATURE("CCD Temperature", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>Reb\\d|Reb[WG])/(?<sensorId>SW|SG\\d|S\\d\\d)/Temp")),
    CCD_CURRENTS("CCD Currents", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>Reb\\d|Reb[WG])/(?<sensorId>SW|SG\\d|S\\d\\d)/Seg(?<amplifierId>\\d\\d)/I")),
    CCD_VOLTAGES("CCD Voltages", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>Reb\\d|Reb[WG])/(?<sensorId>SW|SG\\d|S\\d\\d)/[ORG][DG]V")),
    BIAS_VOLTAGES("Bias Voltages", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>Reb\\d|Reb[WG])/Ref\\d+V")),
    RTD_TEMPERATURE("RTD Temperature", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>Reb\\d|Reb[WG])/RTDTemp")),
    CLOCK_RAILS("Clock Rails", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>Reb\\d|Reb[WG])/([PS]Clk[UL]|RG[UL]|Ref[PN]12)")),
    BOARD_POWER("Board Power", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>Reb\\d|Reb[WG])/(Dig[VI]|Ana[VI]|Clk[HL][VI]|Power|OD[VI])")),
    HEATER("Heater", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>Reb\\d|Reb[WG])/Htr[V|W]"));

    private final String name;
    private final Pattern pattern;

    public static FocalPlaneDataGroup forName(String name) {
        for (FocalPlaneDataGroup g : FocalPlaneDataGroup.values()) {
            if (!g.name.equals(name)) continue;
            return g;
        }
        throw new IllegalArgumentException("No FocalPlaneDataGroup constant with " + name + " name.");
    }

    private FocalPlaneDataGroup(String name, Pattern pattern) {
        this.name = name;
        this.pattern = pattern;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public boolean matchesData(DataProviderInfo dataInfo) {
        return this.pattern.matcher(dataInfo.getPath()).matches();
    }

    public static FocalPlaneDataGroup findFocalPlaneDataGroup(DataProviderInfo dataInfo) {
        for (FocalPlaneDataGroup dataGroup : FocalPlaneDataGroup.values()) {
            if (!dataGroup.matchesData(dataInfo)) continue;
            return dataGroup;
        }
        return null;
    }

    public void addAttributesToDataInfo(DataProviderInfo dataInfo) {
        Matcher m = this.pattern.matcher(dataInfo.getPath());
        if (m.matches()) {
            dataInfo.addAttribute(DataProviderInfo.Attribute.DATA_GROUP, this.getName());
            try {
                String raftId = m.group("raftId");
                if (raftId != null) {
                    dataInfo.addAttribute(DataProviderInfo.Attribute.RAFT_ID, raftId);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

