/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane.ui.filter;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.base.filter.AbstractChannelsFilter;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.persist.Creator;
import org.lsst.ccs.gconsole.services.persist.Persistable;
import org.lsst.ccs.subsystem.focalplane.ui.Segment;
import org.lsst.ccs.subsystem.focalplane.ui.filter.GroupingTemplateFilterDialog;
import org.lsst.ccs.subsystem.focalplane.ui.filter.Template;

public class GroupingTemplateFilter
extends AbstractChannelsFilter {
    public static final String PATH = "Groups/Template Groups";
    private final Descriptor descriptor;
    private final HashMap<Template, ArrayList<String>> template2groups = new HashMap();

    private GroupingTemplateFilter() {
        this.descriptor = new Descriptor();
        this.descriptor.setGroups(new LinkedHashMap<String, ArrayList<String>>(0));
    }

    public GroupingTemplateFilter(Descriptor desc) {
        this.descriptor = desc.clone();
        if (this.descriptor.getGroups() != null) {
            for (Map.Entry<String, ArrayList<String>> e : this.descriptor.getGroups().entrySet()) {
                for (String st : e.getValue()) {
                    try {
                        Template t = Template.valueOf(st);
                        ArrayList<String> groups = this.template2groups.get(t);
                        if (groups == null) {
                            groups = new ArrayList(1);
                            this.template2groups.put(t, groups);
                        }
                        groups.add(e.getKey());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
        }
    }

    @Create(category="FocalPlaneFilter", name="Template Groups", path="Groups/Template Groups", description="Channels filter that maps groups of focal plane channels to display paths.")
    public static GroupingTemplateFilter create() {
        GroupingTemplateFilter f = new GroupingTemplateFilter();
        Creator.Descriptor cd = new Creator.Descriptor();
        cd.setCategory("FocalPlaneFilter");
        cd.setPath(PATH);
        f.getDescriptor().setCreator(cd);
        return f.edit(null, null);
    }

    public String getName() {
        return this.getDescriptor().getName();
    }

    public List<String> getAgents() {
        boolean hasAgentless = false;
        LinkedHashSet<String> aa = new LinkedHashSet<String>();
        for (ArrayList<String> tt : this.getDescriptor().getGroups().values()) {
            for (String t : tt) {
                String agent = Template.getAgent(t);
                if (agent.isEmpty()) {
                    hasAgentless = true;
                    continue;
                }
                aa.add(agent);
            }
        }
        if (hasAgentless) {
            String[] agents = this.getDescriptor().getAgents();
            if (agents == null) {
                return null;
            }
            ArrayList<String> out = new ArrayList<String>(aa);
            out.addAll(Arrays.asList(agents));
            return out;
        }
        return new ArrayList<String>(aa);
    }

    public List<String> getOriginPaths(String displayPath) {
        return Collections.emptyList();
    }

    public String getOriginPath(String displayPath) {
        return displayPath;
    }

    public String getDisplayPath(AgentChannel channel) {
        return this.getDisplayPaths(channel).isEmpty() ? null : channel.getPath();
    }

    public String getDisplayPath(String originPath) {
        return null;
    }

    public List<String> getDisplayPaths(AgentChannel channel) {
        int[] indices = Segment.getIndices(channel);
        return this.getDisplayPaths(channel.getPath(), indices);
    }

    public List<String> getDisplayPaths(String originPath) {
        int[] indices = Segment.getIndices(originPath);
        return this.getDisplayPaths(originPath, indices);
    }

    public List<String> getFields(boolean compact) {
        LinkedHashMap<String, ArrayList<String>> groups = this.descriptor.getGroups();
        if (compact) {
            return new ArrayList<String>(groups.keySet());
        }
        String[] ff = this.descriptor.getFields();
        int n = groups.size();
        if (ff == null || ff.length != n) {
            ArrayList<String> out = new ArrayList<String>(n);
            String field = "AVERAGE_VALUE";
            for (int i = 0; i < n; ++i) {
                out.add(field);
            }
            return out;
        }
        return new ArrayList<String>(Arrays.asList(ff));
    }

    private List<String> getDisplayPaths(String originPath, int[] indices) {
        String[] agents;
        if (indices == null) {
            return Collections.emptyList();
        }
        Template template = Template.valueOf(originPath, indices);
        if (template == null) {
            return Collections.emptyList();
        }
        ArrayList<String> groups = this.template2groups.get(template);
        if (groups == null && ((agents = this.getDescriptor().getAgents()) == null || Arrays.asList(agents).contains(originPath.substring(0, originPath.indexOf("/"))))) {
            template = template.stripAgent();
            groups = this.template2groups.get(template);
        }
        if (groups == null) {
            return Collections.emptyList();
        }
        String prefix = Segment.getPathPrefix(indices);
        return groups.stream().map(s -> prefix + s).collect(Collectors.toList());
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public Descriptor save() {
        return this.getDescriptor().clone();
    }

    public GroupingTemplateFilter edit(String title, Component parent) {
        return GroupingTemplateFilterDialog.edit(this, parent);
    }

    public static class Descriptor
    extends Persistable.Descriptor {
        private LinkedHashMap<String, ArrayList<String>> groups;
        private String[] agents;
        private String[] fields;

        public LinkedHashMap<String, ArrayList<String>> getGroups() {
            return this.groups;
        }

        public void setGroups(LinkedHashMap<String, ArrayList<String>> groups) {
            this.groups = groups;
        }

        public String[] getAgents() {
            return this.agents;
        }

        public void setAgents(String[] agents) {
            this.agents = agents;
        }

        public String[] getFields() {
            return this.fields;
        }

        public void setFields(String[] fields) {
            this.fields = fields;
        }

        public Descriptor clone() {
            Descriptor clone = (Descriptor)super.clone();
            if (this.groups == null) {
                this.groups = new LinkedHashMap(0);
            } else {
                for (Map.Entry<String, ArrayList<String>> e : this.groups.entrySet()) {
                    e.setValue((ArrayList)e.getValue().clone());
                }
            }
            return clone;
        }
    }
}

