/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.states;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class StateBundle
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 19387419697469780L;
    private Map<String, Enum> allStates = new ConcurrentHashMap<String, Enum>();
    private Map<String, StateBundle> componentStates = new ConcurrentHashMap<String, StateBundle>();
    private transient Map<String, String> subsystemSpecificStates = new HashMap<String, String>();
    @Deprecated
    private CCSTimeStamp lastModifiedCCSTimeStamp = CCSTimeStamp.currentTime();

    public StateBundle(Enum ... states) {
        for (Enum state : states) {
            this.innerSetState(state);
        }
        this.updateLastModified();
    }

    private StateBundle(StateBundle b) {
        this.allStates.putAll(b.allStates);
        this.subsystemSpecificStates.putAll(b.subsystemSpecificStates);
        this.lastModifiedCCSTimeStamp = b.lastModifiedCCSTimeStamp;
        this.componentStates.putAll(b.componentStates);
    }

    public StateBundle mergeState(StateBundle newState) {
        StateBundle clone = this.clone();
        if (newState != null) {
            clone.allStates.putAll(newState.allStates);
            for (Map.Entry<String, StateBundle> e : newState.componentStates.entrySet()) {
                StateBundle oldComponentState = clone.getComponentStateBundle(e.getKey());
                clone.componentStates.put(e.getKey(), oldComponentState.mergeState(e.getValue()));
            }
        }
        clone.updateLastModified();
        return clone;
    }

    public StateBundle diffState(StateBundle oldState) {
        if (oldState == null) {
            return new StateBundle(this);
        }
        StateBundle diff = new StateBundle(new Enum[0]);
        for (Enum enum_ : this.allStates.values()) {
            if (oldState.isInState(enum_)) continue;
            diff.innerSetState(enum_);
        }
        for (Map.Entry entry : this.componentStates.entrySet()) {
            StateBundle oldComponentState = oldState.getComponentStateBundle((String)entry.getKey());
            StateBundle componentStateDiff = ((StateBundle)entry.getValue()).diffState(oldComponentState);
            diff.componentStates.put((String)entry.getKey(), componentStateDiff);
        }
        diff.updateLastModified();
        return diff;
    }

    public final void setComponentState(String component, Enum ... states) {
        this.innerSetComponentState(component, states);
        this.updateLastModified();
    }

    public final void setState(Enum ... states) {
        for (Enum state : states) {
            this.innerSetState(state);
        }
        this.updateLastModified();
    }

    private void innerSetState(Enum state) {
        if (state == null) {
            throw new IllegalArgumentException("A state cannot be set to null");
        }
        this.allStates.put(state.getClass().getSimpleName(), state);
    }

    private void innerSetComponentState(String component, Enum ... states) {
        StateBundle componentStateBundle = this.getComponentStateBundle(component);
        componentStateBundle.setState(states);
    }

    public final <T extends Enum<T>> T getState(Class<T> enumClass) {
        return (T)this.allStates.get(enumClass.getSimpleName());
    }

    public final <T extends Enum<T>> Enum getComponentState(String component, Class<T> enumClass) {
        StateBundle sb = this.componentStates.get(component);
        return sb == null ? null : (Enum)sb.getState(enumClass);
    }

    public <T extends Enum<T>> boolean isInState(T state) {
        Object e = this.getState(state.getClass());
        return e == null ? false : ((Enum)e).equals(state);
    }

    public <T extends Enum<T>> boolean isComponentInState(String component, T state) {
        Enum e = this.getComponentState(component, state.getClass());
        return e == null ? false : e.equals(state);
    }

    public boolean isComponentInState(String component, StateBundle stateBundle) {
        StateBundle componentStateBundle = this.componentStates.get(component);
        if (componentStateBundle == null) {
            return false;
        }
        return componentStateBundle.isInState(stateBundle);
    }

    public boolean isInState(StateBundle stateBundle) {
        for (Enum enum_ : stateBundle.allStates.values()) {
            if (this.isInState(enum_)) continue;
            return false;
        }
        for (Map.Entry entry : stateBundle.componentStates.entrySet()) {
            if (this.isComponentInState((String)entry.getKey(), (StateBundle)entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public Set<String> getComponentsWithStates() {
        return this.componentStates.keySet();
    }

    public final <T extends Enum<T>> Map<String, T> getComponentsWithState(Class<T> enumClass) {
        HashMap<String, T> result = new HashMap<String, T>();
        for (Map.Entry<String, StateBundle> entry : this.componentStates.entrySet()) {
            T e = entry.getValue().getState(enumClass);
            if (e == null) continue;
            result.put(entry.getKey(), e);
        }
        return result;
    }

    public final synchronized StateBundle getComponentStateBundle(String component) {
        StateBundle componentStateBundle = this.componentStates.get(component);
        if (componentStateBundle == null) {
            componentStateBundle = new StateBundle(new Enum[0]);
            this.componentStates.put(component, componentStateBundle);
        }
        return componentStateBundle;
    }

    @Deprecated
    public CCSTimeStamp getLastModifiedCCSTimeStamp() {
        return this.lastModifiedCCSTimeStamp;
    }

    public Map<String, Enum> getDecodedStates() {
        return Collections.unmodifiableMap(this.allStates);
    }

    public Map<String, String> getAllStatesAsStrings() {
        HashMap<String, String> allStatesAsStrings = new HashMap<String, String>();
        for (Map.Entry<String, Enum> entry : this.allStates.entrySet()) {
            allStatesAsStrings.put(entry.getKey(), entry.getValue().toString());
        }
        allStatesAsStrings.putAll(this.subsystemSpecificStates);
        return allStatesAsStrings;
    }

    public Map<String, String> getInternalStates() {
        return Collections.unmodifiableMap(this.subsystemSpecificStates);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StateBundle)) {
            return false;
        }
        StateBundle state = (StateBundle)o;
        if (this.allStates.size() != state.allStates.size()) {
            return false;
        }
        for (String c : this.allStates.keySet()) {
            if (state.isInState(this.allStates.get(c))) continue;
            return false;
        }
        if (this.componentStates.size() != state.componentStates.size()) {
            return false;
        }
        for (String c : state.componentStates.keySet()) {
            if (state.componentStates.get(c).equals(this.componentStates.get(c))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        for (Enum e : this.allStates.values()) {
            result = 31 * result + e.hashCode();
        }
        for (StateBundle sb : this.componentStates.values()) {
            result += sb.hashCode();
        }
        return result;
    }

    public StateBundle clone() {
        StateBundle b = new StateBundle(this);
        return b;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this.getAllStatesAsStrings().entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            sb.append(entry.getKey()).append(":").append(entry.getValue()).append(",");
        }
        for (Map.Entry<String, Object> entry : this.componentStates.entrySet()) {
            String bundleStr = ((StateBundle)entry.getValue()).toString();
            if (bundleStr.isEmpty()) continue;
            sb.append("Component: ").append(entry.getKey()).append(" ").append(bundleStr).append(",");
        }
        return sb.length() > 0 ? sb.substring(0, sb.length() - 1) : "";
    }

    private void updateLastModified() {
        this.lastModifiedCCSTimeStamp = CCSTimeStamp.currentTime();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.allStates.size() + this.subsystemSpecificStates.size());
        for (Enum enum_ : this.allStates.values()) {
            out.writeObject(enum_.getClass().getName());
            out.writeObject(enum_.toString());
        }
        for (Map.Entry entry : this.subsystemSpecificStates.entrySet()) {
            out.writeObject(entry.getKey());
            out.writeObject(entry.getValue());
        }
        out.writeInt(this.componentStates.size());
        for (Map.Entry entry : this.componentStates.entrySet()) {
            out.writeObject(entry.getKey());
            ((StateBundle)entry.getValue()).writeObject(out);
        }
        out.writeObject(this.getLastModifiedCCSTimeStamp());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int n = in.readInt();
        this.allStates = new ConcurrentHashMap<String, Enum>();
        this.subsystemSpecificStates = new ConcurrentHashMap<String, String>();
        for (int i = 0; i < n; ++i) {
            String className = (String)in.readObject();
            String value = (String)in.readObject();
            try {
                Class<?> c = Class.forName(className);
                Method m = c.getDeclaredMethod("valueOf", String.class);
                Enum e = (Enum)m.invoke(null, value);
                this.allStates.put(c.getSimpleName(), e);
                continue;
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                this.subsystemSpecificStates.put(className, value);
            }
        }
        int nComponents = in.readInt();
        this.componentStates = new ConcurrentHashMap<String, StateBundle>();
        for (int i = 0; i < nComponents; ++i) {
            String componentName = (String)in.readObject();
            StateBundle sb = new StateBundle(new Enum[0]);
            sb.readObject(in);
            this.componentStates.put(componentName, sb);
        }
        this.lastModifiedCCSTimeStamp = (CCSTimeStamp)in.readObject();
    }
}

